/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.extensions.xsd;

import org.eclipse.lemminx.dom.DOMDocument;
import org.eclipse.lemminx.extensions.contentmodel.model.ContentModelManager;
import org.eclipse.lemminx.extensions.xsd.XSDURIResolverExtension;
import org.eclipse.lemminx.extensions.xsd.contentmodel.CMXSDContentModelProvider;
import org.eclipse.lemminx.extensions.xsd.participants.XSDCodeLensParticipant;
import org.eclipse.lemminx.extensions.xsd.participants.XSDCompletionParticipant;
import org.eclipse.lemminx.extensions.xsd.participants.XSDDefinitionParticipant;
import org.eclipse.lemminx.extensions.xsd.participants.XSDHighlightingParticipant;
import org.eclipse.lemminx.extensions.xsd.participants.XSDReferenceParticipant;
import org.eclipse.lemminx.extensions.xsd.participants.XSDRenameParticipant;
import org.eclipse.lemminx.extensions.xsd.participants.diagnostics.XSDDiagnosticsParticipant;
import org.eclipse.lemminx.services.extensions.ICompletionParticipant;
import org.eclipse.lemminx.services.extensions.IDefinitionParticipant;
import org.eclipse.lemminx.services.extensions.IHighlightingParticipant;
import org.eclipse.lemminx.services.extensions.IReferenceParticipant;
import org.eclipse.lemminx.services.extensions.IRenameParticipant;
import org.eclipse.lemminx.services.extensions.IXMLExtension;
import org.eclipse.lemminx.services.extensions.XMLExtensionsRegistry;
import org.eclipse.lemminx.services.extensions.codelens.ICodeLensParticipant;
import org.eclipse.lemminx.services.extensions.diagnostics.IDiagnosticsParticipant;
import org.eclipse.lemminx.services.extensions.save.ISaveContext;
import org.eclipse.lemminx.utils.DOMUtils;
import org.eclipse.lsp4j.InitializeParams;

public class XSDPlugin
implements IXMLExtension {
    private final ICompletionParticipant completionParticipant = new XSDCompletionParticipant();
    private final IDefinitionParticipant definitionParticipant = new XSDDefinitionParticipant();
    private final IDiagnosticsParticipant diagnosticsParticipant = new XSDDiagnosticsParticipant();
    private final IReferenceParticipant referenceParticipant = new XSDReferenceParticipant();
    private final ICodeLensParticipant codeLensParticipant = new XSDCodeLensParticipant();
    private final IHighlightingParticipant highlightingParticipant = new XSDHighlightingParticipant();
    private final IRenameParticipant renameParticipant = new XSDRenameParticipant();
    private XSDURIResolverExtension uiResolver;
    private ContentModelManager modelManager;

    @Override
    public void doSave(ISaveContext context) {
        String documentURI = context.getUri();
        DOMDocument document = context.getDocument(documentURI);
        if (DOMUtils.isXSD(document)) {
            context.collectDocumentToValidate(d -> {
                DOMDocument xml = context.getDocument(d.getDocumentURI());
                return this.modelManager.dependsOnGrammar(xml, context.getUri());
            });
        }
    }

    @Override
    public void start(InitializeParams params, XMLExtensionsRegistry registry) {
        this.uiResolver = new XSDURIResolverExtension(registry.getDocumentProvider());
        registry.getResolverExtensionManager().registerResolver(this.uiResolver);
        CMXSDContentModelProvider modelProvider = new CMXSDContentModelProvider(registry.getResolverExtensionManager());
        this.modelManager = (ContentModelManager)registry.getComponent(ContentModelManager.class);
        this.modelManager.registerModelProvider(modelProvider);
        registry.registerCompletionParticipant(this.completionParticipant);
        registry.registerDefinitionParticipant(this.definitionParticipant);
        registry.registerDiagnosticsParticipant(this.diagnosticsParticipant);
        registry.registerReferenceParticipant(this.referenceParticipant);
        registry.registerCodeLensParticipant(this.codeLensParticipant);
        registry.registerHighlightingParticipant(this.highlightingParticipant);
        registry.registerRenameParticipant(this.renameParticipant);
    }

    @Override
    public void stop(XMLExtensionsRegistry registry) {
        registry.getResolverExtensionManager().unregisterResolver(this.uiResolver);
        registry.unregisterCompletionParticipant(this.completionParticipant);
        registry.unregisterDefinitionParticipant(this.definitionParticipant);
        registry.unregisterDiagnosticsParticipant(this.diagnosticsParticipant);
        registry.unregisterReferenceParticipant(this.referenceParticipant);
        registry.unregisterCodeLensParticipant(this.codeLensParticipant);
        registry.unregisterHighlightingParticipant(this.highlightingParticipant);
        registry.unregisterRenameParticipant(this.renameParticipant);
    }
}

