/*
 * Decompiled with CFR 0.152.
 */
package org.osgi.util.pushstream;

import java.util.Optional;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import org.osgi.util.promise.PromiseFactory;
import org.osgi.util.pushstream.AbstractPushStreamImpl;
import org.osgi.util.pushstream.PushEvent;
import org.osgi.util.pushstream.PushEventConsumer;
import org.osgi.util.pushstream.PushStream;
import org.osgi.util.pushstream.PushStreamProvider;

class UnbufferedPushStreamImpl<T, U extends BlockingQueue<PushEvent<? extends T>>>
extends AbstractPushStreamImpl<T>
implements PushStream<T> {
    protected final Function<PushEventConsumer<T>, AutoCloseable> connector;
    protected final AtomicReference<AutoCloseable> upstream = new AtomicReference();

    UnbufferedPushStreamImpl(PushStreamProvider psp, PromiseFactory promiseFactory, Function<PushEventConsumer<T>, AutoCloseable> connector) {
        super(psp, promiseFactory);
        this.connector = connector;
    }

    @Override
    protected boolean close(PushEvent<T> event, boolean sendDownStreamEvent) {
        if (super.close(event, sendDownStreamEvent)) {
            this.upstreamClose(event);
            return true;
        }
        return false;
    }

    @Override
    protected void upstreamClose(PushEvent<?> close) {
        Optional.ofNullable(this.upstream.getAndSet(() -> {})).ifPresent(c -> {
            try {
                c.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
    }

    @Override
    protected boolean begin() {
        if (this.closed.compareAndSet(AbstractPushStreamImpl.State.BUILDING, AbstractPushStreamImpl.State.STARTED)) {
            AutoCloseable toClose = this.connector.apply(this::handleEvent);
            if (!this.upstream.compareAndSet(null, toClose)) {
                try {
                    toClose.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (this.closed.get() == AbstractPushStreamImpl.State.CLOSED && this.upstream.compareAndSet(toClose, null)) {
                try {
                    toClose.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            return true;
        }
        return false;
    }
}

