/*
 * Decompiled with CFR 0.152.
 */
package org.hamcrest.text.pattern.internal.naming;

import java.util.HashMap;
import java.util.Map;
import org.hamcrest.text.pattern.internal.naming.IndexSequence;
import org.hamcrest.text.pattern.internal.naming.Path;

public class GroupNamespace {
    private final GroupNamespace parent;
    private final Map<String, GroupNamespace> bindings = new HashMap<String, GroupNamespace>();
    private final IndexSequence nextGroupIndex;
    private final int groupIndex;

    private GroupNamespace(GroupNamespace parent, IndexSequence nextGroupIndex) {
        this.parent = parent;
        this.nextGroupIndex = nextGroupIndex;
        this.groupIndex = nextGroupIndex.next();
    }

    public GroupNamespace() {
        this(null, new IndexSequence());
    }

    public int toIndex() {
        return this.groupIndex;
    }

    public GroupNamespace create(String name) {
        if (this.bindings.containsKey(name)) {
            throw new IllegalArgumentException("duplicate name '" + name + "'");
        }
        GroupNamespace child = new GroupNamespace(this, this.nextGroupIndex);
        this.bindings.put(name, child);
        return child;
    }

    public int resolve(String pathAsString) {
        return this.resolve(Path.parse(pathAsString));
    }

    public int resolve(Path path) {
        return this.environmentContaining(path.head()).resolveInternally(path.tail());
    }

    public int resolveInternally(Path path) {
        if (path.size() == 0) {
            return this.groupIndex;
        }
        if (this.bindings.containsKey(path.head())) {
            return this.bindings.get(path.head()).resolveInternally(path.tail());
        }
        throw new IllegalArgumentException("name '" + path.head() + "' not bound");
    }

    private GroupNamespace environmentContaining(String name) {
        if (this.bindings.containsKey(name)) {
            return this.bindings.get(name);
        }
        if (this.parent != null) {
            return this.parent.environmentContaining(name);
        }
        throw new IllegalArgumentException("name '" + name + "' not bound");
    }
}

