/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.mrep;

import com.sun.javatest.report.Report;
import com.sun.javatest.tool.IconFactory;
import com.sun.javatest.tool.UIFactory;
import com.sun.javatest.util.FileInfoCache;
import java.awt.Component;
import java.io.File;
import javax.swing.Icon;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileView;

class ReportDirChooser
extends JFileChooser {
    public static final int NEW = 0;
    public static final int OPEN = 1;
    private FileInfoCache cache = new FileInfoCache();
    private int mode;
    private File reportDir;
    private UIFactory uif = new UIFactory(this, null);
    private Icon icon = IconFactory.getSelectableFolderIcon();

    public ReportDirChooser() {
        this(new File(System.getProperty("user.dir")));
    }

    public ReportDirChooser(File initialDir) {
        super(initialDir);
        this.setAcceptAllFileFilterUsed(false);
        this.setFileFilter(new RDC_FileFilter());
        this.setFileView(new RDC_FileView());
        this.setFileSelectionMode(2);
    }

    public void setMode(int mode) {
        this.mode = mode;
        switch (mode) {
            case 0: {
                this.setApproveButtonText(this.uif.getI18NString("rdc.new.btn"));
                this.setApproveButtonToolTipText(this.uif.getI18NString("rdc.new.tip"));
                this.setDialogTitle(this.uif.getI18NString("rdc.new.title"));
                break;
            }
            case 1: {
                this.setApproveButtonText(this.uif.getI18NString("rdc.open.btn"));
                this.setApproveButtonToolTipText(this.uif.getI18NString("rdc.open.tip"));
                this.setDialogTitle(this.uif.getI18NString("rdc.open.title"));
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
    }

    public File getSelectedReportDirectory() {
        return this.reportDir;
    }

    public int showDialog(Component parent) {
        return this.showDialog(parent, this.getApproveButtonText());
    }

    @Override
    public void approveSelection() {
        File file = this.getSelectedFile();
        if (this.mode == 0) {
            this.approveNewSelection(file);
        } else {
            this.approveOpenSelection(file);
        }
    }

    private void approveNewSelection(File file) {
        if (file.exists()) {
            if (this.isReportDirectory(file) || this.isEmptyDirectory(file)) {
                this.reportDir = file;
                super.approveSelection();
            } else if (file.isDirectory()) {
                this.setCurrentDirectory(file);
                this.setSelectedFile(null);
                this.setSelectedFiles(null);
            } else {
                this.uif.showError("rdc.notADir", (Object)file);
            }
        } else {
            this.reportDir = file;
            super.approveSelection();
        }
    }

    private void approveOpenSelection(File file) {
        if (file.exists()) {
            if (this.isReportDirectory(file)) {
                this.reportDir = file;
                super.approveSelection();
            } else if (this.isDirectory(file)) {
                this.setCurrentDirectory(file);
                this.setSelectedFile(null);
                this.setSelectedFiles(null);
            } else {
                this.uif.showError("rdc.notADir", (Object)file);
            }
        } else {
            this.uif.showError("rdc.cantOpen", (Object)file);
        }
    }

    private boolean isDirectory(File f) {
        return f.isDirectory();
    }

    private boolean isReportDirectory(File f) {
        if (this.isIgnoreable(f)) {
            return false;
        }
        Boolean b = this.cache.get(f);
        if (b == null) {
            boolean v = Report.isReportDirectory(f);
            String[] l = f.list();
            if (l != null) {
                for (String aL : l) {
                    if (!aL.endsWith(".html")) continue;
                    v = true;
                }
            }
            this.cache.put(f, v);
            return v;
        }
        return b;
    }

    private boolean isEmptyDirectory(File f) {
        return f.isDirectory() && f.list().length == 0;
    }

    private boolean isIgnoreable(File f) {
        return f.getName().isEmpty();
    }

    static {
        Class<Report> clazz = Report.class;
    }

    private class RDC_FileFilter
    extends FileFilter {
        private RDC_FileFilter() {
        }

        @Override
        public boolean accept(File f) {
            return ReportDirChooser.this.isDirectory(f);
        }

        @Override
        public String getDescription() {
            return ReportDirChooser.this.uif.getI18NString("rdc.ft");
        }
    }

    private class RDC_FileView
    extends FileView {
        private RDC_FileView() {
        }

        @Override
        public String getDescription(File f) {
            return null;
        }

        @Override
        public Icon getIcon(File f) {
            return ReportDirChooser.this.isReportDirectory(f) ? ReportDirChooser.this.icon : null;
        }

        @Override
        public String getName(File f) {
            String name = f.getName();
            return name.isEmpty() ? f.getPath() : name;
        }

        @Override
        public String getTypeDescription(File f) {
            return null;
        }

        @Override
        public Boolean isTraversable(File f) {
            return ReportDirChooser.this.isDirectory(f) && !ReportDirChooser.this.isReportDirectory(f) ? Boolean.TRUE : Boolean.FALSE;
        }
    }
}

