/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.util;

import java.util.ArrayDeque;
import java.util.Iterator;
import java.util.Queue;

public class ReadAheadIterator<T>
implements Iterator<T> {
    public static final int NONE = 0;
    public static final int LIMITED = 1;
    public static final int FULL = 2;
    private static final int DEFAULT_LIMITED_READAHEAD = 100;
    private static int workerNum;
    private final Queue<T> queue = new ArrayDeque<T>();
    private final Iterator<T> source;
    private boolean sourceHasNext;
    private int minQueueSize;
    private int maxQueueSize;
    private int usedCount;
    private Thread worker;

    public ReadAheadIterator(Iterator<T> source, int mode) {
        this(source, mode, 100);
    }

    public ReadAheadIterator(Iterator<T> source, int mode, int amount) {
        this.source = source;
        this.setMode(mode, amount);
    }

    public synchronized boolean isReadAheadComplete() {
        return this.worker == null ? !this.source.hasNext() : !this.sourceHasNext;
    }

    public synchronized int getItemsFoundCount() {
        return this.usedCount + this.queue.size();
    }

    @Deprecated
    public synchronized boolean isSourceExhausted() {
        return this.worker == null ? !this.source.hasNext() : !this.sourceHasNext;
    }

    @Deprecated
    public synchronized int getUsedElementCount() {
        return this.usedCount;
    }

    @Deprecated
    public synchronized int getOutputQueueSize() {
        return this.queue.size();
    }

    synchronized void setMode(int mode, int amount) {
        switch (mode) {
            case 0: {
                this.minQueueSize = 0;
                this.maxQueueSize = 0;
                if (this.worker == null) break;
                this.worker = null;
                this.notifyAll();
                break;
            }
            case 1: {
                if (amount <= 0) {
                    throw new IllegalArgumentException();
                }
                this.minQueueSize = Math.min(10, amount);
                this.maxQueueSize = amount;
                break;
            }
            case 2: {
                this.minQueueSize = 10;
                this.maxQueueSize = Integer.MAX_VALUE;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    @Override
    public synchronized boolean hasNext() {
        return !this.queue.isEmpty() || (this.worker == null ? this.source.hasNext() : this.sourceHasNext);
    }

    @Override
    public synchronized T next() {
        T result = this.queue.poll();
        if (result == null) {
            if (this.maxQueueSize == 0) {
                result = this.source.next();
            } else {
                if (this.worker == null) {
                    this.sourceHasNext = this.source.hasNext();
                    if (this.sourceHasNext) {
                        this.worker = new Thread("ReadAheadIterator" + workerNum++){

                            @Override
                            public void run() {
                                ReadAheadIterator.this.readAhead();
                            }
                        };
                        this.worker.start();
                    }
                } else {
                    this.notifyAll();
                }
                while (this.sourceHasNext && this.queue.isEmpty()) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                }
                result = this.queue.poll();
            }
        } else if (this.sourceHasNext && this.queue.size() < this.minQueueSize) {
            this.notifyAll();
        }
        if (result != null) {
            ++this.usedCount;
        }
        return result;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void readAhead() {
        boolean keepReading;
        Thread thisThread = Thread.currentThread();
        ReadAheadIterator readAheadIterator = this;
        synchronized (readAheadIterator) {
            keepReading = this.sourceHasNext && thisThread == this.worker;
        }
        try {
            while (keepReading) {
                T srcNext = this.source.next();
                boolean srcHasNext = this.source.hasNext();
                ReadAheadIterator readAheadIterator2 = this;
                synchronized (readAheadIterator2) {
                    this.queue.offer(srcNext);
                    this.sourceHasNext = srcHasNext;
                    this.notifyAll();
                    boolean bl = keepReading = this.sourceHasNext && thisThread == this.worker;
                    while (this.queue.size() >= this.maxQueueSize && keepReading) {
                        this.wait();
                        keepReading = this.sourceHasNext && thisThread == this.worker;
                    }
                }
            }
            return;
        }
        catch (InterruptedException interruptedException) {
            return;
        }
        finally {
            readAheadIterator = this;
            synchronized (readAheadIterator) {
                if (thisThread == this.worker) {
                    this.worker = null;
                }
            }
        }
    }
}

