/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.util;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.ConsoleHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;

public class Log {
    public static final String JTHARNESS_LOGGING_LEVEL_SYS_PROP = "jtharness.logging.level";
    private static Logger LOG;
    private static Level CURRENT_LEVEL;
    private static final String DATE_TIME_FORMAT;

    public static void resetLoggingSettings(Level newLevel) {
        LOG = Logger.getLogger("jtharness");
        CURRENT_LEVEL = newLevel;
        ConsoleHandler handler = new ConsoleHandler();
        handler.setFormatter(new SimpleFormatter(){

            @Override
            public synchronized String formatMessage(LogRecord lr) {
                return this.createMessage(lr);
            }

            @Override
            public synchronized String format(LogRecord lr) {
                return this.createMessage(lr);
            }

            private String createMessage(LogRecord lr) {
                return DATE_TIME_FORMAT + String.format("[%1$s] %2$s%n", lr.getLevel().getName(), lr.getMessage());
            }
        });
        handler.setLevel(CURRENT_LEVEL);
        for (Handler defaultHandler : LOG.getHandlers()) {
            LOG.removeHandler(defaultHandler);
        }
        LOG.setUseParentHandlers(false);
        LOG.setLevel(CURRENT_LEVEL);
        LOG.addHandler(handler);
    }

    public static void info(String message) {
        if (!LOG.isLoggable(CURRENT_LEVEL)) {
            return;
        }
        LOG.log(Level.INFO, Log.callerPrefix() + message);
    }

    public static void finest(String message) {
        if (!LOG.isLoggable(CURRENT_LEVEL)) {
            return;
        }
        LOG.log(Level.FINEST, Log.callerPrefix() + message);
    }

    public static void finer(String message) {
        if (!LOG.isLoggable(CURRENT_LEVEL)) {
            return;
        }
        LOG.log(Level.FINER, Log.callerPrefix() + message);
    }

    public static void fine(String message) {
        if (!LOG.isLoggable(CURRENT_LEVEL)) {
            return;
        }
        LOG.log(Level.FINE, Log.callerPrefix() + message);
    }

    public static void warning(String message) {
        if (!LOG.isLoggable(CURRENT_LEVEL)) {
            return;
        }
        LOG.log(Level.WARNING, Log.callerPrefix() + message);
    }

    public static void error(String message) {
        if (!LOG.isLoggable(CURRENT_LEVEL)) {
            return;
        }
        LOG.log(Level.SEVERE, Log.callerPrefix() + message);
    }

    private static String callerPrefix() {
        StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
        if (stackTrace.length >= 4) {
            StackTraceElement stackTraceElement = stackTrace[3];
            String callerClassName = stackTraceElement.getClassName();
            String callingMethodName = stackTraceElement.getMethodName();
            int lastDotIndex = callerClassName.lastIndexOf(46);
            String simpleClassName = lastDotIndex < 0 ? callerClassName : callerClassName.substring(lastDotIndex + 1);
            return "(" + simpleClassName + "." + callingMethodName + ") ";
        }
        String result = "";
        return result;
    }

    static {
        DATE_TIME_FORMAT = new SimpleDateFormat("dd-MMM-yyyy HH:mm:ss ").format(new Date());
        Log.resetLoggingSettings(Level.parse(System.getProperty(JTHARNESS_LOGGING_LEVEL_SYS_PROP, Level.INFO.getName())));
    }
}

