/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.mrep;

import com.sun.javatest.tool.UIFactory;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.MatteBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class ConflictResolutionDialog
extends JDialog {
    private String resolveButtonStr = "resolve";
    private String cancelButtonStr = "cancel";
    private String useMostRecentCheckBoxStr = "useMost";
    private JCheckBox preferredReportCheckBox;
    private JCheckBox useMostRecentCheckBox;
    private JButton resolveButton;
    private JButton cancelButton;
    private DefaultListModel<String> listModel;
    private JList<?> list;
    private int selectedIndex;
    private boolean bPreferredReport;
    private boolean bUseMostRecent;
    private UIFactory uif;
    private boolean cancel = false;

    public ConflictResolutionDialog(JFrame parent, String testName, String[] reportsList, boolean bPreferredSet, UIFactory uif) {
        super((Frame)parent, true);
        this.uif = uif;
        this.setName("conflict");
        this.setTitle(uif.getI18NString("conflict.name"));
        this.setResizable(false);
        Container cp = this.getContentPane();
        cp.setLayout(new BorderLayout());
        this.setDefaultCloseOperation(0);
        ConflictResolutionActionListener conflictResolutionListener = new ConflictResolutionActionListener();
        JLabel text = uif.createLabel("conflict.text");
        text.setText(text.getText() + " " + testName);
        text.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        JPanel textPanel = uif.createPanel("conflict.text.panel", new FlowLayout(1));
        textPanel.add(text);
        Box vBox = Box.createVerticalBox();
        JLabel chooseText = uif.createLabel("conflict.chooseText");
        JPanel chooseTextPanel = uif.createPanel("conflict.choosePanel", new FlowLayout(1));
        chooseTextPanel.add(chooseText);
        this.listModel = new DefaultListModel();
        for (String aReportsList : reportsList) {
            this.listModel.addElement(aReportsList);
        }
        this.list = uif.createList("conflict.list", this.listModel);
        this.list.setSelectionMode(0);
        ReportsListSelectionListener rl = new ReportsListSelectionListener();
        this.list.addListSelectionListener(rl);
        MatteBorder brd = BorderFactory.createMatteBorder(1, 1, 1, 1, Color.BLACK);
        this.list.setBorder(brd);
        JScrollPane scrollPane = uif.createScrollPane(this.list);
        Box hBox = Box.createHorizontalBox();
        hBox.add(scrollPane);
        this.preferredReportCheckBox = uif.createCheckBox("conflict.preffered");
        this.preferredReportCheckBox.setMnemonic(0);
        this.preferredReportCheckBox.setEnabled(false);
        JPanel preferredReportPanel = new JPanel(new FlowLayout(0));
        preferredReportPanel.add(this.preferredReportCheckBox);
        this.useMostRecentCheckBox = uif.createCheckBox("conflict.most.recent");
        this.useMostRecentCheckBox.setMnemonic(1);
        this.useMostRecentCheckBox.addActionListener(conflictResolutionListener);
        this.useMostRecentCheckBox.setActionCommand(this.useMostRecentCheckBoxStr);
        JPanel useRecentPanel = uif.createPanel("conflict.recent", new FlowLayout(0));
        useRecentPanel.add(this.useMostRecentCheckBox);
        vBox.setBorder(BorderFactory.createEmptyBorder(0, 20, 0, 20));
        vBox.add(chooseTextPanel);
        vBox.add(hBox);
        if (!bPreferredSet) {
            vBox.add(preferredReportPanel);
        }
        vBox.add(useRecentPanel);
        JPanel controlButtonsPanel = uif.createPanel("conflict.control", new FlowLayout(1));
        JPanel p2 = new JPanel();
        p2.setLayout(new GridLayout(1, 0, 5, 5));
        this.resolveButton = uif.createButton("conflict.resolve");
        this.resolveButton.setMnemonic(0);
        this.resolveButton.addActionListener(conflictResolutionListener);
        this.resolveButton.setActionCommand(this.resolveButtonStr);
        this.resolveButton.setEnabled(false);
        this.cancelButton = uif.createButton("conflict.cancel");
        this.cancelButton.addActionListener(conflictResolutionListener);
        this.cancelButton.setActionCommand(this.cancelButtonStr);
        p2.add(this.resolveButton);
        p2.add(this.cancelButton);
        controlButtonsPanel.add(p2);
        controlButtonsPanel.setBorder(BorderFactory.createEmptyBorder(20, 0, 0, 0));
        cp.add((Component)textPanel, "North");
        cp.add((Component)vBox, "Center");
        cp.add((Component)controlButtonsPanel, "South");
        this.pack();
        this.setLocationRelativeTo(parent);
    }

    public int getSelectedIndex() {
        return this.selectedIndex;
    }

    public boolean getPreferredReport() {
        return this.bPreferredReport;
    }

    public boolean getUseMostRecent() {
        return this.bUseMostRecent;
    }

    public boolean wasCanceled() {
        return this.cancel;
    }

    class ReportsListSelectionListener
    implements ListSelectionListener {
        ReportsListSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (e.getValueIsAdjusting()) {
                return;
            }
            if (ConflictResolutionDialog.this.list.getSelectedValues().length == 0 && !ConflictResolutionDialog.this.useMostRecentCheckBox.isSelected()) {
                ConflictResolutionDialog.this.resolveButton.setEnabled(false);
            } else {
                ConflictResolutionDialog.this.resolveButton.setEnabled(true);
            }
            if (ConflictResolutionDialog.this.list.getSelectedValues().length == 0) {
                ConflictResolutionDialog.this.preferredReportCheckBox.setEnabled(false);
            } else {
                ConflictResolutionDialog.this.preferredReportCheckBox.setEnabled(true);
            }
        }
    }

    class ConflictResolutionActionListener
    implements ActionListener {
        ConflictResolutionActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String cmd = e.getActionCommand();
            if (cmd.equals(ConflictResolutionDialog.this.cancelButtonStr)) {
                if (ConflictResolutionDialog.this.uif.showYesNoDialog("conflict.areyousure") != 0) {
                    return;
                }
                ConflictResolutionDialog.this.cancel = true;
                ConflictResolutionDialog.this.dispose();
            } else if (cmd.equals(ConflictResolutionDialog.this.resolveButtonStr)) {
                ConflictResolutionDialog.this.bUseMostRecent = ConflictResolutionDialog.this.useMostRecentCheckBox.isSelected();
                ConflictResolutionDialog.this.bPreferredReport = ConflictResolutionDialog.this.preferredReportCheckBox.isSelected();
                ConflictResolutionDialog.this.selectedIndex = ConflictResolutionDialog.this.list.getSelectedIndex();
                ConflictResolutionDialog.this.dispose();
            } else if (cmd.equals(ConflictResolutionDialog.this.useMostRecentCheckBoxStr)) {
                if (ConflictResolutionDialog.this.list.getSelectedValues().length == 0 && !ConflictResolutionDialog.this.useMostRecentCheckBox.isSelected()) {
                    ConflictResolutionDialog.this.resolveButton.setEnabled(false);
                } else {
                    ConflictResolutionDialog.this.resolveButton.setEnabled(true);
                }
                if (ConflictResolutionDialog.this.useMostRecentCheckBox.isSelected()) {
                    ConflictResolutionDialog.this.list.setEnabled(false);
                    ConflictResolutionDialog.this.preferredReportCheckBox.setEnabled(false);
                } else {
                    ConflictResolutionDialog.this.list.setEnabled(true);
                    ConflictResolutionDialog.this.preferredReportCheckBox.setEnabled(true);
                }
            }
        }
    }

    static class CancelException
    extends Exception {
        CancelException() {
        }
    }
}

