/*
 * Decompiled with CFR 0.152.
 */
package com.sun.interview;

import com.sun.interview.Interview;
import com.sun.interview.Question;
import java.util.Map;
import java.util.Vector;

public abstract class StringListQuestion
extends Question {
    private static final String[] EMPTY = new String[0];
    protected String[] value;
    private String[] defaultValue;
    private boolean duplicatesAllowed = true;

    protected StringListQuestion(Interview interview, String tag) {
        super(interview, tag);
        this.clear();
        this.setDefaultValue(this.value);
    }

    protected static boolean equal(String[] s1, String ... s2) {
        if (s1 == null || s2 == null) {
            return s1 == s2;
        }
        if (s1.length != s2.length) {
            return false;
        }
        for (int i = 0; i < s1.length; ++i) {
            if (StringListQuestion.equal(s1[i], s2[i])) continue;
            return false;
        }
        return true;
    }

    protected static boolean equal(String s1, String s2) {
        return s1 == null ? s2 == null : s1.equals(s2);
    }

    protected static String[] split(String s) {
        if (s == null) {
            return EMPTY;
        }
        char sep = '\n';
        Vector<String> v = new Vector<String>();
        int start = -1;
        for (int i = 0; i < s.length(); ++i) {
            if (s.charAt(i) == sep) {
                if (start != -1) {
                    v.add(s.substring(start, i));
                }
                start = -1;
                continue;
            }
            if (start != -1) continue;
            start = i;
        }
        if (start != -1) {
            v.add(s.substring(start));
        }
        if (v.isEmpty()) {
            return EMPTY;
        }
        return v.toArray(new String[v.size()]);
    }

    public String[] getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(String ... v) {
        this.defaultValue = v;
    }

    public boolean isDuplicatesAllowed() {
        return this.duplicatesAllowed;
    }

    public void setDuplicatesAllowed(boolean b) {
        this.duplicatesAllowed = b;
    }

    public String[] getValue() {
        return this.value;
    }

    @Override
    public void setValue(String s) {
        this.setValue(s == null ? null : StringListQuestion.split(s));
    }

    public void setValue(String ... newValue) {
        if (newValue != null) {
            for (String aNewValue : newValue) {
                if (aNewValue != null && !aNewValue.contains("\n")) continue;
                throw new IllegalArgumentException();
            }
        }
        if (!StringListQuestion.equal(newValue, this.value)) {
            if (newValue == null) {
                this.value = null;
            } else {
                this.value = new String[newValue.length];
                System.arraycopy(newValue, 0, this.value, 0, newValue.length);
            }
            this.interview.updatePath(this);
            this.interview.setEdited(true);
        }
    }

    public String[] getValueOnPath() throws Interview.NotOnPathFault {
        this.interview.verifyPathContains(this);
        return this.getValue();
    }

    @Override
    public String getStringValue() {
        if (this.value == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (String aValue : this.value) {
            if (sb.length() > 0) {
                sb.append('\n');
            }
            if (aValue == null) continue;
            sb.append(aValue);
        }
        return sb.toString();
    }

    @Override
    public boolean isValueValid() {
        return true;
    }

    @Override
    public boolean isValueAlwaysValid() {
        return false;
    }

    @Override
    public void clear() {
        this.setValue(this.defaultValue);
    }

    @Override
    protected void save(Map<String, String> data) {
        if (this.value != null) {
            data.put(this.tag, this.getStringValue());
        }
    }
}

