/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.core.metamodelapi.bindable;

import com.sun.ts.lib.harness.Status;
import ee.jakarta.tck.persistence.common.PMClientBase;
import jakarta.persistence.metamodel.Bindable;
import jakarta.persistence.metamodel.EntityType;
import jakarta.persistence.metamodel.Metamodel;
import java.util.Properties;
import java.util.Set;

public class Client
extends PMClientBase {
    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws Exception {
        this.logTrace("setup");
        try {
            super.setup(args, p);
            this.removeTestData();
        }
        catch (Exception e) {
            this.logErr("Exception: ", e);
            throw new Exception("Setup failed:", e);
        }
    }

    public void getBindableType() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            this.logTrace("Obtained Non-null Metamodel from EntityManager");
            Set aSet = metaModel.getEntities();
            if (aSet != null) {
                this.logTrace("Obtained Non-null Set of EntityType");
                for (EntityType eType : aSet) {
                    this.logTrace("entity's BindableType is  = " + eType.getBindableType());
                    if (eType.getBindableType().equals((Object)Bindable.BindableType.ENTITY_TYPE)) {
                        this.logTrace("as Expected BindableType is ENTITY_TYPE");
                        pass = true;
                        continue;
                    }
                    this.logTrace("bindableType is non ENTITY_TYPE");
                }
            }
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getBindableType failed");
        }
    }

    public void getBindableJavaType() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            this.logTrace("Obtained Non-null Metamodel from EntityManager");
            Set aSet = metaModel.getEntities();
            if (aSet != null) {
                this.logTrace("Obtained Non-null Set of EntityType");
                for (EntityType eType : aSet) {
                    this.logTrace("entity's BindableJavaType is  = " + eType.getBindableJavaType().getName());
                    String bindableJavaType = eType.getBindableJavaType().getName();
                    if (bindableJavaType == null) continue;
                    if (bindableJavaType.equals("ee.jakarta.tck.persistence.core.metamodelapi.bindable.A")) {
                        this.logTrace("as Expected BindableJavaType for A is " + bindableJavaType);
                        pass = true;
                        continue;
                    }
                    this.logTrace("bindableJavaType is incorrect");
                }
            }
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getBindableJavaType failed");
        }
    }

    public void cleanup() throws Exception {
        this.logTrace("Cleanup data");
        this.removeTestData();
        this.logTrace("cleanup complete, calling super.cleanup");
        super.cleanup();
    }

    private void removeTestData() {
        this.logTrace("removeTestData");
        if (this.getEntityTransaction().isActive()) {
            this.getEntityTransaction().rollback();
        }
    }
}

