/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ant.taskdefs.common;

import java.util.StringTokenizer;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public class ElementAppend
extends Task {
    private String original;
    private String suffix;
    private String prefix;
    private String property;

    public void setOriginal(String ptn) {
        this.original = ptn;
    }

    public void setSuffix(String sfx) {
        this.suffix = sfx;
    }

    public void setPrefix(String pre) {
        this.prefix = pre;
    }

    public void setProperty(String p) {
        this.property = p;
    }

    private String removeSlash(String s) {
        if (s == null || s.length() == 0) {
            return s;
        }
        if (s.startsWith("/") || s.startsWith("\\")) {
            s = s.substring(1);
        }
        if (s.endsWith("/") || s.endsWith("\\")) {
            s = s.substring(0, s.length() - 1);
        }
        return s;
    }

    public void execute() throws BuildException {
        if (this.original == null || this.original.length() == 0 || this.property == null || this.property.length() == 0) {
            throw new BuildException("original or property cannot be empty.");
        }
        boolean prefixPresent = true;
        boolean suffixPresent = true;
        if (this.prefix == null || this.prefix.length() == 0) {
            prefixPresent = false;
        }
        if (this.suffix == null || this.suffix.length() == 0) {
            suffixPresent = false;
        }
        if (!prefixPresent && !suffixPresent) {
            throw new BuildException("both suffix and prefix are empty.");
        }
        int originalLen = this.original.length();
        StringTokenizer st = new StringTokenizer(this.original, ", \t\n\r\f");
        int tokens = st.countTokens();
        StringBuffer result = new StringBuffer();
        while (st.hasMoreTokens()) {
            String item = st.nextToken();
            item = this.removeSlash(item);
            if (prefixPresent && !item.startsWith(this.prefix)) {
                result.append(this.prefix).append("/").append(item);
            } else {
                result.append(item);
            }
            if (suffixPresent && !item.endsWith(this.suffix)) {
                result.append("/").append(this.suffix);
            }
            result.append(",");
        }
        String returnVal = null;
        returnVal = tokens > 0 ? result.substring(0, result.length() - 1) : result.toString();
        this.project.setProperty(this.property, returnVal);
    }
}

