/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.docs.intent.parser.modelingunit;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.mylyn.docs.intent.core.document.IntentDocumentPackage;
import org.eclipse.mylyn.docs.intent.core.document.TypeLabel;
import org.eclipse.mylyn.docs.intent.core.document.UnitInstruction;
import org.eclipse.mylyn.docs.intent.core.modelingunit.AbstractValue;
import org.eclipse.mylyn.docs.intent.core.modelingunit.AffectationOperator;
import org.eclipse.mylyn.docs.intent.core.modelingunit.AnnotationDeclaration;
import org.eclipse.mylyn.docs.intent.core.modelingunit.ContributionInstruction;
import org.eclipse.mylyn.docs.intent.core.modelingunit.ExternalContentReference;
import org.eclipse.mylyn.docs.intent.core.modelingunit.InstanciationInstruction;
import org.eclipse.mylyn.docs.intent.core.modelingunit.InstanciationInstructionReference;
import org.eclipse.mylyn.docs.intent.core.modelingunit.IntentReferenceInModelingUnit;
import org.eclipse.mylyn.docs.intent.core.modelingunit.LabelInModelingUnit;
import org.eclipse.mylyn.docs.intent.core.modelingunit.ModelingUnit;
import org.eclipse.mylyn.docs.intent.core.modelingunit.ModelingUnitFactory;
import org.eclipse.mylyn.docs.intent.core.modelingunit.ModelingUnitInstructionReference;
import org.eclipse.mylyn.docs.intent.core.modelingunit.NativeValue;
import org.eclipse.mylyn.docs.intent.core.modelingunit.NewObjectValue;
import org.eclipse.mylyn.docs.intent.core.modelingunit.ReferenceValue;
import org.eclipse.mylyn.docs.intent.core.modelingunit.ResourceDeclaration;
import org.eclipse.mylyn.docs.intent.core.modelingunit.StructuralFeatureAffectation;
import org.eclipse.mylyn.docs.intent.core.modelingunit.TypeReference;
import org.eclipse.mylyn.docs.intent.parser.modelingunit.Messages;
import org.eclipse.mylyn.docs.intent.parser.modelingunit.ModelingUnitParser;
import org.eclipse.mylyn.docs.intent.parser.modelingunit.ParseException;
import org.eclipse.mylyn.docs.intent.parser.modelingunit.parser.linker.ModelingUnitLinker;
import org.eclipse.mylyn.docs.intent.parser.modelingunit.parser.utils.Location;
import org.eclipse.mylyn.docs.intent.parser.modelingunit.parser.utils.ModelingUnitContentManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModelingUnitParserImpl
implements ModelingUnitParser {
    private static final String QUOTE = "\"";
    private static final String STRING_REGEX = "([a-zA-z0-9.:_-]+)";
    private static final String STRING_WITH_QUOTES_REGEX = "(\"[^\"]*\")";
    private static final String TOKEN_DELIMITER = ",";

    public ModelingUnitParserImpl() {
        this.init();
    }

    public boolean isParserFor(String contentToParse) {
        return contentToParse.startsWith("@M") && contentToParse.endsWith("M@");
    }

    private void init() {
        this.registerEPackages();
    }

    private void registerEPackages() {
        IntentDocumentPackage.eINSTANCE.eClass();
    }

    @Override
    public EObject parseString(String contentToParse) throws ParseException {
        return this.parseString(0, contentToParse);
    }

    @Override
    public EObject parseString(int rootOffset, String stringToParse) throws ParseException {
        ModelingUnit modelingUnit = ModelingUnitFactory.eINSTANCE.createModelingUnit();
        Pattern modelingUnitPattern = Pattern.compile("@M([ \t\f]+([a-zA-z0-9.:_-]+))?([ \t\f]+\\[(([a-zA-z0-9.:_-]+))\\])?\\s*");
        Matcher matcher = modelingUnitPattern.matcher(stringToParse);
        matcher.find();
        if (matcher.group(2) != null) {
            modelingUnit.setName(matcher.group(2));
        }
        int startOffset = matcher.group().length();
        int endOffset = stringToParse.lastIndexOf("M@");
        ModelingUnitContentManager<UnitInstruction> manager = new ModelingUnitContentManager<UnitInstruction>();
        manager.addAllContent(this.getResourceDeclarations(rootOffset, stringToParse));
        manager.addAllContent(this.getInstanciationInstructions(rootOffset, stringToParse, true));
        manager.addAllContent(this.getContributionInstructions(rootOffset, stringToParse, true));
        manager.addAllContent(this.getIntentSectionReferencesinModelingUnit(stringToParse));
        manager.addAllContent(this.getAnnotationDeclarations(stringToParse));
        manager.addAllContent(this.getLabelsinModelingUnit(stringToParse));
        manager.addAllContent(this.getExternalContentReferencesInModelingUnit(stringToParse));
        manager.validateContent(stringToParse, startOffset, endOffset, rootOffset);
        modelingUnit.getInstructions().addAll(manager.getContent().values());
        new ModelingUnitLinker().resolveInternalLinks(modelingUnit);
        return modelingUnit;
    }

    private Map<Location, UnitInstruction> getContributionInstructions(int rootOffset, String string, boolean lineBreak) throws ParseException {
        HashMap<Location, UnitInstruction> res = new HashMap<Location, UnitInstruction>();
        Pattern startPattern = Pattern.compile("^\\s*([a-zA-z0-9.:_-]+)\\s*\\{\\s*", 40);
        Matcher matcher = startPattern.matcher(string);
        int index = 0;
        while (matcher.find(index)) {
            ContributionInstruction instance = ModelingUnitFactory.eINSTANCE.createContributionInstruction();
            instance.setLineBreak(lineBreak);
            ModelingUnitInstructionReference ref = ModelingUnitFactory.eINSTANCE.createModelingUnitInstructionReference();
            ref.setIntentHref(matcher.group(1));
            instance.setContributionReference(ref);
            index = matcher.group().length() + matcher.start();
            try {
                int endIndex = ModelingUnitParserImpl.getEndIndex(string, index, '}');
                String stringContent = string.substring(index, endIndex);
                ModelingUnitContentManager<UnitInstruction> manager = new ModelingUnitContentManager<UnitInstruction>();
                manager.addAllContent(this.getStructuralFeatureAffectations(rootOffset + index, stringContent));
                manager.addAllContent(this.getIntentSectionReferencesinModelingUnit(stringContent));
                manager.addAllContent(this.getAnnotationDeclarations(stringContent));
                manager.addAllContent(this.getLabelsinModelingUnit(stringContent));
                manager.validateContent(stringContent, index + rootOffset);
                instance.getContributions().addAll(manager.getContent().values());
                index = endIndex;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                int spaceLength = 0;
                Matcher spaceMatcher = Pattern.compile("^\\s+").matcher(matcher.group());
                if (spaceMatcher.find()) {
                    spaceLength += spaceMatcher.group().length();
                }
                throw new ParseException(Messages.getString("ModelingUnitParserImpl.INCORRECT_CONTRIBUTION_END", matcher.group().trim()), spaceLength + rootOffset + matcher.start(), matcher.group().trim().length());
            }
            res.put(new Location(matcher.start(), index), (UnitInstruction)instance);
        }
        return res;
    }

    private Map<Location, UnitInstruction> getInstanciationInstructions(int rootOffset, String string, boolean lineBreak) throws ParseException {
        HashMap<Location, UnitInstruction> res = new HashMap<Location, UnitInstruction>();
        Pattern startPattern = Pattern.compile("new\\s+([a-zA-z0-9.:_-]+)(\\s+([a-zA-z0-9.:_-]+))?\\s*\\{\\s*", 40);
        Matcher matcher = startPattern.matcher(string);
        int index = 0;
        while (matcher.find(index)) {
            InstanciationInstruction instance = ModelingUnitFactory.eINSTANCE.createInstanciationInstruction();
            instance.setLineBreak(lineBreak);
            TypeReference typeReference = ModelingUnitFactory.eINSTANCE.createTypeReference();
            if (matcher.group(3) != null) {
                instance.setName(matcher.group(3));
            }
            typeReference.setTypeName(matcher.group(1));
            instance.setMetaType(typeReference);
            index = matcher.group().length() + matcher.start();
            try {
                int endIndex = ModelingUnitParserImpl.getEndIndex(string, index, '}');
                String stringContent = string.substring(index, endIndex);
                ModelingUnitContentManager<UnitInstruction> manager = new ModelingUnitContentManager<UnitInstruction>();
                manager.addAllContent(this.getStructuralFeatureAffectations(rootOffset + index, stringContent));
                manager.validateContent(stringContent, rootOffset + index);
                instance.getStructuralFeatures().addAll(manager.getContent().values());
                index = endIndex;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new ParseException(Messages.getString("ModelingUnitParserImpl.INCORRECT_INSTANCIATION_END", matcher.group().trim()), rootOffset + matcher.start(), matcher.group().trim().length());
            }
            res.put(new Location(matcher.start(), index), (UnitInstruction)instance);
        }
        return res;
    }

    private Map<Location, UnitInstruction> getResourceDeclarations(int rootOffset, String string) throws ParseException {
        HashMap<Location, UnitInstruction> res = new HashMap<Location, UnitInstruction>();
        Pattern startPattern = Pattern.compile("Resource\\s+([a-zA-z0-9.:_-]+)\\s*\\{", 40);
        Matcher matcher = startPattern.matcher(string);
        int index = 0;
        while (matcher.find(index)) {
            ResourceDeclaration instance = ModelingUnitFactory.eINSTANCE.createResourceDeclaration();
            instance.setLineBreak(true);
            instance.setName(matcher.group(1));
            index = matcher.group().length() + matcher.start();
            try {
                int endIndex = ModelingUnitParserImpl.getEndIndex(string, index, '}');
                String stringContent = string.substring(index, endIndex);
                ModelingUnitContentManager<String> manager = new ModelingUnitContentManager<String>();
                for (Affectation affectation : this.getAllAffectations(rootOffset + index, stringContent)) {
                    if ("URI".equals(affectation.key)) {
                        instance.setUri(URI.createURI((String)affectation.values.get(0).replace(QUOTE, "")));
                        manager.addContent(affectation.location, "URI");
                        continue;
                    }
                    if ("contentType".equals(affectation.key)) {
                        instance.setContentType(affectation.values.get(0));
                        manager.addContent(affectation.location, "contentType");
                        continue;
                    }
                    if (!"content".equals(affectation.key)) continue;
                    for (String value : affectation.values) {
                        ModelingUnitInstructionReference ref = ModelingUnitFactory.eINSTANCE.createModelingUnitInstructionReference();
                        ref.setIntentHref(value);
                        instance.getContent().add((Object)ref);
                    }
                    manager.addContent(affectation.location, "content");
                }
                manager.validateContent(stringContent, rootOffset + index);
                index = endIndex;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new ParseException(Messages.getString("ModelingUnitParserImpl.INCORRECT_RESOURCE_DECLARATION_END", matcher.group().trim()), rootOffset + matcher.start(), matcher.group().length());
            }
            res.put(new Location(matcher.start(), index), (UnitInstruction)instance);
        }
        return res;
    }

    private Map<Location, UnitInstruction> getIntentSectionReferencesinModelingUnit(String string) {
        HashMap<Location, UnitInstruction> res = new HashMap<Location, UnitInstruction>();
        Pattern pattern = Pattern.compile("@see\\s+(\"[^\"]*\")(\\s+((\"[^\"]*\")))?");
        Matcher matcher = pattern.matcher(string);
        while (matcher.find()) {
            IntentReferenceInModelingUnit ref = ModelingUnitFactory.eINSTANCE.createIntentReferenceInModelingUnit();
            ref.setLineBreak(true);
            ref.setIntentHref(matcher.group(1).replaceAll(QUOTE, ""));
            if (matcher.group(3) != null) {
                ref.setTextToPrint(matcher.group(3).replaceAll(QUOTE, ""));
            }
            res.put(new Location(matcher.start(), matcher.end()), (UnitInstruction)ref);
        }
        return res;
    }

    private Map<Location, UnitInstruction> getLabelsinModelingUnit(String string) {
        HashMap<Location, UnitInstruction> res = new HashMap<Location, UnitInstruction>();
        Pattern pattern = Pattern.compile("@(lazy)?label\\s+(\"[^\"]*\")(\\s+((\"[^\"]*\")))?");
        Matcher matcher = pattern.matcher(string);
        while (matcher.find()) {
            LabelInModelingUnit instance = ModelingUnitFactory.eINSTANCE.createLabelInModelingUnit();
            instance.setLabelValue(matcher.group(2));
            instance.setLineBreak(true);
            if ("lazy".equals(matcher.group(1))) {
                instance.setType(TypeLabel.LAZY);
            } else {
                instance.setType(TypeLabel.EXPLICIT);
            }
            if (matcher.group(4) != null) {
                instance.setTextToPrint(matcher.group(4));
            }
            res.put(new Location(matcher.start(), matcher.end()), (UnitInstruction)instance);
        }
        return res;
    }

    private Map<Location, UnitInstruction> getAnnotationDeclarations(String string) {
        HashMap<Location, UnitInstruction> res = new HashMap<Location, UnitInstruction>();
        Pattern pattern = Pattern.compile("@Annotation\\s+([a-zA-z0-9.:_-]+)(.+)");
        Matcher matcher = pattern.matcher(string);
        while (matcher.find()) {
            AnnotationDeclaration instance = ModelingUnitFactory.eINSTANCE.createAnnotationDeclaration();
            instance.setLineBreak(true);
            instance.setAnnotationID(matcher.group(1));
            for (String token : ModelingUnitParserImpl.customTokenizer(matcher.group(2), TOKEN_DELIMITER)) {
                Matcher entryMatcher = Pattern.compile("([a-zA-z0-9.:_-]+)\\s*=\\s*(\"[^\"]*\")", 40).matcher(token);
                if (!entryMatcher.find()) continue;
                instance.getMap().put((Object)entryMatcher.group(1), (Object)entryMatcher.group(2));
            }
            res.put(new Location(matcher.start(), matcher.end()), (UnitInstruction)instance);
        }
        return res;
    }

    private Map<Location, UnitInstruction> getExternalContentReferencesInModelingUnit(String string) {
        HashMap<Location, UnitInstruction> res = new HashMap<Location, UnitInstruction>();
        Pattern pattern = Pattern.compile("@ref\\s+(\"[^\"]*\")");
        Matcher matcher = pattern.matcher(string);
        while (matcher.find()) {
            ExternalContentReference instance = ModelingUnitFactory.eINSTANCE.createExternalContentReference();
            instance.setLineBreak(true);
            instance.setUri(URI.createURI((String)matcher.group(1).replace(QUOTE, "")));
            res.put(new Location(matcher.start(), matcher.end()), (UnitInstruction)instance);
        }
        return res;
    }

    private Map<Location, UnitInstruction> getStructuralFeatureAffectations(int rootOffset, String string) throws ParseException {
        ModelingUnitContentManager<StructuralFeatureAffectation> manager = new ModelingUnitContentManager<StructuralFeatureAffectation>();
        for (Affectation affectation : this.getAllAffectations(rootOffset, string)) {
            StructuralFeatureAffectation instance = ModelingUnitFactory.eINSTANCE.createStructuralFeatureAffectation();
            instance.setLineBreak(true);
            instance.setName(affectation.key);
            if (affectation.hasMultipleOperator) {
                instance.setUsedOperator(AffectationOperator.MULTI_VALUED_AFFECTATION);
            }
            for (String valueContent : affectation.values) {
                AbstractValue value = this.getValue(rootOffset + affectation.keyLength, valueContent);
                if (value == null) continue;
                instance.getValues().add((Object)value);
            }
            manager.addContent(affectation.location, instance);
        }
        return manager.getContent();
    }

    private AbstractValue getValue(int rootOffset, String initialString) throws ParseException {
        NativeValue res = null;
        String string = initialString.trim();
        if (Pattern.compile(STRING_WITH_QUOTES_REGEX).matcher(string).matches()) {
            NativeValue nativeValue = ModelingUnitFactory.eINSTANCE.createNativeValue();
            nativeValue.setValue(string.trim());
            res = nativeValue;
        } else if (Pattern.compile(STRING_REGEX).matcher(string).matches()) {
            ReferenceValue referenceValue = ModelingUnitFactory.eINSTANCE.createReferenceValue();
            InstanciationInstructionReference referencedInstanciation = ModelingUnitFactory.eINSTANCE.createInstanciationInstructionReference();
            referencedInstanciation.setInstanceName(string);
            referenceValue.setInstanciationReference(referencedInstanciation);
            res = referenceValue;
        } else {
            Map<Location, UnitInstruction> instructions = this.getInstanciationInstructions(rootOffset, string, false);
            if (!instructions.isEmpty()) {
                NewObjectValue newValue = ModelingUnitFactory.eINSTANCE.createNewObjectValue();
                newValue.setValue((InstanciationInstruction)instructions.values().iterator().next());
                res = newValue;
            }
        }
        if (res == null) {
            throw new ParseException("Unrecognized structural feature value", rootOffset, string.length());
        }
        return res;
    }

    private List<Affectation> getAllAffectations(int offset, String string) throws ParseException {
        ArrayList<Affectation> allAffectations = new ArrayList<Affectation>();
        allAffectations.addAll(this.getSingleAffectations(offset, string));
        allAffectations.addAll(this.getMultipleAffectations(offset, string));
        return allAffectations;
    }

    private List<Affectation> getSingleAffectations(int offset, String string) throws ParseException {
        ArrayList<Affectation> res = new ArrayList<Affectation>();
        Pattern startPattern = Pattern.compile("([a-zA-z0-9.:_-]+)\\s*(\\+?)=\\s*");
        Matcher matcher = startPattern.matcher(string);
        int index = 0;
        int middleOffset = 0;
        while (matcher.find(index)) {
            middleOffset = index = matcher.group().length() + matcher.start();
            try {
                int endIndex = ModelingUnitParserImpl.getEndIndex(string, index, ';');
                String valuesContent = string.substring(index, endIndex);
                if (!valuesContent.startsWith("[")) {
                    Affectation affectation = new Affectation();
                    affectation.hasMultipleOperator = !"".equals(matcher.group(2));
                    affectation.key = matcher.group(1);
                    affectation.values.add(valuesContent);
                    affectation.keyLength = middleOffset;
                    affectation.location = new Location(matcher.start(), endIndex);
                    res.add(affectation);
                }
                index = endIndex;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new ParseException(Messages.getString("ModelingUnitParserImpl.INCORRECT_SINGLE_AFFECTATION_END", matcher.group().trim()), offset + matcher.start(), matcher.group().length());
            }
        }
        return res;
    }

    private List<Affectation> getMultipleAffectations(int offset, String string) throws ParseException {
        ArrayList<Affectation> res = new ArrayList<Affectation>();
        Pattern startPattern = Pattern.compile("([a-zA-z0-9.:_-]+)\\s*\\+=\\s*\\[");
        Matcher matcher = startPattern.matcher(string);
        int index = 0;
        int middleOffset = 0;
        while (matcher.find(index)) {
            Affectation affectation = new Affectation();
            affectation.hasMultipleOperator = true;
            affectation.key = matcher.group(1);
            middleOffset = index = matcher.group().length() + matcher.start();
            try {
                int endIndex = ModelingUnitParserImpl.getEndIndex(string, index, ']');
                String valuesContent = string.substring(index, endIndex);
                affectation.values.addAll(ModelingUnitParserImpl.customTokenizer(valuesContent, TOKEN_DELIMITER));
                index = endIndex;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new ParseException(Messages.getString("ModelingUnitParserImpl.INCORRECT_MULTIPLE_AFFECTATION_END", matcher.group().trim()), offset + matcher.start(), matcher.group().length());
            }
            affectation.keyLength = middleOffset;
            affectation.location = new Location(matcher.start(), ModelingUnitParserImpl.getEndIndex(string, index, ';'));
            res.add(affectation);
        }
        return res;
    }

    private static int getEndIndex(String string, int start, char end) throws IndexOutOfBoundsException {
        char[] charArray = string.toCharArray();
        int i = start;
        while (i < charArray.length) {
            char c = charArray[i];
            switch (charArray[i]) {
                case '\"': {
                    i = string.indexOf(34, i + 1);
                    if (i >= 0) break;
                    throw new IndexOutOfBoundsException();
                }
                case '{': {
                    i = ModelingUnitParserImpl.getEndIndex(string, i + 1, '}');
                    break;
                }
                case '[': {
                    i = ModelingUnitParserImpl.getEndIndex(string, i + 1, ']');
                    break;
                }
                default: {
                    if (c != end) break;
                    return i;
                }
            }
            ++i;
        }
        throw new IndexOutOfBoundsException();
    }

    private static List<String> customTokenizer(String string, String delimiter) {
        String textWithSkippedQuotes = string;
        int index = 0;
        ArrayList<String> skippedQuotes = new ArrayList<String>();
        Matcher m = Pattern.compile(STRING_WITH_QUOTES_REGEX).matcher(string);
        while (m.find()) {
            if (m.group(1) == null) continue;
            textWithSkippedQuotes = textWithSkippedQuotes.replaceFirst(m.group(1), "@SKIPPED_QUOTE_" + index++);
            skippedQuotes.add(m.group(1));
        }
        ArrayList<String> res = new ArrayList<String>();
        Pattern quotesPattern = Pattern.compile("@SKIPPED_QUOTE_([0-9])+");
        if (textWithSkippedQuotes.contains(delimiter)) {
            StringTokenizer tokenizer = new StringTokenizer(textWithSkippedQuotes, TOKEN_DELIMITER);
            while (tokenizer.hasMoreTokens()) {
                String token = tokenizer.nextToken();
                Matcher quotesMatcher = quotesPattern.matcher(token);
                while (quotesMatcher.find()) {
                    token = token.replaceFirst(quotesMatcher.group(), (String)skippedQuotes.get(new Integer(quotesMatcher.group(1))));
                }
                res.add(token.trim());
            }
        } else {
            Matcher quotesMatcher = quotesPattern.matcher(textWithSkippedQuotes);
            while (quotesMatcher.find()) {
                textWithSkippedQuotes = textWithSkippedQuotes.replaceFirst(quotesMatcher.group(), (String)skippedQuotes.get(new Integer(quotesMatcher.group(1))));
            }
            res.add(textWithSkippedQuotes);
        }
        return res;
    }

    private class Affectation {
        boolean hasMultipleOperator;
        Location location;
        int keyLength;
        String key;
        List<String> values = new ArrayList<String>();

        private Affectation() {
        }
    }
}

