/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.docs.intent.collab.ide.adapters;

import java.util.Collection;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;

public class RemoveDanglingReferences
extends RecordingCommand {
    private final EObject root;

    public RemoveDanglingReferences(TransactionalEditingDomain domain, EObject root) {
        super(domain);
        this.root = root;
    }

    protected void doExecute() {
        this.removeDanglingReferences(this.root);
    }

    public void removeDanglingReferences(EObject root) {
        if (root.eResource() != null && root.eResource().getResourceSet() != null) {
            this.removeDanglingReferences(new DanglingReferencesDetector(root.eResource()));
        }
    }

    public void removeDanglingReferences(ResourceSet resourceSet) {
        this.removeDanglingReferences(new DanglingReferencesDetector(resourceSet));
    }

    private void removeDanglingReferences(EcoreUtil.CrossReferencer referencer) {
        for (Map.Entry entry : referencer.entrySet()) {
            for (EStructuralFeature.Setting value : (Collection)entry.getValue()) {
                try {
                    EcoreUtil.remove((EStructuralFeature.Setting)value, entry.getKey());
                }
                catch (UnsupportedOperationException unsupportedOperationException) {
                }
                catch (NullPointerException nullPointerException) {}
            }
        }
    }

    private static class DanglingReferencesDetector
    extends EcoreUtil.CrossReferencer {
        private static final long serialVersionUID = 616050158241084372L;

        public DanglingReferencesDetector(Resource eResource) {
            super(eResource);
            this.crossReference();
            this.done();
        }

        public DanglingReferencesDetector(ResourceSet resourceSet) {
            super(resourceSet);
            this.crossReference();
            this.done();
        }

        protected boolean crossReference(EObject eObject, EReference eReference, EObject crossReferencedEObject) {
            return crossReferencedEObject.eResource() == null;
        }
    }
}

