/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.docs.intent.serializer.internal;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.mylyn.docs.intent.core.document.IntentSection;
import org.eclipse.mylyn.docs.intent.core.document.IntentSectionVisibility;
import org.eclipse.mylyn.docs.intent.serializer.descriptionunit.DescriptionUnitSerializer;
import org.eclipse.mylyn.docs.intent.serializer.internal.IntentElementSerializer;

public final class IntentSectionSerializer {
    private IntentSectionSerializer() {
    }

    public static String serialize(IntentSection section, IntentElementSerializer serializer) {
        String renderedForm = serializer.tabulation();
        int initalOffset = serializer.getCurrentOffset();
        if (!section.getVisibility().equals((Object)IntentSectionVisibility.PUBLIC)) {
            renderedForm = String.valueOf(renderedForm) + section.getVisibility().getLiteral().toLowerCase() + " ";
        }
        renderedForm = String.valueOf(renderedForm) + "Section";
        int initialLength = renderedForm.length();
        renderedForm = String.valueOf(renderedForm) + " ";
        if (section.getTitle() != null) {
            DescriptionUnitSerializer descriptionUnitSerializer = new DescriptionUnitSerializer();
            renderedForm = String.valueOf(renderedForm) + descriptionUnitSerializer.serializeSectionTitle((EObject)section.getTitle(), initalOffset + renderedForm.length());
            serializer.getPositionManager().addIntentPositionManagerInformations(descriptionUnitSerializer.getPositionManager());
            renderedForm = String.valueOf(renderedForm) + " ";
        }
        renderedForm = String.valueOf(renderedForm) + "{";
        serializer.setCurrentIndendationLevel(serializer.getCurrentIndendationLevel() + 1);
        for (EObject content : section.getIntentContent()) {
            if (content instanceof IntentSection) {
                renderedForm = String.valueOf(renderedForm) + "\n";
            }
            serializer.setCurrentOffset(initalOffset + renderedForm.length());
            renderedForm = String.valueOf(renderedForm) + serializer.serialize(content);
        }
        serializer.setCurrentIndendationLevel(serializer.getCurrentIndendationLevel() - 1);
        renderedForm = String.valueOf(renderedForm) + serializer.tabulation() + "}" + "\n";
        serializer.setCurrentOffset(initalOffset + renderedForm.length());
        serializer.setDeclarationPositionForElement((EObject)section, initalOffset, renderedForm.length(), initialLength);
        return renderedForm;
    }
}

