/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.docs.intent.client.ui.ide.navigator;

import com.google.common.collect.Sets;
import java.util.ConcurrentModificationException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.mylyn.docs.intent.collab.common.logger.IIntentLogger;
import org.eclipse.mylyn.docs.intent.collab.common.logger.IntentLogger;
import org.eclipse.mylyn.docs.intent.collab.common.query.CompilationStatusQuery;
import org.eclipse.mylyn.docs.intent.collab.handlers.adapters.RepositoryAdapter;
import org.eclipse.mylyn.docs.intent.core.compiler.CompilationStatus;
import org.eclipse.mylyn.docs.intent.core.compiler.CompilationStatusManager;
import org.eclipse.mylyn.docs.intent.core.compiler.CompilationStatusSeverity;
import org.eclipse.mylyn.docs.intent.core.compiler.SynchronizerCompilationStatus;

public class UpdateProblemsViewJob
extends Job {
    private static final String UPDATE_PROBLEMS_VIEW_JOB_NAME = "Updating problem view";
    private RepositoryAdapter adapter;
    private IProject project;
    private CompilationStatusQuery statusQuery;

    public UpdateProblemsViewJob(IProject project, RepositoryAdapter adapter) {
        super(UPDATE_PROBLEMS_VIEW_JOB_NAME);
        this.project = project;
        this.adapter = adapter;
        this.statusQuery = new CompilationStatusQuery(adapter);
    }

    protected IStatus run(IProgressMonitor monitor) {
        Resource statusResource = this.adapter.getResource("/COMPILATION/STATUS/StatusIndex");
        Resource intentDocumentResource = this.adapter.getResource("/INTENT/IntentDocument");
        String platformString = intentDocumentResource.getURI().toPlatformString(true);
        IFile intentDocumentFile = (IFile)ResourcesPlugin.getWorkspace().getRoot().findMember(platformString);
        if (intentDocumentFile != null && !statusResource.getContents().isEmpty()) {
            try {
                if (this.project.isAccessible()) {
                    this.project.deleteMarkers("org.eclipse.core.resources.problemmarker", false, 2);
                }
            }
            catch (CoreException e) {
                IntentLogger.getInstance().log(IIntentLogger.LogType.WARNING, "Intent - failed to delete markers of project " + this.project.getName(), (Throwable)e);
            }
            CompilationStatusManager statusManager = this.statusQuery.getOrCreateCompilationStatusManager();
            try {
                for (CompilationStatus status : Sets.newLinkedHashSet((Iterable)statusManager.getCompilationStatusList())) {
                    this.createMarkerFromStatus(status);
                }
            }
            catch (ConcurrentModificationException e) {
                IntentLogger.getInstance().log(IIntentLogger.LogType.WARNING, "Error while updating problem view", (Throwable)e);
            }
        }
        return Status.OK_STATUS;
    }

    private void createMarkerFromStatus(CompilationStatus status) {
        IMarker marker = null;
        try {
            boolean statusIsProxy = status.eIsProxy() || status.getTarget() == null || status.getTarget().eIsProxy();
            boolean bl = statusIsProxy = statusIsProxy || status.eResource() == null || status.getTarget().eResource() == null;
            if (this.project.isAccessible() && !statusIsProxy) {
                marker = this.project.createMarker("org.eclipse.core.resources.problemmarker");
                if (status.getSeverity() == CompilationStatusSeverity.WARNING) {
                    marker.setAttribute("severity", 1);
                } else if (status.getSeverity() == CompilationStatusSeverity.INFO) {
                    marker.setAttribute("severity", 0);
                } else {
                    marker.setAttribute("severity", 2);
                }
                String markerMessage = status.getMessage();
                if (status instanceof SynchronizerCompilationStatus) {
                    markerMessage = "[Sync] " + markerMessage;
                }
                marker.setAttribute("message", (Object)markerMessage);
                marker.setAttribute("location", (Object)EcoreUtil.getURI((EObject)status).toString());
                marker.setAttribute("sourceId", (Object)"Intent");
            }
        }
        catch (CoreException e) {
            IntentLogger.getInstance().log(IIntentLogger.LogType.WARNING, "Intent - error occured while creating problem markers on project " + this.project.getName(), (Throwable)e);
        }
    }
}

