/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.docs.intent.client.ui.editor.quickfix;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.quickassist.IQuickAssistInvocationContext;
import org.eclipse.jface.text.quickassist.IQuickAssistProcessor;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.TextInvocationContext;
import org.eclipse.mylyn.docs.intent.client.ui.editor.annotation.IntentAnnotation;
import org.eclipse.mylyn.docs.intent.client.ui.editor.quickfix.AbstractIntentFix;
import org.eclipse.mylyn.docs.intent.client.ui.editor.quickfix.ClearResourceFix;
import org.eclipse.mylyn.docs.intent.client.ui.editor.quickfix.CreateResourceFix;
import org.eclipse.mylyn.docs.intent.client.ui.editor.quickfix.EMFCompareFix;
import org.eclipse.mylyn.docs.intent.client.ui.editor.quickfix.MergeEmptyResourceFix;
import org.eclipse.mylyn.docs.intent.client.ui.editor.quickfix.UpdateModelingUnitFix;
import org.eclipse.mylyn.docs.intent.client.ui.internal.quickfix.provider.IntentQuickFixProviderRegistry;
import org.eclipse.mylyn.docs.intent.core.compiler.ResourceChangeStatus;
import org.eclipse.mylyn.docs.intent.core.compiler.SynchronizerCompilationStatus;
import org.eclipse.mylyn.docs.intent.core.compiler.SynchronizerResourceState;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IntentQuickAssistProcessor
implements IQuickAssistProcessor {
    public boolean canFix(Annotation annotation) {
        return "org.eclipse.mylyn.docs.intent.client.ui.annotation.sync.warning".equals(annotation.getType()) || "org.eclipse.mylyn.docs.intent.client.ui.annotation.compiler.warning".equals(annotation.getType());
    }

    public ICompletionProposal[] computeQuickAssistProposals(IQuickAssistInvocationContext quickAssistContext) {
        LinkedHashSet synchronizationIssues = Sets.newLinkedHashSet();
        LinkedHashSet validationIssues = Sets.newLinkedHashSet();
        ISourceViewer viewer = quickAssistContext.getSourceViewer();
        int documentOffset = quickAssistContext.getOffset();
        int length = viewer.getSelectedRange().y;
        TextInvocationContext context = new TextInvocationContext(viewer, documentOffset, length);
        IAnnotationModel model = viewer.getAnnotationModel();
        int offset = context.getOffset();
        Iterator iter = model.getAnnotationIterator();
        while (iter.hasNext()) {
            Position pos;
            Annotation annotation = (Annotation)iter.next();
            if (!this.canFix(annotation) || !(annotation instanceof IntentAnnotation) || (pos = model.getPosition(annotation)) == null || !pos.includes(offset)) continue;
            if (((IntentAnnotation)annotation).getCompilationStatus() instanceof SynchronizerCompilationStatus) {
                synchronizationIssues.add((IntentAnnotation)annotation);
                continue;
            }
            validationIssues.add((IntentAnnotation)annotation);
        }
        ArrayList proposals = Lists.newArrayList();
        for (IntentAnnotation annotation : synchronizationIssues) {
            proposals.addAll(this.computeProposalsFromSynchronizationIssue(annotation));
        }
        for (IntentAnnotation annotation : validationIssues) {
            proposals.addAll(this.computeProposalsFromValidationIssue(annotation));
        }
        return proposals.toArray(new ICompletionProposal[proposals.size()]);
    }

    private List<ICompletionProposal> computeProposalsFromSynchronizationIssue(IntentAnnotation annotation) {
        ArrayList<ICompletionProposal> proposals = new ArrayList<ICompletionProposal>();
        SynchronizerCompilationStatus status = (SynchronizerCompilationStatus)annotation.getCompilationStatus();
        if (status instanceof ResourceChangeStatus) {
            ResourceChangeStatus resourceChangeStatus = (ResourceChangeStatus)status;
            SynchronizerResourceState compiledResourceState = resourceChangeStatus.getCompiledResourceState();
            SynchronizerResourceState workingCopyResourceState = resourceChangeStatus.getWorkingCopyResourceState();
            if (SynchronizerResourceState.EMPTY.equals((Object)compiledResourceState)) {
                proposals.add(new ClearResourceFix(annotation));
            } else if (SynchronizerResourceState.EMPTY.equals((Object)workingCopyResourceState)) {
                proposals.add(new MergeEmptyResourceFix(annotation));
            } else if (SynchronizerResourceState.NULL.equals((Object)workingCopyResourceState)) {
                proposals.add(new CreateResourceFix(annotation));
            }
        } else {
            proposals.add(new EMFCompareFix(annotation));
            proposals.add(new UpdateModelingUnitFix(annotation));
        }
        return proposals;
    }

    private Collection<? extends ICompletionProposal> computeProposalsFromValidationIssue(IntentAnnotation annotation) {
        ArrayList<AbstractIntentFix> proposals = new ArrayList<AbstractIntentFix>();
        for (AbstractIntentFix intentFix : IntentQuickFixProviderRegistry.getAppliableIntentFixes(annotation)) {
            proposals.add(intentFix);
        }
        return proposals;
    }

    public boolean canAssist(IQuickAssistInvocationContext invocationContext) {
        return false;
    }

    public String getErrorMessage() {
        return null;
    }
}

