/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.docs.intent.client.compiler.generator.modelgeneration;

import java.util.List;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.mylyn.docs.intent.client.compiler.errors.CompilationErrorType;
import org.eclipse.mylyn.docs.intent.client.compiler.errors.CompilationException;
import org.eclipse.mylyn.docs.intent.client.compiler.errors.ResolveException;
import org.eclipse.mylyn.docs.intent.client.compiler.generator.modelgeneration.ContributionInstructionGenerator;
import org.eclipse.mylyn.docs.intent.client.compiler.generator.modelgeneration.ModelingUnitGenerator;
import org.eclipse.mylyn.docs.intent.client.compiler.generator.modelgeneration.StructuralFeatureGenerator;
import org.eclipse.mylyn.docs.intent.client.compiler.generator.modellinking.ModelingUnitLinkResolver;
import org.eclipse.mylyn.docs.intent.core.compiler.UnresolvedContributionHolder;
import org.eclipse.mylyn.docs.intent.core.document.IntentGenericElement;
import org.eclipse.mylyn.docs.intent.core.genericunit.UnitInstruction;
import org.eclipse.mylyn.docs.intent.core.modelingunit.InstanciationInstruction;
import org.eclipse.mylyn.docs.intent.core.modelingunit.StructuralFeatureAffectation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class InstanciationInstructionGenerator {
    private InstanciationInstructionGenerator() {
    }

    public static EObject generate(InstanciationInstruction instanciationInstruction, List<String> importedPackageURIS, ModelingUnitLinkResolver linkResolver, ModelingUnitGenerator modelingUnitGenerator) {
        ModelingUnitGenerator.clearCompilationStatus((IntentGenericElement)instanciationInstruction);
        EObject createdElement = null;
        String metaTypeHref = instanciationInstruction.getMetaType().getTypeName();
        try {
            EClass metaType = (EClass)linkResolver.resolveEClassifierUsingPackage((UnitInstruction)instanciationInstruction, importedPackageURIS, metaTypeHref);
            instanciationInstruction.getMetaType().setResolvedType(metaType);
            createdElement = metaType.getEPackage().getEFactoryInstance().create(metaType);
            if (instanciationInstruction.getName() != null) {
                for (EAttribute attribute : metaType.getEAllAttributes()) {
                    if (!InstanciationInstructionGenerator.isConcernedByNameAttribute(attribute)) continue;
                    createdElement.eSet((EStructuralFeature)attribute, (Object)instanciationInstruction.getName());
                }
            }
            for (StructuralFeatureAffectation sfa : instanciationInstruction.getStructuralFeatures()) {
                StructuralFeatureGenerator.generateFeatureAndAddToClass(sfa, createdElement, linkResolver, modelingUnitGenerator);
            }
        }
        catch (ResolveException e) {
            modelingUnitGenerator.getInformationHolder().registerCompilationExceptionAsCompilationStatus(new CompilationException(e.getInvalidInstruction(), CompilationErrorType.INVALID_REFERENCE_ERROR, e.getMessage()));
            createdElement = EcoreFactory.eINSTANCE.createEObject();
        }
        catch (IllegalArgumentException e) {
            modelingUnitGenerator.getInformationHolder().registerCompilationExceptionAsCompilationStatus(new CompilationException((UnitInstruction)instanciationInstruction, CompilationErrorType.INVALID_VALUE_ERROR, e.getMessage()));
            createdElement = EcoreFactory.eINSTANCE.createEObject();
        }
        modelingUnitGenerator.getInformationHolder().addNameToCreatedElementEntry(instanciationInstruction.getName(), createdElement, instanciationInstruction);
        if (createdElement instanceof EPackage) {
            linkResolver.unregisterEPackage((EPackage)createdElement);
        }
        for (UnresolvedContributionHolder contributionHolder : modelingUnitGenerator.getInformationHolder().getContributionsAssociatedTo(instanciationInstruction.getName())) {
            ContributionInstructionGenerator.generate(contributionHolder.getReferencedContribution(), modelingUnitGenerator, linkResolver);
        }
        return createdElement;
    }

    private static boolean isConcernedByNameAttribute(EAttribute attribute) {
        boolean isConcernedByNameAttribute = attribute.isID() && "EString".equals(attribute.getEAttributeType().getName());
        isConcernedByNameAttribute = isConcernedByNameAttribute || "name".equals(attribute.getName()) && "EString".equals(attribute.getEAttributeType().getName());
        return isConcernedByNameAttribute;
    }

    public static boolean isEPackageInstanciation(InstanciationInstruction instruction) {
        return "EPackage".equals(instruction.getMetaType().getTypeName());
    }
}

