/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.docs.intent.client.ui.editor.quickfix;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.quickassist.IQuickAssistInvocationContext;
import org.eclipse.jface.text.quickassist.IQuickAssistProcessor;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.TextInvocationContext;
import org.eclipse.mylyn.docs.intent.client.ui.editor.annotation.IntentAnnotation;
import org.eclipse.mylyn.docs.intent.client.ui.editor.quickfix.ClearResourceFix;
import org.eclipse.mylyn.docs.intent.client.ui.editor.quickfix.CreateResourceFix;
import org.eclipse.mylyn.docs.intent.client.ui.editor.quickfix.EMFCompareFix;
import org.eclipse.mylyn.docs.intent.client.ui.editor.quickfix.MergeEmptyResourceFix;

public class IntentQuickAssistProcessor
implements IQuickAssistProcessor {
    public String getErrorMessage() {
        return null;
    }

    public boolean canFix(Annotation annotation) {
        return "org.eclipse.mylyn.docs.intent.client.ui.annotation.sync.warning".equals(annotation.getType());
    }

    public boolean canAssist(IQuickAssistInvocationContext invocationContext) {
        return false;
    }

    public ICompletionProposal[] computeQuickAssistProposals(IQuickAssistInvocationContext quickAssistContext) {
        ISourceViewer viewer = quickAssistContext.getSourceViewer();
        int documentOffset = quickAssistContext.getOffset();
        int length = viewer.getSelectedRange().y;
        TextInvocationContext context = new TextInvocationContext(viewer, documentOffset, length);
        IAnnotationModel model = viewer.getAnnotationModel();
        int offset = context.getOffset();
        new ArrayList();
        Iterator iter = model.getAnnotationIterator();
        while (iter.hasNext()) {
            Position pos;
            Annotation annotation = (Annotation)iter.next();
            if (!this.canFix(annotation) || !this.isAtPosition(offset, pos = model.getPosition(annotation))) continue;
            ArrayList<Object> proposals = new ArrayList<Object>();
            String annotationTag = (String)((IntentAnnotation)annotation).getAdditionalInformations().toArray()[0];
            if ("EMPTY_DOCUMENT_RESOURCE".equals(annotationTag)) {
                proposals.add(new ClearResourceFix(annotation));
            } else if ("EMPTY_WORKING_COPY_RESOURCE".equals(annotationTag)) {
                proposals.add(new MergeEmptyResourceFix(annotation));
            } else if ("NULL_RESOURCE".equals(annotationTag)) {
                proposals.add(new CreateResourceFix(annotation));
            } else {
                proposals.add(new EMFCompareFix(annotation));
            }
            return proposals.toArray(new ICompletionProposal[proposals.size()]);
        }
        return null;
    }

    private boolean isAtPosition(int offset, Position pos) {
        return pos != null && offset >= pos.getOffset() && offset <= pos.getOffset() + pos.getLength();
    }
}

