/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hawk.service.emf.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.thrift.TFieldIdEnum;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.ECollections;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.impl.DynamicEStoreEObjectImpl;
import org.eclipse.hawk.service.api.AttributeSlot;
import org.eclipse.hawk.service.api.SlotValue;

public final class SlotDecodingUtils {
    private SlotDecodingUtils() {
    }

    public static Object setFromSlot(EFactory eFactory, EClass eClass, EObject eObject, AttributeSlot slot) throws IOException {
        EStructuralFeature feature = eClass.getEStructuralFeature(slot.name);
        if (feature == null) {
            return null;
        }
        if (!feature.isChangeable() || feature.isDerived() && !(eObject instanceof DynamicEStoreEObjectImpl)) {
            return null;
        }
        if (!slot.isSetValue()) {
            return null;
        }
        EClassifier eType = feature.getEType();
        if (eType.eContainer() == EcorePackage.eINSTANCE) {
            return SlotDecodingUtils.fromEcoreType(eClass, eObject, slot, feature, eType);
        }
        if (eType instanceof EEnum) {
            return SlotDecodingUtils.fromEnum(eFactory, eClass, eObject, slot, feature, (EEnum)eType);
        }
        return SlotDecodingUtils.fromInstanceClass(eClass, eObject, slot, feature, eType);
    }

    private static Object fromByte(EClass eClass, EObject eObject, AttributeSlot slot, EStructuralFeature feature) throws IOException {
        if (!slot.value.isSetVBytes() && !slot.value.isSetVByte()) {
            throw new IOException(String.format("Expected to receive bytes for feature '%s' in type '%s', but did not", feature.getName(), eClass.getName()));
        }
        if (feature.isMany() || feature.getEType() == EcorePackage.Literals.EBYTE_ARRAY) {
            BasicEList bytes = new BasicEList();
            if (slot.value.isSetVBytes()) {
                byte[] byArray = slot.value.getVBytes();
                int n = byArray.length;
                int n2 = 0;
                while (n2 < n) {
                    byte b = byArray[n2];
                    bytes.add((Object)b);
                    ++n2;
                }
            } else {
                bytes.add((Object)slot.value.getVByte());
            }
            eObject.eSet(feature, (Object)bytes);
            return bytes;
        }
        byte b = slot.value.getVByte();
        eObject.eSet(feature, (Object)b);
        return b;
    }

    private static Object fromEcoreType(EClass eClass, EObject eObject, AttributeSlot slot, EStructuralFeature feature, EClassifier eType) throws IOException {
        if (eType == EcorePackage.Literals.EBYTE_ARRAY || eType == EcorePackage.Literals.EBYTE) {
            return SlotDecodingUtils.fromByte(eClass, eObject, slot, feature);
        }
        if (eType == EcorePackage.Literals.EFLOAT) {
            return SlotDecodingUtils.fromFloat(eClass, eObject, slot, feature);
        }
        if (eType == EcorePackage.Literals.EDOUBLE) {
            return SlotDecodingUtils.fromExpectedType(eClass, eObject, slot, feature, SlotValue._Fields.V_DOUBLES, SlotValue._Fields.V_DOUBLE);
        }
        if (eType == EcorePackage.Literals.EINT) {
            return SlotDecodingUtils.fromExpectedType(eClass, eObject, slot, feature, SlotValue._Fields.V_INTEGERS, SlotValue._Fields.V_INTEGER);
        }
        if (eType == EcorePackage.Literals.ELONG) {
            return SlotDecodingUtils.fromExpectedType(eClass, eObject, slot, feature, SlotValue._Fields.V_LONGS, SlotValue._Fields.V_LONG);
        }
        if (eType == EcorePackage.Literals.ESHORT) {
            return SlotDecodingUtils.fromExpectedType(eClass, eObject, slot, feature, SlotValue._Fields.V_SHORTS, SlotValue._Fields.V_SHORT);
        }
        if (eType == EcorePackage.Literals.ESTRING) {
            return SlotDecodingUtils.fromExpectedType(eClass, eObject, slot, feature, SlotValue._Fields.V_STRINGS, SlotValue._Fields.V_STRING);
        }
        if (eType == EcorePackage.Literals.EBOOLEAN) {
            return SlotDecodingUtils.fromExpectedType(eClass, eObject, slot, feature, SlotValue._Fields.V_BOOLEANS, SlotValue._Fields.V_BOOLEAN);
        }
        throw new IOException(String.format("Unknown ECore data type '%s'", eType));
    }

    private static Object fromEnum(EFactory eFactory, EClass eClass, EObject eObject, AttributeSlot slot, EStructuralFeature feature, EEnum enumType) throws IOException {
        if (!slot.value.isSetVStrings() && !slot.value.isSetVString()) {
            throw new IOException(String.format("Expected to receive strings for feature '%s' in type '%s' with many='%s', but did not", feature.getName(), eClass.getName(), feature.isMany()));
        }
        if (feature.isMany()) {
            ArrayList<Object> literals = new ArrayList<Object>();
            if (slot.value.isSetVStrings()) {
                for (String s : slot.value.getVStrings()) {
                    literals.add(eFactory.createFromString((EDataType)enumType, s));
                }
            } else {
                literals.add(eFactory.createFromString((EDataType)enumType, slot.value.getVString()));
            }
            eObject.eSet(feature, literals);
            return literals;
        }
        Object enumLiteral = eFactory.createFromString((EDataType)enumType, slot.value.getVString());
        eObject.eSet(feature, enumLiteral);
        return enumLiteral;
    }

    private static Object fromFloat(EClass eClass, EObject eObject, AttributeSlot slot, EStructuralFeature feature) throws IOException {
        if (!slot.value.isSetVDoubles() && !slot.value.isSetVDouble()) {
            throw new IOException(String.format("Expected to receive doubles for feature '%s' in type '%s', but did not", feature.getName(), eClass.getName()));
        }
        if (feature.isMany()) {
            BasicEList floats = new BasicEList();
            if (slot.value.isSetVDoubles()) {
                Iterator iterator = slot.value.getVDoubles().iterator();
                while (iterator.hasNext()) {
                    double d = (Double)iterator.next();
                    floats.add((Object)Float.valueOf((float)d));
                }
            } else {
                floats.add((Object)Float.valueOf((float)slot.value.getVDouble()));
            }
            eObject.eSet(feature, (Object)floats);
            return floats;
        }
        double d = slot.value.getVDouble();
        eObject.eSet(feature, (Object)Float.valueOf((float)d));
        return d;
    }

    private static Object fromInstanceClass(EClass eClass, EObject eObject, AttributeSlot slot, EStructuralFeature feature, EClassifier eType) throws IOException {
        Class instanceClass = eType.getInstanceClass();
        if (instanceClass == null) {
            throw new IOException(String.format("Cannot set value for feature '%s' with type '%s', as it is not an Ecore data type and it does not have an instance class", feature, eType));
        }
        if (Byte.class.isAssignableFrom(instanceClass) || Byte.TYPE.isAssignableFrom(instanceClass)) {
            return SlotDecodingUtils.fromByte(eClass, eObject, slot, feature);
        }
        if (Float.class.isAssignableFrom(instanceClass) || Float.TYPE.isAssignableFrom(instanceClass)) {
            return SlotDecodingUtils.fromFloat(eClass, eObject, slot, feature);
        }
        if (Double.class.isAssignableFrom(instanceClass) || Double.TYPE.isAssignableFrom(instanceClass)) {
            return SlotDecodingUtils.fromExpectedType(eClass, eObject, slot, feature, SlotValue._Fields.V_DOUBLES, SlotValue._Fields.V_DOUBLE);
        }
        if (Integer.class.isAssignableFrom(instanceClass) || Integer.TYPE.isAssignableFrom(instanceClass)) {
            return SlotDecodingUtils.fromExpectedType(eClass, eObject, slot, feature, SlotValue._Fields.V_INTEGERS, SlotValue._Fields.V_INTEGER);
        }
        if (Long.class.isAssignableFrom(instanceClass) || Long.TYPE.isAssignableFrom(instanceClass)) {
            return SlotDecodingUtils.fromExpectedType(eClass, eObject, slot, feature, SlotValue._Fields.V_LONGS, SlotValue._Fields.V_LONG);
        }
        if (Short.class.isAssignableFrom(instanceClass) || Short.TYPE.isAssignableFrom(instanceClass)) {
            return SlotDecodingUtils.fromExpectedType(eClass, eObject, slot, feature, SlotValue._Fields.V_SHORTS, SlotValue._Fields.V_SHORT);
        }
        if (String.class.isAssignableFrom(instanceClass)) {
            return SlotDecodingUtils.fromExpectedType(eClass, eObject, slot, feature, SlotValue._Fields.V_STRINGS, SlotValue._Fields.V_STRING);
        }
        if (Boolean.class.isAssignableFrom(instanceClass) || Boolean.TYPE.isAssignableFrom(instanceClass)) {
            return SlotDecodingUtils.fromExpectedType(eClass, eObject, slot, feature, SlotValue._Fields.V_BOOLEANS, SlotValue._Fields.V_BOOLEAN);
        }
        throw new IOException(String.format("Unknown data type for %s#%s %s with isMany = false and instance class %s", eClass.getName(), feature.getName(), eType.getName(), feature.isMany(), instanceClass));
    }

    private static Object fromExpectedType(EClass eClass, EObject eObject, AttributeSlot slot, EStructuralFeature feature, SlotValue._Fields expectedMultiType, SlotValue._Fields expectedSingleType) throws IOException {
        if (!slot.value.isSet((TFieldIdEnum)expectedMultiType) && !slot.value.isSet((TFieldIdEnum)expectedSingleType)) {
            throw new IOException(String.format("Expected to receive '%s' for feature '%s' in type '%s' with many='%s', but did not", expectedMultiType, feature.getName(), eClass.getName(), feature.isMany()));
        }
        if (feature.isMany() && slot.value.isSet((TFieldIdEnum)expectedMultiType)) {
            EList newValue = ECollections.toEList((Iterable)((Iterable)slot.value.getFieldValue((TFieldIdEnum)expectedMultiType)));
            eObject.eSet(feature, (Object)newValue);
            return newValue;
        }
        if (feature.isMany()) {
            EList newValue = ECollections.asEList((Object[])new Object[]{slot.value.getFieldValue((TFieldIdEnum)expectedSingleType)});
            eObject.eSet(feature, (Object)newValue);
            return newValue;
        }
        Object elem = slot.value.getFieldValue((TFieldIdEnum)expectedSingleType);
        eObject.eSet(feature, elem);
        return elem;
    }
}

