/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui.dialogs;

import java.util.ArrayList;
import org.eclipse.core.resources.IResource;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.internal.ui.dialogs.IPromptCondition;
import org.eclipse.team.internal.ui.dialogs.MultipleYesNoPrompter;

public class PromptingDialog
extends MultipleYesNoPrompter {
    private IPromptCondition condition;
    private IResource[] resources;

    public PromptingDialog(Shell shell, IResource[] resources, IPromptCondition condition, String title) {
        this(shell, resources, condition, title, false);
    }

    public PromptingDialog(Shell shell, IResource[] resources, IPromptCondition condition, String title, boolean allOrNothing) {
        super(() -> shell, title, resources.length > 1, allOrNothing);
        this.resources = resources;
        this.condition = condition;
    }

    public IResource[] promptForMultiple() throws InterruptedException {
        ArrayList<IResource> targetResources = new ArrayList<IResource>();
        IResource[] iResourceArray = this.resources;
        int n = this.resources.length;
        int n2 = 0;
        while (n2 < n) {
            IResource resource = iResourceArray[n2];
            if (!this.condition.needsPrompt(resource) || this.shouldInclude(this.condition.promptMessage(resource))) {
                targetResources.add(resource);
            }
            ++n2;
        }
        return targetResources.toArray(new IResource[targetResources.size()]);
    }
}

