/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui.dialogs;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IPageChangeProvider;
import org.eclipse.jface.dialogs.IPageChangedListener;
import org.eclipse.jface.dialogs.PageChangedEvent;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.jface.preference.IPersistentPreferenceStore;
import org.eclipse.jface.preference.IPreferencePageContainer;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.resource.JFaceColors;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.team.internal.ui.TeamUIMessages;
import org.eclipse.team.internal.ui.TeamUIPlugin;
import org.eclipse.team.internal.ui.Utils;

public class PreferencePageContainerDialog
extends TrayDialog
implements IPreferencePageContainer,
IPageChangeProvider {
    private PreferencePage[] pages;
    private PreferencePage currentPage;
    private Composite fTitleArea;
    private Label fTitleImage;
    private CLabel fMessageLabel;
    private String fMessage;
    private Color fNormalMsgAreaBackground;
    private Image fErrorMsgImage;
    private Button fOkButton;
    private ListenerList<IPageChangedListener> pageChangedListeners = new ListenerList();
    private Composite fPageContainer;
    private Point fMinimumPageSize = new Point(200, 200);
    private TabFolder tabFolder;
    private Map<TabItem, PreferencePage> pageMap = new HashMap<TabItem, PreferencePage>();
    protected static final String PREF_DLG_TITLE_IMG = "preference_page_container_image";
    protected static final String PREF_DLG_IMG_TITLE_ERROR = "preference_page_container_title_error_image";

    static {
        ImageRegistry reg = TeamUIPlugin.getPlugin().getImageRegistry();
        reg.put(PREF_DLG_TITLE_IMG, ImageDescriptor.createFromFile(PreferenceDialog.class, (String)"images/pref_dialog_title.png"));
        reg.put(PREF_DLG_IMG_TITLE_ERROR, ImageDescriptor.createFromFile(Dialog.class, (String)"images/message_error.png"));
    }

    public PreferencePageContainerDialog(Shell shell, PreferencePage[] pages) {
        super(shell);
        this.pages = pages;
    }

    protected void okPressed() {
        PreferencePage[] preferencePageArray = this.pages;
        int n = this.pages.length;
        int n2 = 0;
        while (n2 < n) {
            PreferencePage page = preferencePageArray[n2];
            page.performOk();
            ++n2;
        }
        this.handleSave();
        super.okPressed();
    }

    public void setTitle(String title) {
        Shell shell = this.getShell();
        if (shell != null && !shell.isDisposed()) {
            shell.setText(title);
        }
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        ((GridLayout)composite.getLayout()).numColumns = 1;
        this.createDescriptionArea(composite);
        if (this.isSinglePage()) {
            this.createSinglePageArea(composite, this.pages[0]);
        } else {
            this.createMultiplePageArea(composite);
        }
        Label separator = new Label(composite, 258);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        separator.setLayoutData((Object)gd);
        this.setTitle(TeamUIMessages.PreferencePageContainerDialog_6);
        PreferencePageContainerDialog.applyDialogFont((Control)parent);
        composite.addHelpListener(e -> this.currentPage.performHelp());
        return composite;
    }

    private void createMultiplePageArea(Composite composite) {
        this.tabFolder = new TabFolder(composite, 0);
        this.tabFolder.setLayoutData((Object)new GridData(1808));
        PreferencePage[] preferencePageArray = this.pages;
        int n = this.pages.length;
        int n2 = 0;
        while (n2 < n) {
            PreferencePage page = preferencePageArray[n2];
            TabItem tabItem = new TabItem(this.tabFolder, 0);
            tabItem.setText(page.getTitle());
            tabItem.setControl(this.createPageArea((Composite)this.tabFolder, page));
            this.pageMap.put(tabItem, page);
            ++n2;
        }
        this.tabFolder.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PreferencePageContainerDialog.this.updatePageSelection();
            }
        });
        this.updatePageSelection();
    }

    protected void updatePageSelection() {
        TabItem[] items = this.tabFolder.getSelection();
        if (items.length == 1) {
            this.currentPage = this.pageMap.get(items[0]);
            this.updateMessage();
        }
        this.firePageChanged(new PageChangedEvent((IPageChangeProvider)this, (Object)this.currentPage));
    }

    private boolean isSinglePage() {
        return this.pages.length == 1;
    }

    private void createSinglePageArea(Composite composite, PreferencePage page) {
        this.createPageArea(composite, page);
        this.currentPage = page;
        this.updateMessage();
    }

    private Control createPageArea(Composite composite, PreferencePage page) {
        this.fPageContainer = this.createPageContainer(composite);
        this.fPageContainer.setLayoutData((Object)new GridData(1808));
        page.setContainer((IPreferencePageContainer)this);
        page.createControl(this.fPageContainer);
        return this.fPageContainer;
    }

    private void createDescriptionArea(Composite composite) {
        Composite titleComposite = new Composite(composite, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.verticalSpacing = 0;
        layout.horizontalSpacing = 0;
        titleComposite.setLayout((Layout)layout);
        titleComposite.setLayoutData((Object)new GridData(768));
        this.createMessageArea(titleComposite);
        Label titleBarSeparator = new Label(titleComposite, 258);
        GridData gd = new GridData(768);
        titleBarSeparator.setLayoutData((Object)gd);
    }

    private Composite createMessageArea(Composite parent) {
        this.fTitleArea = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.verticalSpacing = 0;
        layout.horizontalSpacing = 0;
        layout.numColumns = 2;
        Display display = parent.getDisplay();
        Color bg = JFaceColors.getBannerBackground((Display)display);
        Color fg = JFaceColors.getBannerForeground((Display)display);
        GridData layoutData = new GridData(1808);
        this.fTitleArea.setLayout((Layout)layout);
        this.fTitleArea.setLayoutData((Object)layoutData);
        this.fTitleArea.setBackground(bg);
        this.fMessageLabel = new CLabel(this.fTitleArea, 16384);
        this.fMessageLabel.setBackground(bg);
        this.fMessageLabel.setForeground(fg);
        this.fMessageLabel.setText(" ");
        this.fMessageLabel.setFont(JFaceResources.getBannerFont());
        IPropertyChangeListener fontListener = event -> {
            if ("org.eclipse.jface.bannerfont".equals(event.getProperty()) || "org.eclipse.jface.dialogfont".equals(event.getProperty())) {
                this.updateMessage();
            }
        };
        this.fMessageLabel.addDisposeListener(event -> JFaceResources.getFontRegistry().removeListener(fontListener));
        JFaceResources.getFontRegistry().addListener(fontListener);
        GridData gd = new GridData(1808);
        this.fMessageLabel.setLayoutData((Object)gd);
        this.fTitleImage = new Label(this.fTitleArea, 16384);
        this.fTitleImage.setBackground(bg);
        this.fTitleImage.setImage(TeamUIPlugin.getPlugin().getImageRegistry().get(PREF_DLG_TITLE_IMG));
        gd = new GridData();
        gd.horizontalAlignment = 3;
        this.fTitleImage.setLayoutData((Object)gd);
        this.updateMessage();
        return this.fTitleArea;
    }

    private Composite createPageContainer(Composite parent) {
        Composite result = new Composite(parent, 0);
        FillLayout layout = new FillLayout();
        layout.marginHeight = 5;
        layout.marginWidth = 5;
        result.setLayout((Layout)layout);
        return result;
    }

    public void setMinimumPageSize(Point size) {
        this.fMinimumPageSize.x = size.x;
        this.fMinimumPageSize.y = size.y;
    }

    public void setErrorMessage(String errorMessage) {
        if (errorMessage == null) {
            if (this.fMessageLabel.getImage() != null) {
                this.fMessageLabel.setBackground(this.fNormalMsgAreaBackground);
                this.fMessageLabel.setImage(null);
                this.fTitleImage.setImage(TeamUIPlugin.getPlugin().getImageRegistry().get(PREF_DLG_TITLE_IMG));
                this.fTitleArea.layout(true);
            }
            this.setMessage(this.fMessage);
        } else {
            this.fMessageLabel.setText(errorMessage);
            if (this.fMessageLabel.getImage() == null) {
                if (this.fErrorMsgImage == null) {
                    this.fErrorMsgImage = TeamUIPlugin.getPlugin().getImageRegistry().get(PREF_DLG_IMG_TITLE_ERROR);
                }
                this.fNormalMsgAreaBackground = this.fMessageLabel.getBackground();
                this.fMessageLabel.setBackground(JFaceColors.getErrorBackground((Display)this.fMessageLabel.getDisplay()));
                this.fMessageLabel.setImage(this.fErrorMsgImage);
                this.fTitleImage.setImage(null);
                this.fTitleArea.layout(true);
            }
        }
    }

    public void setMessage(String newMessage) {
        this.fMessage = newMessage;
        if (this.fMessage == null) {
            this.fMessage = "";
        }
        if (this.fMessageLabel.getImage() == null) {
            this.fMessageLabel.setText(this.fMessage);
        }
    }

    public void updateMessage() {
        if (this.currentPage != null) {
            String pageMessage = this.currentPage.getMessage();
            String pageErrorMessage = this.currentPage.getErrorMessage();
            if (pageMessage == null && pageErrorMessage == null) {
                this.fMessageLabel.setFont(JFaceResources.getBannerFont());
            } else {
                this.fMessageLabel.setFont(JFaceResources.getDialogFont());
            }
            if (pageMessage == null) {
                if (this.isSinglePage()) {
                    this.setMessage(TeamUIMessages.PreferencePageContainerDialog_6);
                } else {
                    String title = this.currentPage.getTitle();
                    title = title.replaceAll("&", "");
                    this.setMessage(title);
                }
            } else {
                this.setMessage(pageMessage);
            }
            this.setErrorMessage(pageErrorMessage);
        }
    }

    public IPreferenceStore getPreferenceStore() {
        return null;
    }

    public void updateButtons() {
        if (this.fOkButton != null) {
            boolean isValid = true;
            PreferencePage[] preferencePageArray = this.pages;
            int n = this.pages.length;
            int n2 = 0;
            while (n2 < n) {
                PreferencePage page = preferencePageArray[n2];
                if (!page.isValid()) {
                    isValid = false;
                    break;
                }
                ++n2;
            }
            this.fOkButton.setEnabled(isValid);
        }
    }

    public void updateTitle() {
        this.updateMessage();
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.fOkButton = this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected void handleSave() {
        PreferencePage[] preferencePageArray = this.pages;
        int n = this.pages.length;
        int n2 = 0;
        while (n2 < n) {
            PreferencePage page = preferencePageArray[n2];
            IPreferenceStore store = page.getPreferenceStore();
            if (store != null && store.needsSaving() && store instanceof IPersistentPreferenceStore) {
                try {
                    ((IPersistentPreferenceStore)store).save();
                }
                catch (IOException e) {
                    Utils.handle(e);
                }
            }
            ++n2;
        }
    }

    public void addPageChangedListener(IPageChangedListener listener) {
        this.pageChangedListeners.add((Object)listener);
    }

    public Object getSelectedPage() {
        return this.currentPage;
    }

    public void removePageChangedListener(IPageChangedListener listener) {
        this.pageChangedListeners.remove((Object)listener);
    }

    private void firePageChanged(final PageChangedEvent event) {
        Object[] listeners;
        Object[] objectArray = listeners = this.pageChangedListeners.getListeners();
        int n = listeners.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            final IPageChangedListener l = (IPageChangedListener)listener;
            SafeRunnable.run((ISafeRunnable)new SafeRunnable(){

                public void run() {
                    l.pageChanged(event);
                }
            });
            ++n2;
        }
    }
}

