/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hawk.modelio.exml.metamodel.register;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.eclipse.hawk.core.model.IHawkObject;
import org.eclipse.hawk.modelio.exml.metamodel.ModelioClass;
import org.eclipse.hawk.modelio.exml.metamodel.ModelioMetaModelResource;
import org.eclipse.hawk.modelio.exml.metamodel.ModelioPackage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetamodelRegister {
    private static final Logger LOGGER = LoggerFactory.getLogger(ModelioClass.class);
    public static final MetamodelRegister INSTANCE = new MetamodelRegister();
    private Map<String, SortedMap<String, ModelioPackage>> registeredMetamodelsByName = new HashMap<String, SortedMap<String, ModelioPackage>>();

    public Collection<ModelioPackage> getRegisteredPackages() {
        ArrayList<ModelioPackage> registeredPackages = new ArrayList<ModelioPackage>();
        for (Map map : this.registeredMetamodelsByName.values()) {
            for (ModelioPackage pkg : map.values()) {
                registeredPackages.add(pkg);
            }
        }
        return registeredPackages;
    }

    public void clean() {
        this.registeredMetamodelsByName.clear();
    }

    public void registerPackages(ModelioPackage pkg) {
        SortedMap<String, ModelioPackage> versions = this.registeredMetamodelsByName.get(pkg.getName());
        if (versions == null) {
            versions = new TreeMap<String, ModelioPackage>();
            this.registeredMetamodelsByName.put(pkg.getName(), versions);
        }
        if (versions.put(pkg.getVersion(), pkg) == null) {
            LOGGER.info("registered package: " + pkg.getName() + "(" + pkg.getNsURI() + ")");
        }
    }

    public void registerPackages(ModelioMetaModelResource r) {
        for (IHawkObject e : r.getAllContents()) {
            if (!(e instanceof ModelioPackage)) continue;
            this.registerPackages((ModelioPackage)e);
        }
    }

    private ModelioClass getMClass(String className, Map<String, String> mmPackageVersions) {
        ArrayList<String> pkgNames = mmPackageVersions == null ? new ArrayList<String>(this.registeredMetamodelsByName.keySet()) : new ArrayList<String>(mmPackageVersions.keySet());
        Collections.sort(pkgNames, (a, b) -> {
            if ("Standard".equals(a)) {
                return -1;
            }
            if ("Standard".equals(b)) {
                return 1;
            }
            return a.compareTo((String)b);
        });
        for (String pkgName : pkgNames) {
            SortedMap<String, ModelioPackage> versions = this.registeredMetamodelsByName.get(pkgName);
            if (versions == null) continue;
            for (ModelioPackage pkg : versions.values()) {
                ModelioClass mc = pkg.getClassifier(className);
                if (mc == null) continue;
                ModelioClass requiredMClass = this.findRequiredVersion(versions, className, pkg.getName(), mmPackageVersions);
                if (requiredMClass != null) {
                    return requiredMClass;
                }
                ModelioClass latestMClass = this.findLatestVersion(versions, className, pkg.getName());
                if (latestMClass != null) {
                    return latestMClass;
                }
                return mc;
            }
        }
        return null;
    }

    private ModelioClass findRequiredVersion(SortedMap<String, ModelioPackage> versions, String className, String pkgName, Map<String, String> mmPackageVersions) {
        ModelioPackage tmpPkg;
        String requiredVersion = null;
        ModelioClass tmpmc = null;
        if (mmPackageVersions != null) {
            requiredVersion = mmPackageVersions.get(pkgName);
        }
        if (requiredVersion != null && (tmpPkg = (ModelioPackage)versions.get(requiredVersion)) != null) {
            tmpmc = tmpPkg.getClassifier(className);
        }
        return tmpmc;
    }

    private ModelioClass findLatestVersion(SortedMap<String, ModelioPackage> versions, String className, String pkgName) {
        ModelioPackage tmpPkg;
        ModelioClass tmpmc = null;
        String latestVerison = this.getLatestVersion(pkgName);
        if (latestVerison != null && (tmpPkg = (ModelioPackage)versions.get(latestVerison)) != null) {
            tmpmc = tmpPkg.getClassifier(className);
        }
        return tmpmc;
    }

    private ModelioClass getMClass(String pkgName, String className, String requiredVersion) {
        Map versions = this.registeredMetamodelsByName.get(pkgName);
        if (versions != null) {
            ModelioPackage pkg = null;
            if (requiredVersion != null) {
                pkg = (ModelioPackage)versions.get(requiredVersion);
            }
            if (pkg == null) {
                pkg = (ModelioPackage)versions.get(this.getLatestVersion(pkgName));
            }
            if (pkg != null) {
                return pkg.getClassifier(className);
            }
        }
        return null;
    }

    private String getLatestVersion(String pkgName) {
        SortedMap<String, ModelioPackage> versions = this.registeredMetamodelsByName.get(pkgName);
        if (versions != null) {
            return versions.lastKey();
        }
        return null;
    }

    public ModelioClass getModelioClass(String className, Map<String, String> mmPackageVersions) {
        ModelioClass mc = null;
        String version = null;
        int idxDot = className.indexOf(".");
        if (idxDot > -1) {
            String pkgName = className.substring(0, idxDot);
            String mcName = className.substring(idxDot + 1);
            if (mmPackageVersions != null) {
                version = mmPackageVersions.get(pkgName);
            }
            mc = this.getMClass(pkgName, mcName, version);
        } else {
            mc = this.getMClass(className, mmPackageVersions);
        }
        return mc;
    }
}

