/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hawk.modelio.exml.metamodel;

import java.io.File;
import java.io.FileReader;
import java.io.StringReader;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import org.eclipse.hawk.core.IMetaModelResourceFactory;
import org.eclipse.hawk.core.model.IHawkMetaModelResource;
import org.eclipse.hawk.core.model.IHawkPackage;
import org.eclipse.hawk.modelio.exml.metamodel.ModelioMetaModelResource;
import org.eclipse.hawk.modelio.exml.metamodel.ModelioPackage;
import org.eclipse.hawk.modelio.exml.metamodel.parser.MMetamodelDescriptor;
import org.eclipse.hawk.modelio.exml.metamodel.parser.MMetamodelParser;
import org.eclipse.hawk.modelio.exml.metamodel.register.MetamodelRegister;
import org.xml.sax.InputSource;

public class ModelioMetaModelResourceFactory
implements IMetaModelResourceFactory {
    private final Set<String> metamodelExtensions;
    MMetamodelParser parser = new MMetamodelParser();

    public ModelioMetaModelResourceFactory() {
        this.metamodelExtensions = new HashSet<String>();
        this.metamodelExtensions.add(".xml");
    }

    public String getHumanReadableName() {
        return "Modelio Metamodel Resource Factory";
    }

    public IHawkMetaModelResource parse(File f) throws Exception {
        return this.getMetamodelResource(new InputSource(new FileReader(f)));
    }

    public Set<IHawkMetaModelResource> getStaticMetamodels() {
        return Collections.emptySet();
    }

    public void shutdown() {
    }

    public boolean canParse(File f) {
        String[] split = f.getPath().split("\\.");
        String extension = split[split.length - 1];
        return this.getMetamodelExtensions().contains("." + extension);
    }

    public Set<String> getMetamodelExtensions() {
        return this.metamodelExtensions;
    }

    public Collection<String> getMetaModelExtensions() {
        return this.metamodelExtensions;
    }

    public ModelioMetaModelResource parseFromString(String name, String contents) throws Exception {
        if ("".equals(contents)) {
            return new ModelioMetaModelResource(new MMetamodelDescriptor(), this);
        }
        return this.getMetamodelResource(new InputSource(new StringReader(contents)));
    }

    public Optional<String> dumpPackageToString(IHawkPackage ePackage) throws Exception {
        ModelioPackage mPackage = (ModelioPackage)ePackage;
        return Optional.of(mPackage.getXml());
    }

    private ModelioMetaModelResource getMetamodelResource(InputSource is) {
        ModelioMetaModelResource modelioMetamodel = new ModelioMetaModelResource(this.parser.parse(is), this);
        MetamodelRegister.INSTANCE.registerPackages(modelioMetamodel);
        return modelioMetamodel;
    }
}

