/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hawk.modelio.exml.metamodel;

import java.lang.ref.SoftReference;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.hawk.core.model.IHawkAttribute;
import org.eclipse.hawk.core.model.IHawkClass;
import org.eclipse.hawk.core.model.IHawkClassifier;
import org.eclipse.hawk.core.model.IHawkReference;
import org.eclipse.hawk.core.model.IHawkStructuralFeature;
import org.eclipse.hawk.modelio.exml.metamodel.AbstractModelioObject;
import org.eclipse.hawk.modelio.exml.metamodel.AlwaysContainerModelioReference;
import org.eclipse.hawk.modelio.exml.metamodel.IgnoreContainmentModelioReference;
import org.eclipse.hawk.modelio.exml.metamodel.ModelioAttribute;
import org.eclipse.hawk.modelio.exml.metamodel.ModelioPackage;
import org.eclipse.hawk.modelio.exml.metamodel.ModelioReference;
import org.eclipse.hawk.modelio.exml.metamodel.mlib.MAttribute;
import org.eclipse.hawk.modelio.exml.metamodel.mlib.MClass;
import org.eclipse.hawk.modelio.exml.metamodel.mlib.MDependency;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModelioClass
extends AbstractModelioObject
implements IHawkClass {
    public static final String REF_PARENT = "hawkParent";
    public static final String REF_CHILDREN = "hawkChildren";
    private static final Logger LOGGER = LoggerFactory.getLogger(ModelioClass.class);
    protected final ModelioPackage mPackage;
    protected final MClass rawClass;
    protected Map<String, ModelioAttribute> ownAttributes;
    protected Map<String, ModelioAttribute> allAttributes;
    protected Map<String, ModelioReference> ownReferences;
    protected Map<String, ModelioReference> allReferences;
    protected SoftReference<Set<ModelioClass>> cachedAllSuperTypes;

    public ModelioClass(ModelioPackage pkg, MClass mc) {
        this.mPackage = pkg;
        this.rawClass = mc;
    }

    public String getInstanceType() {
        return this.rawClass.getName();
    }

    public boolean isRoot() {
        return false;
    }

    public String getUri() {
        return String.valueOf(this.mPackage.getNsURI()) + "#" + this.rawClass.getId();
    }

    public String getUriFragment() {
        return this.rawClass.getId();
    }

    public boolean isFragmentUnique() {
        return true;
    }

    public IHawkClassifier getType() {
        return this.mPackage.getResource().getMetaType();
    }

    public boolean isSet(IHawkStructuralFeature hsf) {
        switch (hsf.getName()) {
            case "name": {
                return true;
            }
        }
        return false;
    }

    public Object get(IHawkAttribute attr) {
        switch (attr.getName()) {
            case "name": {
                return this.rawClass.getName();
            }
        }
        return null;
    }

    public Object get(IHawkReference ref, boolean b) {
        return null;
    }

    public String getName() {
        return this.rawClass.getName();
    }

    public String getId() {
        return this.rawClass.getId();
    }

    public ModelioPackage getPackage() {
        return this.mPackage;
    }

    public String getPackageNSURI() {
        return this.mPackage.getNsURI();
    }

    public Set<IHawkAttribute> getAllAttributes() {
        return new HashSet<IHawkAttribute>(this.getAllAttributesMap().values());
    }

    public Map<String, ModelioAttribute> getAllAttributesMap() {
        if (this.allAttributes == null) {
            this.allAttributes = new HashMap<String, ModelioAttribute>();
            this.allAttributes.putAll(this.getOwnAttributesMap());
            for (IHawkClass iHawkClass : this.getAllSuperTypes()) {
                ModelioClass mcSuper = (ModelioClass)iHawkClass;
                this.allAttributes.putAll(mcSuper.getOwnAttributesMap());
            }
        }
        return this.allAttributes;
    }

    public Map<String, ModelioAttribute> getOwnAttributesMap() {
        if (this.ownAttributes == null) {
            this.ownAttributes = new HashMap<String, ModelioAttribute>();
            for (MAttribute mattr : this.rawClass.getMAttributes()) {
                ModelioAttribute attr = new ModelioAttribute(this, mattr);
                if (attr.getType() != null) {
                    this.ownAttributes.put(mattr.getName(), attr);
                    continue;
                }
                LOGGER.warn("Attribute '{}#{}' has an unknown data type, skipping", (Object)this.rawClass.getName(), (Object)mattr.getName());
            }
        }
        return this.ownAttributes;
    }

    public Set<IHawkReference> getAllReferences() {
        return new HashSet<IHawkReference>(this.getAllReferencesMap().values());
    }

    public Map<String, ModelioReference> getAllReferencesMap() {
        if (this.allReferences == null) {
            this.allReferences = new HashMap<String, ModelioReference>();
            this.allReferences.putAll(this.getOwnReferencesMap());
            for (IHawkClass iHawkClass : this.getAllSuperTypes()) {
                ModelioClass mcSuper = (ModelioClass)iHawkClass;
                this.allReferences.putAll(mcSuper.getOwnReferencesMap());
            }
        }
        return this.allReferences;
    }

    public Map<String, ModelioReference> getOwnReferencesMap() {
        if (this.ownReferences == null) {
            this.ownReferences = new HashMap<String, ModelioReference>();
            for (MDependency mdep : this.rawClass.getMDependencies()) {
                this.ownReferences.put(mdep.getName(), new IgnoreContainmentModelioReference(this, mdep));
            }
            if (this.rawClass.getMSuperType().isEmpty()) {
                MDependency mContainmentDep = new MDependency("HP", REF_PARENT, this.rawClass, false, false, true, false);
                this.ownReferences.put(mContainmentDep.getName(), new AlwaysContainerModelioReference(this, mContainmentDep));
            }
        }
        return this.ownReferences;
    }

    public Set<ModelioClass> getAllSuperTypes() {
        Set<ModelioClass> superClasses;
        Set<ModelioClass> set = superClasses = this.cachedAllSuperTypes != null ? this.cachedAllSuperTypes.get() : null;
        if (superClasses == null) {
            superClasses = new HashSet<ModelioClass>();
            for (MClass superRawClass : this.rawClass.getMSuperType()) {
                ModelioClass superClass = this.mPackage.getResource().getModelioClassById(superRawClass.getId());
                if (!superClasses.add(superClass)) continue;
                superClasses.addAll(superClass.getAllSuperTypes());
            }
            this.cachedAllSuperTypes = new SoftReference<Set<ModelioClass>>(superClasses);
        }
        return superClasses;
    }

    public Set<ModelioClass> getSuperTypes() {
        return this.getAllSuperTypes();
    }

    public Set<IHawkClass> getOwnSuperTypes() {
        HashSet<IHawkClass> superClasses = new HashSet<IHawkClass>();
        for (MClass superRawClass : this.rawClass.getMSuperType()) {
            ModelioClass superClass = this.mPackage.getResource().getModelioClassById(superRawClass.getId());
            superClasses.add(superClass);
        }
        return superClasses;
    }

    public boolean isAbstract() {
        return false;
    }

    public boolean isInterface() {
        return false;
    }

    public IHawkStructuralFeature getStructuralFeature(String name) {
        ModelioAttribute attr = this.getAllAttributesMap().get(name);
        if (attr != null) {
            return attr;
        }
        return (IHawkStructuralFeature)this.getAllReferencesMap().get(name);
    }

    @Override
    public String getExml() {
        return null;
    }

    public String toString() {
        return "ModelioClass [name=" + this.getName() + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.rawClass == null ? 0 : this.rawClass.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ModelioClass other = (ModelioClass)obj;
        return !(this.rawClass == null ? other.rawClass != null : !this.rawClass.equals(other.rawClass));
    }
}

