/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hawk.service.servlet.processors;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledFuture;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.api.core.client.ActiveMQClient;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.core.remoting.impl.invm.InVMConnectorFactory;
import org.apache.thrift.TException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.hawk.core.ICredentialsStore;
import org.eclipse.hawk.core.IHawkFactory;
import org.eclipse.hawk.core.IHawkPlugin;
import org.eclipse.hawk.core.IMetaModelResourceFactory;
import org.eclipse.hawk.core.IModelIndexer;
import org.eclipse.hawk.core.IStateListener;
import org.eclipse.hawk.core.IVcsManager;
import org.eclipse.hawk.core.graph.IGraphChangeListener;
import org.eclipse.hawk.core.graph.IGraphDatabase;
import org.eclipse.hawk.core.graph.IGraphNode;
import org.eclipse.hawk.core.graph.IGraphNodeReference;
import org.eclipse.hawk.core.graph.IGraphTransaction;
import org.eclipse.hawk.core.graph.IGraphTypeNodeReference;
import org.eclipse.hawk.core.query.InvalidQueryException;
import org.eclipse.hawk.core.query.QueryExecutionException;
import org.eclipse.hawk.core.runtime.LocalHawkFactory;
import org.eclipse.hawk.core.util.GraphChangeAdapter;
import org.eclipse.hawk.core.util.IndexedAttributeParameters;
import org.eclipse.hawk.graph.FileNode;
import org.eclipse.hawk.graph.GraphWrapper;
import org.eclipse.hawk.graph.MetamodelNode;
import org.eclipse.hawk.graph.ModelElementNode;
import org.eclipse.hawk.graph.TypeNode;
import org.eclipse.hawk.osgiserver.HManager;
import org.eclipse.hawk.osgiserver.HModel;
import org.eclipse.hawk.osgiserver.HModelSchedulingRule;
import org.eclipse.hawk.osgiserver.SecurePreferencesCredentialsStore;
import org.eclipse.hawk.service.api.Credentials;
import org.eclipse.hawk.service.api.DerivedAttributeSpec;
import org.eclipse.hawk.service.api.EffectiveMetamodelRuleset;
import org.eclipse.hawk.service.api.FailedQuery;
import org.eclipse.hawk.service.api.Hawk;
import org.eclipse.hawk.service.api.HawkFactoryNotFound;
import org.eclipse.hawk.service.api.HawkInstance;
import org.eclipse.hawk.service.api.HawkInstanceNotFound;
import org.eclipse.hawk.service.api.HawkInstanceNotRunning;
import org.eclipse.hawk.service.api.HawkMetamodelNotFound;
import org.eclipse.hawk.service.api.HawkPlugin;
import org.eclipse.hawk.service.api.HawkPluginCategory;
import org.eclipse.hawk.service.api.HawkQueryOptions;
import org.eclipse.hawk.service.api.HawkTypeNotFound;
import org.eclipse.hawk.service.api.IndexedAttributeSpec;
import org.eclipse.hawk.service.api.InvalidDerivedAttributeSpec;
import org.eclipse.hawk.service.api.InvalidIndexedAttributeSpec;
import org.eclipse.hawk.service.api.InvalidMetamodel;
import org.eclipse.hawk.service.api.InvalidPollingConfiguration;
import org.eclipse.hawk.service.api.InvalidQuery;
import org.eclipse.hawk.service.api.MetamodelParserDetails;
import org.eclipse.hawk.service.api.ModelElement;
import org.eclipse.hawk.service.api.QueryReport;
import org.eclipse.hawk.service.api.QueryResult;
import org.eclipse.hawk.service.api.Repository;
import org.eclipse.hawk.service.api.Subscription;
import org.eclipse.hawk.service.api.SubscriptionDurability;
import org.eclipse.hawk.service.api.UnknownQueryLanguage;
import org.eclipse.hawk.service.api.UnknownRepositoryType;
import org.eclipse.hawk.service.api.VCSAuthenticationFailed;
import org.eclipse.hawk.service.api.utils.APIUtils;
import org.eclipse.hawk.service.artemis.server.Server;
import org.eclipse.hawk.service.servlet.Activator;
import org.eclipse.hawk.service.servlet.artemis.ArtemisProducerGraphChangeListener;
import org.eclipse.hawk.service.servlet.artemis.ArtemisProducerStateListener;
import org.eclipse.hawk.service.servlet.utils.HawkModelElementEncoder;
import org.eclipse.hawk.service.servlet.utils.HawkModelElementTypeEncoder;
import org.osgi.framework.FrameworkUtil;
import org.osgi.service.prefs.BackingStoreException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HawkThriftIface
implements Hawk.Iface {
    private static final Logger LOGGER = LoggerFactory.getLogger(HawkThriftIface.class);
    private final APIUtils.ThriftProtocol thriftProtocol;
    private final Server artemisServer;
    private final HttpServletRequest request;
    private static final Map<String, AsyncQueryExecutionJob> ASYNC_QUERIES = new ConcurrentHashMap<String, AsyncQueryExecutionJob>();

    public static String getStateQueueName(HModel model) {
        return "hawkstate." + model.getName();
    }

    HawkThriftIface() {
        this(null, null, null);
    }

    public HawkThriftIface(APIUtils.ThriftProtocol eventProtocol, HttpServletRequest request, Server artemisServer) {
        this.thriftProtocol = eventProtocol;
        this.request = request;
        this.artemisServer = artemisServer;
    }

    public APIUtils.ThriftProtocol getThriftProtocol() {
        return this.thriftProtocol;
    }

    private HModel getRunningHawkByName(String name) throws HawkInstanceNotFound, HawkInstanceNotRunning {
        HModel model = this.getHawkByName(name);
        if (model.isRunning()) {
            return model;
        }
        HawkInstanceNotRunning e = new HawkInstanceNotRunning();
        e.setInstanceName(name);
        throw e;
    }

    private HModel getHawkByName(String name) throws HawkInstanceNotFound {
        HModel model = HManager.getInstance().getHawkByName(name);
        if (model == null) {
            HawkInstanceNotFound e = new HawkInstanceNotFound();
            e.setInstanceName(name);
            throw e;
        }
        return model;
    }

    public void registerMetamodels(String name, List<org.eclipse.hawk.service.api.File> metamodels) throws HawkInstanceNotFound, HawkInstanceNotRunning, InvalidMetamodel, TException {
        HModel model = this.getRunningHawkByName(name);
        ArrayList<File> files = new ArrayList<File>();
        for (org.eclipse.hawk.service.api.File f : metamodels) {
            try {
                String safeName = f.name.replaceAll("/", "_").replaceAll("\\\\", "_");
                File dataFile = Activator.getInstance().writeToDataFile(safeName, f.contents);
                files.add(dataFile);
            }
            catch (FileNotFoundException ex) {
                throw new TException((Throwable)ex);
            }
            catch (IOException ex) {
                throw new TException((Throwable)ex);
            }
        }
        File[] fArray = files.toArray(new File[files.size()]);
        try {
            model.registerMeta(fArray);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            throw new InvalidMetamodel(String.valueOf(e.getMessage()));
        }
    }

    public void unregisterMetamodels(String name, List<String> metamodels) throws HawkInstanceNotFound, HawkInstanceNotRunning, TException {
        HModel model = this.getRunningHawkByName(name);
        model.removeMetamodels(metamodels.toArray(new String[metamodels.size()]));
    }

    public List<String> listMetamodels(String name) throws HawkInstanceNotFound, HawkInstanceNotRunning {
        HModel model = this.getRunningHawkByName(name);
        return model.getRegisteredMetamodels();
    }

    public List<String> listQueryLanguages(String name) throws HawkInstanceNotFound, HawkInstanceNotRunning {
        HModel model = this.getRunningHawkByName(name);
        return new ArrayList<String>(model.getKnownQueryLanguages());
    }

    public QueryResult query(String name, String query, String language, HawkQueryOptions opts) throws HawkInstanceNotFound, UnknownQueryLanguage, InvalidQuery, FailedQuery, TException {
        return this.performQuery(name, query, language, opts, null);
    }

    public QueryReport timedQuery(String name, String query, String language, HawkQueryOptions opts) throws HawkInstanceNotFound, UnknownQueryLanguage, InvalidQuery, FailedQuery, TException {
        return this.performTimedQuery(name, query, language, opts, null);
    }

    private QueryResult performQuery(String name, String query, String language, HawkQueryOptions opts, Consumer<Runnable> cancelConsumer) throws HawkInstanceNotFound, HawkInstanceNotRunning, InvalidQuery, FailedQuery, TException {
        HModel model = this.getRunningHawkByName(name);
        try {
            HashMap<String, Object> context = new HashMap<String, Object>();
            if (opts.isSetDefaultNamespaces()) {
                context.put("DEFAULTNAMESPACES", opts.getDefaultNamespaces());
            }
            if (opts.isSetRepositoryPattern() || opts.isSetFilePatterns()) {
                boolean allFiles;
                boolean allRepositories = !opts.isSetRepositoryPattern() || "*".equals(opts.getRepositoryPattern());
                boolean bl = allFiles = !opts.isSetFilePatterns() || Arrays.asList("*").equals(opts.getFilePatterns());
                if (!allRepositories || !allFiles) {
                    context.put("REPOSITORY", opts.isSetRepositoryPattern() ? opts.getRepositoryPattern() : "*");
                    context.put("FILE", opts.isSetFilePatterns() ? this.join(opts.getFilePatterns(), ",") : "*");
                }
            }
            if (cancelConsumer != null) {
                context.put("EXEC_CANCEL_CONSUMER", cancelConsumer);
            }
            IModelIndexer indexer = model.getHawk().getModelIndexer();
            ScheduledFuture result = indexer.scheduleTask(() -> {
                Object ret = model.query(query, language, context);
                GraphWrapper gw = new GraphWrapper(model.getGraph());
                HawkModelElementEncoder enc = new HawkModelElementEncoder(gw);
                enc.setUseContainment(hawkQueryOptions.includeContained);
                enc.setIncludeNodeIDs(hawkQueryOptions.includeNodeIDs);
                enc.setIncludeAttributes(hawkQueryOptions.includeAttributes);
                enc.setIncludeReferences(hawkQueryOptions.includeReferences);
                enc.setIncludeDerived(hawkQueryOptions.includeDerived);
                EffectiveMetamodelRuleset emm = new EffectiveMetamodelRuleset(opts.getEffectiveMetamodelIncludes(), opts.getEffectiveMetamodelExcludes());
                if (!emm.isEverythingIncluded()) {
                    enc.setEffectiveMetamodel(emm);
                }
                HawkModelElementTypeEncoder typeEnc = new HawkModelElementTypeEncoder(gw);
                Throwable throwable = null;
                Object var12_13 = null;
                try (IGraphTransaction t = model.getGraph().beginTransaction();){
                    return this.encodeValue(model, ret, enc, typeEnc);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }, 0L);
            try {
                return (QueryResult)result.get();
            }
            catch (ExecutionException ex) {
                throw ex.getCause();
            }
        }
        catch (InvalidQueryException ex) {
            throw new InvalidQuery(ex.getMessage());
        }
        catch (QueryExecutionException ex) {
            throw new FailedQuery(ex.getMessage());
        }
        catch (Throwable ex) {
            throw new TException(ex);
        }
    }

    private QueryReport performTimedQuery(String name, String query, String language, HawkQueryOptions opts, Consumer<Runnable> cancelConsumer) throws HawkInstanceNotFound, UnknownQueryLanguage, InvalidQuery, FailedQuery, TException {
        long startMillis = System.currentTimeMillis();
        QueryResult result = this.performQuery(name, query, language, opts, cancelConsumer);
        long endMillis = System.currentTimeMillis();
        QueryReport queryReport = new QueryReport();
        queryReport.setResult(result);
        queryReport.setWallMillis(endMillis - startMillis);
        return queryReport;
    }

    private String join(List<String> strings, String separator) {
        StringBuffer sbuf = new StringBuffer();
        boolean first = true;
        for (String s : strings) {
            if (first) {
                first = false;
            } else {
                sbuf.append(separator);
            }
            sbuf.append(s);
        }
        return sbuf.toString();
    }

    private QueryResult encodeValue(HModel model, Object ret, HawkModelElementEncoder enc, HawkModelElementTypeEncoder typeEnc) throws Exception {
        if (ret instanceof Boolean) {
            return new QueryResult(QueryResult._Fields.V_BOOLEAN, (Object)((Boolean)ret));
        }
        if (ret instanceof Byte) {
            return new QueryResult(QueryResult._Fields.V_BYTE, (Object)((Byte)ret));
        }
        if (ret instanceof Double || ret instanceof Float) {
            return new QueryResult(QueryResult._Fields.V_DOUBLE, (Object)((Number)ret).doubleValue());
        }
        if (ret instanceof Integer) {
            return new QueryResult(QueryResult._Fields.V_INTEGER, (Object)((Integer)ret));
        }
        if (ret instanceof Long) {
            return new QueryResult(QueryResult._Fields.V_LONG, (Object)((Long)ret));
        }
        if (ret instanceof Short) {
            return new QueryResult(QueryResult._Fields.V_SHORT, (Object)((Short)ret));
        }
        if (ret instanceof String) {
            return new QueryResult(QueryResult._Fields.V_STRING, (Object)((String)ret));
        }
        if (ret instanceof IGraphTypeNodeReference) {
            IGraphNode n = ((IGraphTypeNodeReference)ret).getNode();
            return new QueryResult(QueryResult._Fields.V_MODEL_ELEMENT_TYPE, typeEnc.encode(n));
        }
        if (ret instanceof IGraphNodeReference) {
            ModelElement meEncoded;
            IGraphNodeReference ref = (IGraphNodeReference)ret;
            if (!enc.isEncoded(ref.getId()) && (meEncoded = enc.encode(ref.getNode())) != null) {
                return new QueryResult(QueryResult._Fields.V_MODEL_ELEMENT, (Object)meEncoded);
            }
        } else if (ret instanceof IGraphNode) {
            ModelElement meEncoded;
            ModelElementNode meNode = new ModelElementNode((IGraphNode)ret);
            if (!enc.isEncoded(meNode) && (meEncoded = enc.encode(meNode)) != null) {
                return new QueryResult(QueryResult._Fields.V_MODEL_ELEMENT, (Object)meEncoded);
            }
        } else {
            if (ret instanceof Map) {
                HashMap<String, QueryResult> result = new HashMap<String, QueryResult>();
                for (Map.Entry entry : ((Map)ret).entrySet()) {
                    result.put("" + entry.getKey(), this.encodeValue(model, entry.getValue(), enc, typeEnc));
                }
                return new QueryResult(QueryResult._Fields.V_MAP, result);
            }
            if (ret instanceof Iterable) {
                ArrayList<QueryResult> result = new ArrayList<QueryResult>();
                Iterable c = (Iterable)ret;
                for (Object o : c) {
                    result.add(this.encodeValue(model, o, enc, typeEnc));
                }
                return new QueryResult(QueryResult._Fields.V_LIST, result);
            }
        }
        return new QueryResult(QueryResult._Fields.V_STRING, (Object)("" + ret));
    }

    public List<ModelElement> resolveProxies(String name, List<String> ids, HawkQueryOptions options) throws HawkInstanceNotFound, HawkInstanceNotRunning, TException {
        HModel model = this.getRunningHawkByName(name);
        IGraphDatabase graph = model.getGraph();
        try {
            Throwable throwable = null;
            Object var7_9 = null;
            try (IGraphTransaction tx = graph.beginTransaction();){
                HawkModelElementEncoder encoder = new HawkModelElementEncoder(new GraphWrapper(graph));
                encoder.setIncludeNodeIDs(true);
                encoder.setUseContainment(false);
                encoder.setIncludeAttributes(options.isIncludeAttributes());
                encoder.setIncludeReferences(options.isIncludeReferences());
                encoder.setIncludeDerived(options.isIncludeDerived());
                EffectiveMetamodelRuleset emm = new EffectiveMetamodelRuleset(options.getEffectiveMetamodelIncludes(), options.getEffectiveMetamodelExcludes());
                if (!emm.isEverythingIncluded()) {
                    encoder.setEffectiveMetamodel(emm);
                }
                for (String id : ids) {
                    try {
                        encoder.encode(id);
                    }
                    catch (Exception ex) {
                        LOGGER.error(ex.getMessage(), (Throwable)ex);
                    }
                }
                return encoder.getElements();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception ex) {
            throw new TException((Throwable)ex);
        }
    }

    public void addRepository(String name, Repository repo, Credentials credentials) throws HawkInstanceNotFound, HawkInstanceNotRunning, UnknownRepositoryType, VCSAuthenticationFailed {
        HModel model = this.getRunningHawkByName(name);
        try {
            String username = credentials != null ? credentials.username : null;
            String password = credentials != null ? credentials.password : null;
            model.addVCS(repo.uri, repo.type, username, password, repo.isFrozen);
        }
        catch (NoSuchElementException ex) {
            UnknownRepositoryType e = new UnknownRepositoryType();
            e.setRepositoryType(repo.type);
            throw e;
        }
    }

    public void removeRepository(String name, String uri) throws HawkInstanceNotFound, HawkInstanceNotRunning, TException {
        HModel model = this.getRunningHawkByName(name);
        try {
            for (IVcsManager mgr : new ArrayList(model.getIndexer().getRunningVCSManagers())) {
                if (!mgr.getLocation().equals(uri)) continue;
                model.removeRepository(mgr);
                break;
            }
        }
        catch (Exception ex) {
            throw new TException((Throwable)ex);
        }
    }

    public void updateRepositoryCredentials(String name, String uri, Credentials cred) throws HawkInstanceNotFound, HawkInstanceNotRunning, TException {
        HModel model = this.getRunningHawkByName(name);
        for (IVcsManager mgr : model.getRunningVCSManagers()) {
            if (!mgr.getLocation().equals(uri)) continue;
            mgr.setCredentials(cred.username, cred.password, model.getManager().getCredentialsStore());
            return;
        }
    }

    public List<Repository> listRepositories(String name) throws HawkInstanceNotFound, HawkInstanceNotRunning {
        HModel model = this.getRunningHawkByName(name);
        ArrayList<Repository> repos = new ArrayList<Repository>();
        for (IVcsManager mgr : model.getRunningVCSManagers()) {
            Repository repo = new Repository(mgr.getLocation(), mgr.getType());
            repo.setIsFrozen(mgr.isFrozen());
            repos.add(repo);
        }
        return repos;
    }

    public List<String> listRepositoryTypes() {
        return new ArrayList<String>(HManager.getInstance().getVCSTypes());
    }

    public List<String> listFiles(String name, List<String> repository, List<String> filePatterns) throws HawkInstanceNotFound, HawkInstanceNotRunning, TException {
        HModel model = this.getRunningHawkByName(name);
        IGraphDatabase graph = model.getGraph();
        try {
            Throwable throwable = null;
            Object var7_9 = null;
            try (IGraphTransaction t = graph.beginTransaction();){
                GraphWrapper gw = new GraphWrapper(graph);
                Set fileNodes = gw.getFileNodes(repository, filePatterns);
                ArrayList<String> files = new ArrayList<String>(fileNodes.size());
                for (FileNode node : fileNodes) {
                    files.add(node.getFilePath());
                }
                return files;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception ex) {
            LOGGER.error(ex.getMessage(), (Throwable)ex);
            throw new TException((Throwable)ex);
        }
    }

    public void configurePolling(String name, int base, int max) throws HawkInstanceNotFound, HawkInstanceNotRunning, InvalidPollingConfiguration {
        HModel model = this.getRunningHawkByName(name);
        model.configurePolling(base, max);
    }

    public void addDerivedAttribute(String name, DerivedAttributeSpec spec) throws HawkInstanceNotFound, HawkInstanceNotRunning, InvalidDerivedAttributeSpec, TException {
        HModel model = this.getRunningHawkByName(name);
        try {
            model.addDerivedAttribute(spec.metamodelUri, spec.typeName, spec.attributeName, spec.attributeType, Boolean.valueOf(spec.isMany), Boolean.valueOf(spec.isOrdered), Boolean.valueOf(spec.isUnique), spec.derivationLanguage, spec.derivationLogic);
        }
        catch (Exception ex) {
            throw new TException((Throwable)ex);
        }
    }

    public void removeDerivedAttribute(String name, DerivedAttributeSpec spec) throws HawkInstanceNotFound, HawkInstanceNotRunning {
        HModel model = this.getRunningHawkByName(name);
        model.removeDerivedAttribute(spec.metamodelUri, spec.typeName, spec.attributeName);
    }

    public List<DerivedAttributeSpec> listDerivedAttributes(String name) throws HawkInstanceNotFound, HawkInstanceNotRunning {
        HModel model = this.getRunningHawkByName(name);
        ArrayList<DerivedAttributeSpec> specs = new ArrayList<DerivedAttributeSpec>();
        for (IndexedAttributeParameters sIndexedAttr : model.getDerivedAttributes()) {
            DerivedAttributeSpec spec = new DerivedAttributeSpec(sIndexedAttr.getMetamodelUri(), sIndexedAttr.getTypeName(), sIndexedAttr.getAttributeName());
            specs.add(spec);
        }
        return specs;
    }

    public void addIndexedAttribute(String name, IndexedAttributeSpec spec) throws HawkInstanceNotFound, HawkInstanceNotRunning, InvalidIndexedAttributeSpec, TException {
        HModel model = this.getRunningHawkByName(name);
        try {
            model.addIndexedAttribute(spec.metamodelUri, spec.typeName, spec.attributeName);
        }
        catch (Exception e) {
            throw new TException((Throwable)e);
        }
    }

    public void removeIndexedAttribute(String name, IndexedAttributeSpec spec) throws HawkInstanceNotFound, HawkInstanceNotRunning {
        HModel model = this.getRunningHawkByName(name);
        model.removeIndexedAttribute(spec.metamodelUri, spec.typeName, spec.attributeName);
    }

    public List<IndexedAttributeSpec> listIndexedAttributes(String name) throws HawkInstanceNotFound, HawkInstanceNotRunning {
        HModel model = this.getRunningHawkByName(name);
        ArrayList<IndexedAttributeSpec> specs = new ArrayList<IndexedAttributeSpec>();
        for (IndexedAttributeParameters sIndexedAttr : model.getIndexedAttributes()) {
            IndexedAttributeSpec spec = new IndexedAttributeSpec(sIndexedAttr.getMetamodelUri(), sIndexedAttr.getTypeName(), sIndexedAttr.getAttributeName());
            specs.add(spec);
        }
        return specs;
    }

    public List<ModelElement> getModel(String name, HawkQueryOptions opts) throws HawkInstanceNotFound, HawkInstanceNotRunning, TException {
        return this.collectElements(name, CollectElements.ALL, opts);
    }

    public List<ModelElement> getRootElements(String name, HawkQueryOptions opts) throws TException {
        opts.setIncludeNodeIDs(true);
        return this.collectElements(name, CollectElements.ONLY_ROOTS, opts);
    }

    private List<ModelElement> collectElements(String name, CollectElements collectType, HawkQueryOptions opts) throws HawkInstanceNotFound, HawkInstanceNotRunning, TException {
        HModel model = this.getRunningHawkByName(name);
        try {
            Throwable throwable = null;
            Object var6_8 = null;
            try (IGraphTransaction tx = model.getGraph().beginTransaction();){
                GraphWrapper gw = new GraphWrapper(model.getGraph());
                HawkModelElementEncoder encoder = new HawkModelElementEncoder(gw);
                encoder.setIncludeAttributes(opts.includeAttributes);
                encoder.setIncludeReferences(opts.includeReferences);
                encoder.setIncludeDerived(opts.includeDerived);
                encoder.setIncludeNodeIDs(opts.includeNodeIDs);
                encoder.setUseContainment(opts.includeContained);
                EffectiveMetamodelRuleset emm = new EffectiveMetamodelRuleset(opts.getEffectiveMetamodelIncludes(), opts.getEffectiveMetamodelExcludes());
                if (!emm.isEverythingIncluded()) {
                    encoder.setEffectiveMetamodel(emm);
                }
                Set fileNodes = gw.getFileNodes(Arrays.asList(opts.getRepositoryPattern()), (Iterable)opts.getFilePatterns());
                if (emm.getInclusionRules().isEmpty() || collectType == CollectElements.ONLY_ROOTS) {
                    block11: for (FileNode fileNode : fileNodes) {
                        LOGGER.info("Retrieving elements from file {}", (Object)opts.getFilePatterns());
                        switch (collectType) {
                            case ALL: {
                                for (ModelElementNode meNode : fileNode.getModelElements()) {
                                    encoder.encode(meNode);
                                }
                                continue block11;
                            }
                            case ONLY_ROOTS: {
                                for (ModelElementNode meNode : fileNode.getRootModelElements()) {
                                    encoder.encode(meNode);
                                }
                                continue block11;
                            }
                        }
                    }
                } else {
                    for (Map.Entry mmEntry : emm.getInclusionRules().rowMap().entrySet()) {
                        String mmURI = (String)mmEntry.getKey();
                        MetamodelNode mn = gw.getMetamodelNodeByNsURI(mmURI);
                        for (TypeNode tn : mn.getTypes()) {
                            if (!emm.isIncluded(mmURI, tn.getTypeName())) continue;
                            LOGGER.info("Retrieving elements from type {}", (Object)tn.getTypeName());
                            for (ModelElementNode meNode : tn.getAll()) {
                                if (!fileNodes.contains(meNode.getFileNode())) continue;
                                encoder.encode(meNode);
                            }
                        }
                    }
                }
                return encoder.getElements();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception ex) {
            LOGGER.error(ex.getMessage(), (Throwable)ex);
            throw new TException((Throwable)ex);
        }
    }

    public void createInstance(String name, String backend, int minDelay, int maxDelay, List<String> plugins, String factoryName) throws TException {
        try {
            HManager manager = HManager.getInstance();
            if (manager.getHawkByName(name) == null) {
                LocalHawkFactory factory;
                if (factoryName == null) {
                    factory = new LocalHawkFactory();
                } else {
                    factory = (IHawkFactory)manager.getHawkFactoryInstances().get(factoryName);
                    if (factory == null) {
                        HawkFactoryNotFound e = new HawkFactoryNotFound();
                        e.setFactoryName(factoryName);
                        throw e;
                    }
                }
                HModel model = HModel.create((IHawkFactory)factory, (String)name, (File)this.storageFolder(name), null, (String)backend, plugins, (HManager)manager, (ICredentialsStore)new SecurePreferencesCredentialsStore(), (int)minDelay, (int)maxDelay);
                this.addStateListener(model);
            }
        }
        catch (Exception ex) {
            throw new TException((Throwable)ex);
        }
    }

    public List<String> listPlugins() throws TException {
        return HManager.getInstance().getAvailablePlugins().stream().map(p -> p.getType()).collect(Collectors.toList());
    }

    public List<HawkPlugin> listPluginDetails() throws TException {
        List hawkPlugins = HManager.getInstance().getAvailablePlugins();
        ArrayList<HawkPlugin> plugins = new ArrayList<HawkPlugin>();
        for (IHawkPlugin hp : hawkPlugins) {
            HawkPlugin p = new HawkPlugin();
            p.setDescription(hp.getHumanReadableName());
            p.setCategory(HawkPluginCategory.valueOf((String)hp.getCategory().name()));
            p.setName(hp.getType());
            plugins.add(p);
        }
        return plugins;
    }

    public List<String> listBackends() throws TException {
        return new ArrayList<String>(HManager.getInstance().getIndexTypes());
    }

    public List<HawkInstance> listInstances() throws TException {
        ArrayList<HawkInstance> instances = new ArrayList<HawkInstance>();
        for (HModel m : HManager.getInstance().getHawks()) {
            HawkInstance instance = new HawkInstance();
            instance.name = m.getName();
            instance.state = ArtemisProducerStateListener.mapHawkStateToThrift(m.getStatus());
            instance.message = m.getInfo();
            instances.add(instance);
        }
        return instances;
    }

    public void removeInstance(String name) throws HawkInstanceNotFound, TException {
        HModel model = this.getHawkByName(name);
        try {
            HManager.getInstance().delete(model, true);
            this.removeStateListener(model);
        }
        catch (BackingStoreException e) {
            throw new TException(e.getMessage(), (Throwable)e);
        }
    }

    public void startInstance(String name) throws HawkInstanceNotFound, TException {
        HModel model = this.getHawkByName(name);
        if (!model.isRunning()) {
            model.start(HManager.getInstance());
            this.addStateListener(model);
        }
    }

    public void stopInstance(String name) throws HawkInstanceNotFound, TException {
        HModel model = this.getHawkByName(name);
        if (model.isRunning()) {
            model.stop(IModelIndexer.ShutdownRequestType.ALWAYS);
            this.removeStateListener(model);
        }
    }

    protected void addStateListener(HModel model) {
        try {
            ArtemisProducerStateListener stateListener = new ArtemisProducerStateListener(model, HawkThriftIface.getStateQueueName(model));
            model.getIndexer().addStateListener((IStateListener)stateListener);
        }
        catch (Exception e) {
            LOGGER.error("Could not add the state listener", (Throwable)e);
        }
    }

    protected void removeStateListener(HModel model) {
        try {
            ArtemisProducerStateListener stateListener = new ArtemisProducerStateListener(model, HawkThriftIface.getStateQueueName(model));
            model.getIndexer().removeStateListener((IStateListener)stateListener);
        }
        catch (Exception e) {
            LOGGER.error("Could not remove the state listener", (Throwable)e);
        }
    }

    public Subscription watchModelChanges(String name, String repositoryUri, List<String> filePaths, String uniqueClientID, SubscriptionDurability durability) throws HawkInstanceNotFound, HawkInstanceNotRunning, TException {
        HModel model = this.getHawkByName(name);
        try {
            ArtemisProducerGraphChangeListener listener = new ArtemisProducerGraphChangeListener(model.getName(), repositoryUri, filePaths, durability, this.thriftProtocol);
            String queueAddress = listener.getQueueAddress();
            String queueName = String.valueOf(queueAddress) + "." + uniqueClientID;
            this.createQueue(queueAddress, queueName, durability);
            model.addGraphChangeListener((IGraphChangeListener)listener);
            return new Subscription(this.artemisServer.getHost(), this.artemisServer.getPort(), queueAddress, queueName, this.artemisServer.isSSLEnabled());
        }
        catch (Exception e) {
            LOGGER.error("Could not register the new listener", (Throwable)e);
            throw new TException((Throwable)e);
        }
    }

    public Subscription watchStateChanges(String name) throws HawkInstanceNotFound, HawkInstanceNotRunning, TException {
        HModel model = this.getHawkByName(name);
        try {
            String queueAddress = HawkThriftIface.getStateQueueName(model);
            String queueName = String.valueOf(queueAddress) + "." + UUID.randomUUID();
            return new Subscription(this.artemisServer.getHost(), this.artemisServer.getPort(), queueAddress, queueName, this.artemisServer.isSSLEnabled());
        }
        catch (Exception e) {
            LOGGER.error("Could not register the new listener", (Throwable)e);
            throw new TException((Throwable)e);
        }
    }

    private void createQueue(String queueAddress, String queueName, SubscriptionDurability durability) throws ActiveMQException, Exception {
        TransportConfiguration inVMTransportConfig = new TransportConfiguration(InVMConnectorFactory.class.getName());
        Throwable throwable = null;
        Object var6_7 = null;
        try (ServerLocator loc = ActiveMQClient.createServerLocatorWithoutHA((TransportConfiguration[])new TransportConfiguration[]{inVMTransportConfig});){
            Throwable throwable2 = null;
            Object var9_12 = null;
            try (ClientSessionFactory sf = loc.createSessionFactory();){
                Throwable throwable3 = null;
                Object var12_17 = null;
                try (ClientSession session = sf.createSession();){
                    ClientSession.QueueQuery queryResults = session.queueQuery(new SimpleString(queueName));
                    if (!queryResults.isExists()) {
                        switch (durability) {
                            case TEMPORARY: {
                                LOGGER.warn("Only a client may create a temporary queue: ignoring request");
                                break;
                            }
                            case DEFAULT: 
                            case DURABLE: {
                                session.createQueue(queueAddress, queueName, durability == SubscriptionDurability.DURABLE);
                                break;
                            }
                            default: {
                                throw new IllegalArgumentException("Unknown subscription durability " + durability);
                            }
                        }
                        session.commit();
                    }
                }
                catch (Throwable throwable4) {
                    if (throwable3 == null) {
                        throwable3 = throwable4;
                    } else if (throwable3 != throwable4) {
                        throwable3.addSuppressed(throwable4);
                    }
                    throw throwable3;
                }
            }
            catch (Throwable throwable5) {
                if (throwable2 == null) {
                    throwable2 = throwable5;
                } else if (throwable2 != throwable5) {
                    throwable2.addSuppressed(throwable5);
                }
                throw throwable2;
            }
        }
        catch (Throwable throwable6) {
            if (throwable == null) {
                throwable = throwable6;
            } else if (throwable != throwable6) {
                throwable.addSuppressed(throwable6);
            }
            throw throwable;
        }
    }

    private File storageFolder(String instanceName) throws IOException {
        File dataFile = new File(Activator.getInstance().getStateLocation().toFile(), "hawk-" + instanceName);
        if (!dataFile.exists()) {
            dataFile.mkdir();
            LOGGER.info("Created storage directory for instance '{}' in '{}'", (Object)instanceName, (Object)dataFile.getPath());
        } else {
            LOGGER.info("Reused storage directory for instance '{}' in '{}'", (Object)instanceName, (Object)dataFile.getPath());
        }
        return dataFile;
    }

    public void syncInstance(String name, boolean waitForSync) throws HawkInstanceNotFound, HawkInstanceNotRunning, TException {
        HModel model = this.getRunningHawkByName(name);
        try {
            SynchroniseLatchGraphChangeListener listener = null;
            if (waitForSync) {
                model.getIndexer().waitFor(IStateListener.HawkState.RUNNING);
                listener = new SynchroniseLatchGraphChangeListener();
                model.getIndexer().addGraphChangeListener((IGraphChangeListener)listener);
            }
            model.sync();
            if (listener != null) {
                listener.getLatch().await();
                model.getIndexer().removeGraphChangeListener((IGraphChangeListener)listener);
            }
        }
        catch (Exception e) {
            throw new TException("Could not force an immediate synchronisation", (Throwable)e);
        }
    }

    public boolean isFrozen(String name, String uri) throws HawkInstanceNotFound, HawkInstanceNotRunning, TException {
        for (Repository repo : this.listRepositories(name)) {
            if (!repo.uri.equals(uri)) continue;
            return repo.isFrozen;
        }
        return false;
    }

    public void setFrozen(String name, String uri, boolean isFrozen) throws HawkInstanceNotFound, HawkInstanceNotRunning, TException {
        HModel model = this.getHawkByName(name);
        for (IVcsManager manager : model.getRunningVCSManagers()) {
            if (!manager.getLocation().equals(uri)) continue;
            manager.setFrozen(isFrozen);
            break;
        }
    }

    public List<MetamodelParserDetails> listMetamodelParsers(String name) throws HawkInstanceNotFound, HawkInstanceNotRunning, TException {
        HModel model = this.getHawkByName(name);
        ArrayList<MetamodelParserDetails> results = new ArrayList<MetamodelParserDetails>();
        for (IMetaModelResourceFactory parser : model.getMetamodelParsers()) {
            MetamodelParserDetails details = new MetamodelParserDetails();
            details.setIdentifier(parser.getType());
            details.setFileExtensions(new HashSet(parser.getMetaModelExtensions()));
        }
        return results;
    }

    public List<String> listTypeNames(String hawkInstanceName, String metamodelURI) throws HawkInstanceNotFound, HawkInstanceNotRunning, HawkMetamodelNotFound, TException {
        HModel model = this.getRunningHawkByName(hawkInstanceName);
        try {
            return model.getIntrospector().getTypes(metamodelURI);
        }
        catch (NoSuchElementException ex) {
            HawkMetamodelNotFound e = new HawkMetamodelNotFound();
            e.setMetamodelURI(metamodelURI);
            throw e;
        }
    }

    public List<String> listAttributeNames(String hawkInstanceName, String metamodelURI, String typeName) throws HawkInstanceNotFound, HawkInstanceNotRunning, HawkMetamodelNotFound, HawkTypeNotFound, TException {
        HModel model = this.getRunningHawkByName(hawkInstanceName);
        if (!model.getIndexer().getKnownMMUris().contains(metamodelURI)) {
            HawkMetamodelNotFound e = new HawkMetamodelNotFound();
            e.setMetamodelURI(metamodelURI);
            throw e;
        }
        try {
            return model.getIntrospector().getAttributes(metamodelURI, typeName);
        }
        catch (NoSuchElementException ex) {
            HawkTypeNotFound e = new HawkTypeNotFound();
            e.setTypeName(typeName);
            throw e;
        }
    }

    public String asyncQuery(String hawkInstanceName, String query, String language, HawkQueryOptions options) throws HawkInstanceNotFound, HawkInstanceNotRunning, UnknownQueryLanguage, InvalidQuery, TException {
        HModel model = this.getRunningHawkByName(hawkInstanceName);
        String queryUUID = UUID.randomUUID().toString();
        AsyncQueryExecutionJob timedQueryJob = new AsyncQueryExecutionJob(queryUUID, language, options, query, hawkInstanceName);
        ASYNC_QUERIES.put(queryUUID, timedQueryJob);
        timedQueryJob.setRule((ISchedulingRule)new HModelSchedulingRule(model));
        timedQueryJob.schedule();
        return queryUUID;
    }

    public void cancelAsyncQuery(String queryID) throws TException {
        AsyncQueryExecutionJob queryJob = ASYNC_QUERIES.get(queryID);
        if (queryJob == null) {
            throw new InvalidQuery("Cannot find query with UUID " + queryID);
        }
        queryJob.cancel();
        ASYNC_QUERIES.remove(queryID);
    }

    public QueryReport fetchAsyncQueryResults(String queryID) throws TException {
        AsyncQueryExecutionJob queryJob = ASYNC_QUERIES.get(queryID);
        if (queryJob == null) {
            throw new InvalidQuery("Cannot find query with UUID " + queryID);
        }
        try {
            QueryReport queryReport = queryJob.getQueryReport().get();
            return queryReport;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            String reason = "Query " + queryID + " was interrupted";
            LOGGER.error(reason, (Throwable)e);
            throw new FailedQuery(reason);
        }
        catch (ExecutionException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            throw new FailedQuery(e.getMessage());
        }
        finally {
            ASYNC_QUERIES.remove(queryID);
        }
    }

    protected class AsyncQueryExecutionJob
    extends Job {
        private final String uuid;
        private final String hawkInstanceName;
        private final String language;
        private final String query;
        private final HawkQueryOptions options;
        private Runnable doCancel;
        private CompletableFuture<QueryReport> report;
        private long startMillis;

        protected AsyncQueryExecutionJob(String uuid, String language, HawkQueryOptions options, String query, String hawkInstanceName) {
            super("Running query " + uuid);
            this.report = new CompletableFuture();
            this.language = language;
            this.options = options;
            this.query = query;
            this.uuid = uuid;
            this.hawkInstanceName = hawkInstanceName;
        }

        protected void canceling() {
            if (this.doCancel != null) {
                this.doCancel.run();
                QueryReport rValue = new QueryReport();
                QueryResult rResult = new QueryResult();
                rResult.setVString("cancelled");
                rValue.setResult(rResult);
                rValue.setWallMillis(System.currentTimeMillis() - this.startMillis);
                rValue.setIsCancelled(true);
                this.report.complete(rValue);
            }
        }

        protected IStatus run(IProgressMonitor monitor) {
            try {
                this.startMillis = System.currentTimeMillis();
                QueryReport rValue = HawkThriftIface.this.performTimedQuery(this.hawkInstanceName, this.query, this.language, this.options, this::setDoCancel);
                this.report.complete(rValue);
                return new Status(0, this.getBundleName(), "Completed query " + this.uuid);
            }
            catch (Throwable e) {
                if (!this.report.isDone()) {
                    this.report.completeExceptionally(e);
                    return new Status(4, this.getBundleName(), "Query " + this.uuid + " failed: " + e.getMessage(), e);
                }
                return new Status(0, this.getBundleName(), "Cancelled query " + this.uuid);
            }
        }

        public Future<QueryReport> getQueryReport() {
            return this.report;
        }

        private String getBundleName() {
            return FrameworkUtil.getBundle(((Object)((Object)this)).getClass()).getSymbolicName();
        }

        private void setDoCancel(Runnable doCancel) {
            this.doCancel = doCancel;
        }
    }

    private static enum CollectElements {
        ALL,
        ONLY_ROOTS;

    }

    protected static final class SynchroniseLatchGraphChangeListener
    extends GraphChangeAdapter {
        boolean started = false;
        CountDownLatch latch = new CountDownLatch(1);

        protected SynchroniseLatchGraphChangeListener() {
        }

        public void synchroniseStart() {
            this.started = true;
        }

        public void synchroniseEnd() {
            if (this.started) {
                this.latch.countDown();
            }
        }

        public CountDownLatch getLatch() {
            return this.latch;
        }
    }
}

