/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hawk.service.api.utils;

import java.io.IOException;
import org.apache.http.Header;
import org.apache.http.HeaderElement;
import org.apache.http.HttpEntity;
import org.apache.http.HttpException;
import org.apache.http.HttpResponse;
import org.apache.http.HttpResponseInterceptor;
import org.apache.http.client.entity.GzipDecompressingEntity;
import org.apache.http.protocol.HttpContext;

class GZipResponseInterceptor
implements HttpResponseInterceptor {
    GZipResponseInterceptor() {
    }

    public void process(HttpResponse response, HttpContext context) throws HttpException, IOException {
        Header ceheader;
        HttpEntity entity = response.getEntity();
        if (entity != null && (ceheader = entity.getContentEncoding()) != null) {
            HeaderElement[] codecs = ceheader.getElements();
            int i = 0;
            while (i < codecs.length) {
                if (codecs[i].getName().equalsIgnoreCase("gzip")) {
                    response.setEntity((HttpEntity)new GzipDecompressingEntity(response.getEntity()));
                    return;
                }
                ++i;
            }
        }
    }
}

