/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hawk.core.graph.timeaware;

import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.function.Function;
import org.eclipse.hawk.core.graph.IGraphEdge;
import org.eclipse.hawk.core.graph.IGraphNode;
import org.eclipse.hawk.core.graph.timeaware.ITimeAwareGraphNode;
import org.eclipse.hawk.core.graph.timeaware.VersionRangeFilterIGraphEdgeIterable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VersionRangeFilterCreatedIGraphEdgeIterable
implements Iterable<IGraphEdge> {
    private static final Logger LOGGER = LoggerFactory.getLogger(VersionRangeFilterIGraphEdgeIterable.class);
    private final ITimeAwareGraphNode node;
    private final long fromInclusive;
    private final long toInclusive;
    private final Function<IGraphNode, Iterable<IGraphEdge>> node2edges;
    private Function<IGraphEdge, Object> edge2id;

    public VersionRangeFilterCreatedIGraphEdgeIterable(ITimeAwareGraphNode node, long fromInclusive, long toInclusive, Function<IGraphNode, Iterable<IGraphEdge>> node2edges, Function<IGraphEdge, Object> edge2id) {
        this.node = node;
        this.fromInclusive = fromInclusive;
        this.toInclusive = toInclusive;
        this.node2edges = node2edges;
        this.edge2id = edge2id;
    }

    @Override
    public Iterator<IGraphEdge> iterator() {
        try {
            final Iterator<ITimeAwareGraphNode> itVersion = this.node.getVersionsBetween(this.fromInclusive, this.toInclusive).iterator();
            return new Iterator<IGraphEdge>(){
                Set<Object> prevIDs = null;
                Set<Object> currentIDs = new HashSet<Object>();
                Iterator<IGraphEdge> itEdge = null;
                IGraphEdge next = null;

                @Override
                public boolean hasNext() {
                    if (this.prevIDs == null) {
                        this.prevIDs = new HashSet<Object>();
                        ITimeAwareGraphNode beforeFrom = VersionRangeFilterCreatedIGraphEdgeIterable.this.node.travelInTime(VersionRangeFilterCreatedIGraphEdgeIterable.this.fromInclusive - 1L);
                        if (beforeFrom != null) {
                            for (IGraphEdge e : (Iterable)VersionRangeFilterCreatedIGraphEdgeIterable.this.node2edges.apply(beforeFrom)) {
                                this.prevIDs.add(VersionRangeFilterCreatedIGraphEdgeIterable.this.edge2id.apply(e));
                            }
                        }
                    }
                    while (this.next == null && (this.itEdge != null && this.itEdge.hasNext() || itVersion.hasNext())) {
                        if (this.itEdge == null) {
                            ITimeAwareGraphNode version = (ITimeAwareGraphNode)itVersion.next();
                            this.itEdge = ((Iterable)VersionRangeFilterCreatedIGraphEdgeIterable.this.node2edges.apply(version)).iterator();
                        }
                        if (this.itEdge.hasNext()) {
                            IGraphEdge candidate = this.itEdge.next();
                            Object endID = VersionRangeFilterCreatedIGraphEdgeIterable.this.edge2id.apply(candidate);
                            this.currentIDs.add(endID);
                            if (this.prevIDs.contains(endID)) continue;
                            this.next = candidate;
                            continue;
                        }
                        this.prevIDs = this.currentIDs;
                        this.currentIDs = new HashSet<Object>();
                        this.itEdge = null;
                    }
                    return this.next != null;
                }

                @Override
                public IGraphEdge next() {
                    if (!this.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    IGraphEdge ret = this.next;
                    this.next = null;
                    return ret;
                }
            };
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return Collections.emptyIterator();
        }
    }
}

