/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hawk.sqlite;

import java.io.IOException;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import org.eclipse.hawk.core.graph.IGraphEdge;
import org.eclipse.hawk.core.graph.IGraphNode;
import org.eclipse.hawk.sqlite.AbstractSQLiteDatabase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SQLiteEdge
implements IGraphEdge {
    private static final Logger LOGGER = LoggerFactory.getLogger(SQLiteEdge.class);
    protected final AbstractSQLiteDatabase db;
    private final int id;
    private final int from;
    private final int to;
    private final String type;

    public SQLiteEdge(AbstractSQLiteDatabase db, int edgeId, int from, int to, String type) {
        this.db = db;
        this.id = edgeId;
        this.type = type;
        this.from = from;
        this.to = to;
    }

    public Object getId() {
        return this.id;
    }

    public String getType() {
        return this.type;
    }

    public Set<String> getPropertyKeys() {
        try {
            AbstractSQLiteDatabase.SQLiteConnection conn = this.db.getConnection();
            PreparedStatement stmt = conn.getQueries().getEdgePropKeysStatement(this.id);
            stmt.execute();
            return conn.getStrings(stmt);
        }
        catch (SQLException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return Collections.emptySet();
        }
    }

    public Object getProperty(String name) {
        try {
            AbstractSQLiteDatabase.SQLiteConnection conn = this.db.getConnection();
            PreparedStatement stmt = conn.getQueries().getEdgePropValueStatement(this.id, name);
            stmt.execute();
            return conn.getPropertyValue(stmt);
        }
        catch (IOException | ClassNotFoundException | SQLException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public void setProperty(String name, Object value) {
        try {
            AbstractSQLiteDatabase.SQLiteConnection conn = this.db.getConnection();
            value = conn.preprocessPropertyValue(value);
            PreparedStatement stmt = conn.getQueries().getUpsertEdgePropStatement(this.id, name, value);
            int rowCount = stmt.executeUpdate();
            assert (rowCount == 1) : "One row should have been inserted/updated when setting the property";
        }
        catch (IOException | SQLException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
    }

    public IGraphNode getStartNode() {
        return this.db.createNode(this.from);
    }

    public IGraphNode getEndNode() {
        return this.db.createNode(this.to);
    }

    public void delete() {
        try {
            AbstractSQLiteDatabase.SQLiteConnection conn = this.db.getConnection();
            conn.getQueries().getDeleteEdgePropsStatement(this.id).executeUpdate();
            conn.getQueries().getDeleteEdgeStatement(this.id).executeUpdate();
        }
        catch (SQLException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
    }

    public void removeProperty(String name) {
        try {
            PreparedStatement stmt = this.db.getConnection().getQueries().getDeleteEdgePropStatement(this.id, name);
            stmt.executeUpdate();
        }
        catch (SQLException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SQLiteEdge other = (SQLiteEdge)obj;
        return this.id == other.id;
    }

    public String toString() {
        return String.format("SQLiteEdge [id=%s]", this.id);
    }
}

