/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.handly.ui.action;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.handly.internal.ui.Activator;
import org.eclipse.handly.ui.action.Messages;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.jface.resource.DeviceResourceDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.MenuAdapter;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.PlatformUI;

public class HistoryDropDownAction<E>
extends Action {
    private History<E> history;
    private Menu menu;

    public HistoryDropDownAction(History<E> history) {
        if (history == null) {
            throw new IllegalArgumentException();
        }
        this.history = history;
        this.setToolTipText(Messages.HistoryDropDownAction_tooltip);
        this.setImageDescriptor(Activator.getImageDescriptor("org.eclipse.handly.ui/elcl16/history_list.png"));
        this.setDisabledImageDescriptor(Activator.getImageDescriptor("org.eclipse.handly.ui/dlcl16/history_list.png"));
        this.setMenuCreator(new HistoryMenuCreator());
    }

    public void run() {
        new HistoryListAction().run();
    }

    protected void configureHistoryListAction(IAction action) {
    }

    protected String getHistoryListDialogTitle() {
        return Messages.HistoryDropDownAction_History_list_dialog_title;
    }

    protected String getHistoryListDialogMessage() {
        return Messages.HistoryDropDownAction_History_list_dialog_message;
    }

    protected IAction getClearHistoryAction() {
        return new ClearHistoryAction();
    }

    protected void addMenuEntries(IMenuManager manager) {
    }

    protected int getMaxEntriesInDropDown() {
        return 10;
    }

    protected Shell getShell() {
        return PlatformUI.getWorkbench().getDisplay().getActiveShell();
    }

    private class ClearHistoryAction
    extends Action {
        ClearHistoryAction() {
            super(Messages.HistoryDropDownAction_Clear_history_action_text);
        }

        public void run() {
            HistoryDropDownAction.this.history.setHistoryEntries(Collections.emptyList());
        }
    }

    public static abstract class History<E> {
        public abstract List<E> getHistoryEntries();

        public abstract void setHistoryEntries(List<E> var1);

        public abstract E getActiveEntry();

        public abstract void setActiveEntry(E var1);

        public abstract String getLabel(E var1);

        public abstract ImageDescriptor getImageDescriptor(E var1);
    }

    private class HistoryAction
    extends Action {
        final E entry;

        HistoryAction(E entry) {
            super(null, 8);
            if (entry == null) {
                throw new IllegalArgumentException();
            }
            this.entry = entry;
            this.setText(HistoryDropDownAction.this.history.getLabel(entry));
            this.setImageDescriptor(HistoryDropDownAction.this.history.getImageDescriptor(entry));
        }

        public void run() {
            if (this.isChecked()) {
                HistoryDropDownAction.this.history.setActiveEntry(this.entry);
            }
        }
    }

    private class HistoryListAction
    extends Action {
        HistoryListAction() {
            super(Messages.HistoryDropDownAction_History_list_action_text);
        }

        public void run() {
            HistoryListDialog dialog = new HistoryListDialog(HistoryDropDownAction.this.getShell());
            if (dialog.open() == 0) {
                HistoryDropDownAction.this.history.setHistoryEntries(dialog.getRemaining());
                HistoryDropDownAction.this.history.setActiveEntry(dialog.getResult());
            }
        }
    }

    private class HistoryListDialog
    extends StatusDialog {
        private List<E> historyList;
        private E result;
        private TableViewer historyViewer;
        private Button removeButton;

        HistoryListDialog(Shell parentShell) {
            super(parentShell);
            this.historyList = new ArrayList(HistoryDropDownAction.this.history.getHistoryEntries());
            this.setTitle(HistoryDropDownAction.this.getHistoryListDialogTitle());
            this.setHelpAvailable(false);
        }

        List<E> getRemaining() {
            return this.historyList;
        }

        E getResult() {
            return this.result;
        }

        protected boolean isResizable() {
            return true;
        }

        protected Control createDialogArea(Composite parent) {
            Composite composite = (Composite)super.createDialogArea(parent);
            Label label = new Label(composite, 0);
            label.setText(HistoryDropDownAction.this.getHistoryListDialogMessage());
            this.createListArea(composite);
            HistoryListDialog.applyDialogFont((Control)composite);
            return composite;
        }

        private void createListArea(Composite parent) {
            Composite composite = new Composite(parent, 0);
            GridLayout layout = new GridLayout();
            layout.marginWidth = 0;
            layout.marginHeight = 0;
            layout.numColumns = 2;
            composite.setLayout((Layout)layout);
            composite.setLayoutData((Object)new GridData(1808));
            this.createTableArea(composite);
            this.createListButtons(composite);
            this.setTableSelection();
        }

        private void createTableArea(Composite parent) {
            Table table = new Table(parent, 2818);
            GridData gd = new GridData(1808);
            gd.widthHint = this.convertWidthInCharsToPixels(50);
            gd.heightHint = this.convertHeightInCharsToPixels(12);
            gd.grabExcessHorizontalSpace = true;
            gd.grabExcessVerticalSpace = true;
            table.setLayoutData((Object)gd);
            table.addSelectionListener(SelectionListener.widgetDefaultSelectedAdapter(e -> {
                if (this.getStatus().isOK()) {
                    this.okPressed();
                }
            }));
            this.historyViewer = new TableViewer(table);
            this.historyViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){
                final ResourceManager resourceManager;
                {
                    this.resourceManager = new LocalResourceManager(JFaceResources.getResources((Display)HistoryListDialog.this.historyViewer.getControl().getDisplay()));
                }

                public void dispose() {
                    this.resourceManager.dispose();
                    super.dispose();
                }

                public String getText(Object element) {
                    return ((HistoryListDialog)HistoryListDialog.this).HistoryDropDownAction.this.history.getLabel(element);
                }

                public Image getImage(Object element) {
                    ImageDescriptor descriptor = ((HistoryListDialog)HistoryListDialog.this).HistoryDropDownAction.this.history.getImageDescriptor(element);
                    if (descriptor == null) {
                        return null;
                    }
                    return (Image)this.resourceManager.get((DeviceResourceDescriptor)descriptor);
                }
            });
            this.historyViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
            this.historyViewer.setInput(this.historyList);
            this.historyViewer.addSelectionChangedListener(e -> {
                IStatus status;
                IStructuredSelection selection = this.historyViewer.getStructuredSelection();
                int selectionSize = selection.size();
                if (selectionSize == 1) {
                    status = Status.OK_STATUS;
                    Object element = selection.getFirstElement();
                    this.result = element;
                } else {
                    status = new Status(4, "org.eclipse.handly.ui", "");
                    this.result = null;
                }
                this.removeButton.setEnabled(this.historyList.size() > selectionSize && selectionSize > 0);
                this.updateStatus(status);
            });
        }

        private void createListButtons(Composite parent) {
            this.removeButton = new Button(parent, 8);
            this.removeButton.setText(Messages.HistoryDropDownAction_History_list_dialog_remove_button_text);
            GridData gd = new GridData(0x1000000, 128, false, false);
            int widthHint = this.convertHorizontalDLUsToPixels(61);
            Point minSize = this.removeButton.computeSize(-1, -1, true);
            gd.widthHint = Math.max(widthHint, minSize.x);
            this.removeButton.setLayoutData((Object)gd);
            this.removeButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
                IStructuredSelection selection = this.historyViewer.getStructuredSelection();
                this.historyList.removeAll(selection.toList());
                this.historyViewer.remove(selection.toArray());
            }));
        }

        private void setTableSelection() {
            Object activeEntry = HistoryDropDownAction.this.history.getActiveEntry();
            StructuredSelection sel = activeEntry == null ? StructuredSelection.EMPTY : new StructuredSelection(activeEntry);
            this.historyViewer.setSelection((ISelection)sel, true);
        }
    }

    private class HistoryMenuCreator
    implements IMenuCreator {
        private HistoryMenuCreator() {
        }

        public Menu getMenu(Menu parent) {
            return null;
        }

        public Menu getMenu(Control parent) {
            if (HistoryDropDownAction.this.menu != null) {
                HistoryDropDownAction.this.menu.dispose();
            }
            final MenuManager manager = new MenuManager();
            manager.setRemoveAllWhenShown(true);
            manager.addMenuListener(new IMenuListener(){

                public void menuAboutToShow(IMenuManager manager) {
                    if (((HistoryMenuCreator)HistoryMenuCreator.this).HistoryDropDownAction.this.history == null) {
                        return;
                    }
                    this.addEntryMenuItems(manager, ((HistoryMenuCreator)HistoryMenuCreator.this).HistoryDropDownAction.this.history.getHistoryEntries());
                    manager.add((IContributionItem)new Separator());
                    HistoryListAction historyListAction = new HistoryListAction();
                    HistoryDropDownAction.this.configureHistoryListAction((IAction)historyListAction);
                    manager.add((IAction)historyListAction);
                    IAction clearHistoryAction = HistoryDropDownAction.this.getClearHistoryAction();
                    if (clearHistoryAction != null) {
                        manager.add(clearHistoryAction);
                    }
                    manager.add((IContributionItem)new Separator("additions"));
                    HistoryDropDownAction.this.addMenuEntries(manager);
                }

                private void addEntryMenuItems(IMenuManager manager, List<E> entries) {
                    Object active = ((HistoryMenuCreator)HistoryMenuCreator.this).HistoryDropDownAction.this.history.getActiveEntry();
                    int size = Math.min(entries.size(), HistoryDropDownAction.this.getMaxEntriesInDropDown());
                    int i = 0;
                    while (i < size) {
                        Object entry = entries.get(i);
                        HistoryAction action = new HistoryAction(entry);
                        action.setChecked(entry.equals(active));
                        manager.add((IAction)action);
                        ++i;
                    }
                }
            });
            HistoryDropDownAction.this.menu = manager.createContextMenu(parent);
            final Display display = parent.getDisplay();
            HistoryDropDownAction.this.menu.addMenuListener((MenuListener)new MenuAdapter(){

                public void menuHidden(MenuEvent e) {
                    display.asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            manager.removeAll();
                            if (((HistoryMenuCreator)(this).HistoryMenuCreator.this).HistoryDropDownAction.this.menu != null) {
                                ((HistoryMenuCreator)(this).HistoryMenuCreator.this).HistoryDropDownAction.this.menu.dispose();
                                ((HistoryMenuCreator)(this).HistoryMenuCreator.this).HistoryDropDownAction.this.menu = null;
                            }
                        }
                    });
                }
            });
            return HistoryDropDownAction.this.menu;
        }

        public void dispose() {
            HistoryDropDownAction.this.history = null;
            if (HistoryDropDownAction.this.menu != null) {
                HistoryDropDownAction.this.menu.dispose();
                HistoryDropDownAction.this.menu = null;
            }
        }
    }
}

