/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.handly.ui.search;

import java.util.ArrayList;
import java.util.function.Consumer;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.handly.model.ElementDeltas;
import org.eclipse.handly.model.Elements;
import org.eclipse.handly.model.IElement;
import org.eclipse.handly.model.IElementChangeEvent;
import org.eclipse.handly.model.IElementChangeListener;
import org.eclipse.handly.model.IElementDelta;
import org.eclipse.handly.ui.search.AbstractHandlySearchResult;

public class HandlySearchResultUpdater
implements IElementChangeListener {
    private final ListenerList<AbstractHandlySearchResult> searchResults = new ListenerList(1);

    public void add(AbstractHandlySearchResult searchResult) {
        this.searchResults.add((Object)searchResult);
    }

    public void remove(AbstractHandlySearchResult searchResult) {
        this.searchResults.remove((Object)searchResult);
    }

    public void elementChanged(IElementChangeEvent event) {
        IElementDelta[] deltas;
        ArrayList<AbstractHandlySearchResult.ContainmentContext> removals = new ArrayList<AbstractHandlySearchResult.ContainmentContext>();
        IElementDelta[] iElementDeltaArray = deltas = event.getDeltas();
        int n = deltas.length;
        int n2 = 0;
        while (n2 < n) {
            IElementDelta delta = iElementDeltaArray[n2];
            this.collectRemovals(delta, AbstractHandlySearchResult.into(removals));
            ++n2;
        }
        if (!removals.isEmpty()) {
            this.processRemovals(removals);
        }
    }

    protected boolean isPotentialRemoval(IElementDelta delta) {
        long flags = ElementDeltas.getFlags((IElementDelta)delta);
        return (flags & 0x49L) != 0L;
    }

    protected final Iterable<AbstractHandlySearchResult> getSearchResults() {
        return this.searchResults;
    }

    private void collectRemovals(IElementDelta delta, Consumer<AbstractHandlySearchResult.ContainmentContext> acceptor) {
        int n;
        int n2;
        IResourceDelta[] iResourceDeltaArray;
        IElement element = ElementDeltas.getElement((IElementDelta)delta);
        int kind = ElementDeltas.getKind((IElementDelta)delta);
        if (kind == 2) {
            acceptor.accept(new AbstractHandlySearchResult.ContainmentContext(element, Elements.getResource((IElement)element)));
        } else if (kind == 4) {
            if (this.isPotentialRemoval(delta)) {
                acceptor.accept(new AbstractHandlySearchResult.ContainmentContext(element, Elements.getResource((IElement)element)));
            } else {
                IElementDelta[] childDeltas = ElementDeltas.getAffectedChildren((IElementDelta)delta);
                iResourceDeltaArray = childDeltas;
                n2 = childDeltas.length;
                n = 0;
                while (n < n2) {
                    IResourceDelta childDelta = iResourceDeltaArray[n];
                    this.collectRemovals((IElementDelta)childDelta, acceptor);
                    ++n;
                }
            }
        }
        IResourceDelta[] resourceDeltas = ElementDeltas.getResourceDeltas((IElementDelta)delta);
        if (resourceDeltas != null) {
            iResourceDeltaArray = resourceDeltas;
            n2 = resourceDeltas.length;
            n = 0;
            while (n < n2) {
                IResourceDelta resourceDelta = iResourceDeltaArray[n];
                this.collectRemovals(resourceDelta, acceptor);
                ++n;
            }
        }
    }

    private void collectRemovals(IResourceDelta delta, Consumer<AbstractHandlySearchResult.ContainmentContext> acceptor) {
        if (delta.getKind() == 2) {
            acceptor.accept(new AbstractHandlySearchResult.ContainmentContext(null, delta.getResource()));
        } else if (delta.getKind() == 4) {
            IResourceDelta[] childDeltas;
            IResourceDelta[] iResourceDeltaArray = childDeltas = delta.getAffectedChildren();
            int n = childDeltas.length;
            int n2 = 0;
            while (n2 < n) {
                IResourceDelta childDelta = iResourceDeltaArray[n2];
                this.collectRemovals(childDelta, acceptor);
                ++n2;
            }
        }
    }

    private void processRemovals(Iterable<AbstractHandlySearchResult.ContainmentContext> removals) {
        for (AbstractHandlySearchResult searchResult : this.searchResults) {
            Object[] elements;
            AbstractHandlySearchResult.ContainmentAdapter containmentAdapter = new AbstractHandlySearchResult.ContainmentAdapter(searchResult.getContentAdapter());
            Object[] objectArray = elements = searchResult.getElements();
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                Object element = objectArray[n2];
                if (containmentAdapter.isContainedInAnyOf(element, removals) && !containmentAdapter.exists(element)) {
                    searchResult.removeMatches(searchResult.getMatches(element));
                }
                ++n2;
            }
        }
    }
}

