/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.handly.refactoring;

import java.text.MessageFormat;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.handly.buffer.IBuffer;
import org.eclipse.handly.buffer.IBufferChange;
import org.eclipse.handly.context.Contexts;
import org.eclipse.handly.internal.Activator;
import org.eclipse.handly.model.Elements;
import org.eclipse.handly.model.ISourceFile;
import org.eclipse.handly.refactoring.Messages;
import org.eclipse.handly.snapshot.StaleSnapshotException;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;

class UndoSourceFileChange
extends Change {
    private final String name;
    private final ISourceFile sourceFile;
    private final IBufferChange undoChange;
    private boolean existed;

    public UndoSourceFileChange(String name, ISourceFile sourceFile, IBufferChange undoChange) {
        this.name = name;
        if (this.name == null) {
            throw new IllegalArgumentException();
        }
        this.sourceFile = sourceFile;
        if (this.sourceFile == null) {
            throw new IllegalArgumentException();
        }
        this.undoChange = undoChange;
        if (this.undoChange == null) {
            throw new IllegalArgumentException();
        }
    }

    public String getName() {
        return this.name;
    }

    public void initializeValidationData(IProgressMonitor pm) {
        this.existed = Elements.exists(this.sourceFile);
    }

    public RefactoringStatus isValid(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        RefactoringStatus result = new RefactoringStatus();
        if (!this.existed) {
            if (Elements.exists(this.sourceFile)) {
                result.addFatalError(MessageFormat.format(Messages.UndoSourceFileChange_Should_not_exist__0, Elements.toDisplayString(this.sourceFile, Contexts.EMPTY_CONTEXT)));
            }
            return result;
        }
        if (!Elements.exists(this.sourceFile)) {
            result.addFatalError(MessageFormat.format(Messages.UndoSourceFileChange_Should_exist__0, Elements.toDisplayString(this.sourceFile, Contexts.EMPTY_CONTEXT)));
            return result;
        }
        if (this.undoChange.getBase() == null) {
            return result;
        }
        Throwable throwable = null;
        Object var4_5 = null;
        try (IBuffer buffer = Elements.getBuffer(this.sourceFile, Contexts.EMPTY_CONTEXT, pm);){
            if (!this.undoChange.getBase().isEqualTo(buffer.getSnapshot())) {
                result.addFatalError(MessageFormat.format(Messages.UndoSourceFileChange_Cannot_undo_stale_change__0, Elements.toDisplayString(this.sourceFile, Contexts.EMPTY_CONTEXT)));
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return result;
    }

    public Change perform(IProgressMonitor pm) throws CoreException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)pm, (int)2);
        Throwable throwable = null;
        Object var4_5 = null;
        try (IBuffer buffer = Elements.getBuffer(this.sourceFile, Contexts.EMPTY_CONTEXT, (IProgressMonitor)subMonitor.split(1));){
            IBufferChange redoChange;
            try {
                redoChange = buffer.applyChange(this.undoChange, (IProgressMonitor)subMonitor.split(1, 10));
            }
            catch (StaleSnapshotException e) {
                throw new CoreException(Activator.createErrorStatus(MessageFormat.format(Messages.UndoSourceFileChange_Cannot_undo_stale_change__0, Elements.toDisplayString(this.sourceFile, Contexts.EMPTY_CONTEXT)), e));
            }
            return new UndoSourceFileChange(this.getName(), this.sourceFile, redoChange);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public Object getModifiedElement() {
        return this.sourceFile;
    }

    public Object[] getAffectedObjects() {
        IFile file = Elements.getFile(this.sourceFile);
        if (file == null) {
            return null;
        }
        return new Object[]{file};
    }
}

