/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.handly.model.impl;

import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.handly.context.IContext;
import org.eclipse.handly.model.ElementDeltas;
import org.eclipse.handly.model.Elements;
import org.eclipse.handly.model.IElement;
import org.eclipse.handly.model.IElementDelta;

public interface IElementDeltaImpl
extends IElementDelta {
    public IElement getElement_();

    default public boolean isEmpty_() {
        return this.getKind_() == 0;
    }

    public int getKind_();

    public long getFlags_();

    default public IElementDelta findDelta_(IElement element) {
        if (element == null) {
            return null;
        }
        if (Elements.equalsAndSameParentChain(this.getElement_(), element)) {
            return this;
        }
        if (!Elements.isAncestorOf(this.getElement_(), Elements.getParent(element))) {
            return null;
        }
        IElementDelta[] iElementDeltaArray = this.getAffectedChildren_();
        int n = iElementDeltaArray.length;
        int n2 = 0;
        while (n2 < n) {
            IElementDelta child = iElementDeltaArray[n2];
            IElementDelta delta = ElementDeltas.findDelta(child, element);
            if (delta != null) {
                return delta;
            }
            ++n2;
        }
        return null;
    }

    public IElementDelta[] getAffectedChildren_();

    public IElementDelta[] getAddedChildren_();

    public IElementDelta[] getRemovedChildren_();

    public IElementDelta[] getChangedChildren_();

    public IElement getMovedFromElement_();

    public IElement getMovedToElement_();

    public IMarkerDelta[] getMarkerDeltas_();

    public IResourceDelta[] getResourceDeltas_();

    public String toString_(IContext var1);
}

