/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.handly.model.impl.support;

import junit.framework.TestCase;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.handly.context.IContext;
import org.eclipse.handly.model.ElementDeltas;
import org.eclipse.handly.model.IElement;
import org.eclipse.handly.model.IElementDelta;
import org.eclipse.handly.model.impl.support.ElementChangeRecorder;
import org.eclipse.handly.model.impl.support.IElementImplSupport;
import org.eclipse.handly.model.impl.support.SimpleModelManager;
import org.eclipse.handly.model.impl.support.SimpleSourceConstruct;
import org.eclipse.handly.model.impl.support.SimpleSourceFile;
import org.eclipse.handly.model.impl.support.SourceElementBody;
import org.eclipse.handly.snapshot.DocumentSnapshot;
import org.eclipse.handly.snapshot.ISnapshot;
import org.eclipse.handly.util.Property;
import org.eclipse.handly.util.TextRange;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;

public class ElementChangeRecorderTest
extends TestCase {
    private SimpleSourceFile root;
    private SimpleSourceConstruct a;
    private SimpleSourceConstruct b;
    private SimpleSourceConstruct c;
    private SourceElementBody rootBody;
    private SourceElementBody aBody;
    private SourceElementBody bBody;
    private SourceElementBody cBody;
    private ElementChangeRecorder recorder;

    protected void setUp() throws Exception {
        super.setUp();
        this.root = new SimpleSourceFile(null, "root", null, new SimpleModelManager()){

            public Object findBody_() {
                return ElementChangeRecorderTest.this.rootBody;
            }

            public Object open_(IContext context, IProgressMonitor monitor) throws CoreException {
                throw this.newDoesNotExistException_();
            }
        };
        this.a = new SimpleSourceConstruct((IElementImplSupport)this.root, "A"){

            public Object findBody_() {
                return ElementChangeRecorderTest.this.aBody;
            }
        };
        this.b = new SimpleSourceConstruct((IElementImplSupport)this.root, "B"){

            public Object findBody_() {
                return ElementChangeRecorderTest.this.bBody;
            }
        };
        this.c = new SimpleSourceConstruct((IElementImplSupport)this.b, "C"){

            public Object findBody_() {
                return ElementChangeRecorderTest.this.cBody;
            }
        };
        this.rootBody = new SourceElementBody();
        this.aBody = new SourceElementBody();
        this.bBody = new SourceElementBody();
        this.cBody = new SourceElementBody();
        this.recorder = new ElementChangeRecorder();
    }

    public void test01() {
        ElementChangeRecorderTest.assertFalse((boolean)this.recorder.isRecording());
        try {
            this.recorder.endRecording();
            ElementChangeRecorderTest.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        this.recorder.beginRecording((IElement)this.root);
        ElementChangeRecorderTest.assertTrue((boolean)this.recorder.isRecording());
        ElementChangeRecorderTest.assertTrue((boolean)ElementDeltas.isNullOrEmpty((IElementDelta)this.recorder.endRecording().getDelta()));
        ElementChangeRecorderTest.assertFalse((boolean)this.recorder.isRecording());
    }

    public void test02() {
        this.rootBody = null;
        this.recorder.beginRecording((IElement)this.root, null, 0);
        this.rootBody = new SourceElementBody();
        ElementChangeRecorderTest.assertEquals((String)"root[+]: {}", (String)this.recorder.endRecording().getDelta().toString());
    }

    public void test03() {
        this.recorder.beginRecording((IElement)this.root, null, 0);
        this.rootBody = null;
        ElementChangeRecorderTest.assertEquals((String)"root[-]: {}", (String)this.recorder.endRecording().getDelta().toString());
    }

    public void test04() {
        this.recorder.beginRecording((IElement)this.root);
        this.rootBody.addChild((IElement)this.a);
        ElementChangeRecorderTest.assertEquals((String)"root[*]: {CHILDREN | FINE GRAINED}\n  A[+]: {}", (String)this.recorder.endRecording().getDelta().toString());
    }

    public void test05() {
        this.rootBody.addChild((IElement)this.b);
        this.recorder.beginRecording((IElement)this.root);
        this.rootBody.addChild((IElement)this.a);
        ElementChangeRecorderTest.assertEquals((String)"root[*]: {CHILDREN | FINE GRAINED}\n  A[+]: {}", (String)this.recorder.endRecording().getDelta().toString());
    }

    public void test06() {
        this.rootBody.addChild((IElement)this.b);
        this.recorder.beginRecording((IElement)this.root);
        this.rootBody.setChildren((IElement[])new SimpleSourceConstruct[]{this.a, this.b});
        ElementChangeRecorderTest.assertEquals((String)"root[*]: {CHILDREN | FINE GRAINED}\n  A[+]: {}", (String)this.recorder.endRecording().getDelta().toString());
    }

    public void test07() {
        this.rootBody.addChild((IElement)this.a);
        this.recorder.beginRecording((IElement)this.root);
        this.rootBody.removeChild((IElement)this.a);
        ElementChangeRecorderTest.assertEquals((String)"root[*]: {CHILDREN | FINE GRAINED}\n  A[-]: {}", (String)this.recorder.endRecording().getDelta().toString());
    }

    public void test08() {
        this.rootBody.setChildren((IElement[])new SimpleSourceConstruct[]{this.a, this.b});
        this.recorder.beginRecording((IElement)this.root);
        this.rootBody.removeChild((IElement)this.a);
        ElementChangeRecorderTest.assertEquals((String)"root[*]: {CHILDREN | FINE GRAINED}\n  A[-]: {}", (String)this.recorder.endRecording().getDelta().toString());
    }

    public void test09() {
        this.rootBody.setChildren((IElement[])new SimpleSourceConstruct[]{this.b, this.a});
        this.recorder.beginRecording((IElement)this.root);
        this.rootBody.removeChild((IElement)this.a);
        ElementChangeRecorderTest.assertEquals((String)"root[*]: {CHILDREN | FINE GRAINED}\n  A[-]: {}", (String)this.recorder.endRecording().getDelta().toString());
    }

    public void test10() {
        this.rootBody.setChildren((IElement[])new SimpleSourceConstruct[]{this.a, this.b});
        this.recorder.beginRecording((IElement)this.root);
        this.rootBody.setChildren((IElement[])new SimpleSourceConstruct[]{this.b, this.a});
        ElementChangeRecorderTest.assertEquals((String)"root[*]: {CHILDREN | FINE GRAINED}\n  B[*]: {REORDERED | FINE GRAINED}\n  A[*]: {REORDERED | FINE GRAINED}", (String)this.recorder.endRecording().getDelta().toString());
    }

    public void test11() {
        this.rootBody.setFullRange(new TextRange(0, 0));
        this.recorder.beginRecording((IElement)this.root);
        this.rootBody = new SourceElementBody();
        this.rootBody.setFullRange(new TextRange(0, 1));
        ElementChangeRecorderTest.assertEquals((String)"root[*]: {CONTENT | FINE GRAINED}", (String)this.recorder.endRecording().getDelta().toString());
    }

    public void test12() {
        this.rootBody.setFullRange(new TextRange(0, 1));
        this.recorder.beginRecording((IElement)this.root);
        this.rootBody = new SourceElementBody();
        this.rootBody.setFullRange(new TextRange(0, 1));
        ElementChangeRecorderTest.assertTrue((boolean)ElementDeltas.isNullOrEmpty((IElementDelta)this.recorder.endRecording().getDelta()));
    }

    public void test13() {
        this.rootBody.setFullRange(new TextRange(0, 1));
        Document document = new Document("a");
        this.rootBody.setSnapshot((ISnapshot)new DocumentSnapshot((IDocument)document));
        this.recorder.beginRecording((IElement)this.root);
        document.set("b");
        this.rootBody = new SourceElementBody();
        this.rootBody.setFullRange(new TextRange(0, 1));
        this.rootBody.setSnapshot((ISnapshot)new DocumentSnapshot((IDocument)document));
        ElementChangeRecorderTest.assertEquals((String)"root[*]: {CONTENT | FINE GRAINED}", (String)this.recorder.endRecording().getDelta().toString());
    }

    public void test14() {
        this.rootBody.setFullRange(new TextRange(0, 1));
        Document document = new Document("a");
        this.rootBody.setSnapshot((ISnapshot)new DocumentSnapshot((IDocument)document));
        this.recorder.beginRecording((IElement)this.root);
        this.rootBody = new SourceElementBody();
        this.rootBody.setFullRange(new TextRange(0, 1));
        this.rootBody.setSnapshot((ISnapshot)new DocumentSnapshot((IDocument)document));
        ElementChangeRecorderTest.assertTrue((boolean)ElementDeltas.isNullOrEmpty((IElementDelta)this.recorder.endRecording().getDelta()));
    }

    public void test15() {
        this.recorder.beginRecording((IElement)this.root);
        this.rootBody = new SourceElementBody();
        this.rootBody.set(Property.get((String)"p", String.class), (Object)"a");
        ElementChangeRecorderTest.assertEquals((String)"root[*]: {CONTENT | FINE GRAINED}", (String)this.recorder.endRecording().getDelta().toString());
    }

    public void test16() {
        this.rootBody.set(Property.get((String)"p", String.class), (Object)"a");
        this.recorder.beginRecording((IElement)this.root);
        this.rootBody = new SourceElementBody();
        ElementChangeRecorderTest.assertEquals((String)"root[*]: {CONTENT | FINE GRAINED}", (String)this.recorder.endRecording().getDelta().toString());
    }

    public void test17() {
        Property p = Property.get((String)"p", String.class);
        this.rootBody.set(p, (Object)"a");
        this.recorder.beginRecording((IElement)this.root);
        this.rootBody = new SourceElementBody();
        this.rootBody.set(p, (Object)"b");
        ElementChangeRecorderTest.assertEquals((String)"root[*]: {CONTENT | FINE GRAINED}", (String)this.recorder.endRecording().getDelta().toString());
    }

    public void test18() {
        Property p = Property.get((String)"p", String[].class);
        this.rootBody.set(p, (Object)new String[]{"a"});
        this.recorder.beginRecording((IElement)this.root);
        this.rootBody = new SourceElementBody();
        this.rootBody.set(p, (Object)new String[]{"a", "b"});
        ElementChangeRecorderTest.assertEquals((String)"root[*]: {CONTENT | FINE GRAINED}", (String)this.recorder.endRecording().getDelta().toString());
    }

    public void test19() {
        this.rootBody.set(Property.get((String)"p1", String.class), (Object)"a");
        this.recorder.beginRecording((IElement)this.root);
        this.rootBody = new SourceElementBody();
        this.rootBody.set(Property.get((String)"p2", String.class), (Object)"a");
        ElementChangeRecorderTest.assertEquals((String)"root[*]: {CONTENT | FINE GRAINED}", (String)this.recorder.endRecording().getDelta().toString());
    }

    public void test20() {
        Property p = Property.get((String)"p", String.class);
        this.rootBody.set(p, (Object)"a");
        this.recorder.beginRecording((IElement)this.root);
        this.rootBody = new SourceElementBody();
        this.rootBody.set(p, (Object)"a");
        ElementChangeRecorderTest.assertTrue((boolean)ElementDeltas.isNullOrEmpty((IElementDelta)this.recorder.endRecording().getDelta()));
    }

    public void test21() {
        this.recorder.beginRecording((IElement)this.root, null, 0);
        ElementChangeRecorderTest.assertEquals((String)"root[*]: {CONTENT}", (String)this.recorder.endRecording().getDelta().toString());
    }

    public void test22() {
        this.rootBody = null;
        this.recorder.beginRecording((IElement)this.root, null, 0);
        this.rootBody = new SourceElementBody();
        ElementChangeRecorderTest.assertEquals((String)"root[+]: {}", (String)this.recorder.endRecording().getDelta().toString());
    }

    public void test23() {
        this.recorder.beginRecording((IElement)this.root, null, 0);
        this.rootBody = null;
        ElementChangeRecorderTest.assertEquals((String)"root[-]: {}", (String)this.recorder.endRecording().getDelta().toString());
    }

    public void test24() {
        this.rootBody.addChild((IElement)this.a);
        this.recorder.beginRecording((IElement)this.root, null, 0);
        this.rootBody.addChild((IElement)this.b);
        ElementChangeRecorderTest.assertEquals((String)"root[*]: {CONTENT}", (String)this.recorder.endRecording().getDelta().toString());
    }

    public void test25() {
        this.rootBody.setChildren((IElement[])new SimpleSourceConstruct[]{this.a, this.b});
        this.recorder.beginRecording((IElement)this.root, null, 0);
        this.rootBody.setChildren((IElement[])new SimpleSourceConstruct[]{this.b, this.a});
        ElementChangeRecorderTest.assertEquals((String)"root[*]: {CONTENT}", (String)this.recorder.endRecording().getDelta().toString());
    }

    public void test26() {
        this.recorder.beginRecording((IElement)this.root, null, 0);
        this.rootBody = new SourceElementBody();
        this.rootBody.set(Property.get((String)"p", String.class), (Object)"a");
        ElementChangeRecorderTest.assertEquals((String)"root[*]: {CONTENT}", (String)this.recorder.endRecording().getDelta().toString());
    }

    public void test27() {
        this.recorder.beginRecording((IElement)this.root, null, 1);
        ElementChangeRecorderTest.assertTrue((boolean)ElementDeltas.isNullOrEmpty((IElementDelta)this.recorder.endRecording().getDelta()));
    }

    public void test28() {
        this.rootBody.addChild((IElement)this.a);
        this.recorder.beginRecording((IElement)this.root, null, 1);
        this.rootBody.addChild((IElement)this.b);
        ElementChangeRecorderTest.assertEquals((String)"root[*]: {CHILDREN | FINE GRAINED}\n  A[*]: {CONTENT}\n  B[+]: {}", (String)this.recorder.endRecording().getDelta().toString());
    }

    public void test29() {
        this.rootBody.addChild((IElement)this.a);
        this.rootBody.addChild((IElement)this.b);
        this.recorder.beginRecording((IElement)this.root, null, 1);
        this.rootBody.removeChild((IElement)this.b);
        ElementChangeRecorderTest.assertEquals((String)"root[*]: {CHILDREN | FINE GRAINED}\n  A[*]: {CONTENT}\n  B[-]: {}", (String)this.recorder.endRecording().getDelta().toString());
    }

    public void test30() {
        this.recorder.beginRecording((IElement)this.root, null, 1);
        this.rootBody = new SourceElementBody();
        this.rootBody.set(Property.get((String)"p", String.class), (Object)"a");
        ElementChangeRecorderTest.assertEquals((String)"root[*]: {CONTENT | FINE GRAINED}", (String)this.recorder.endRecording().getDelta().toString());
    }

    public void test31() {
        this.rootBody.addChild((IElement)this.a);
        this.recorder.beginRecording((IElement)this.root, null, 1);
        this.aBody = new SourceElementBody();
        this.aBody.set(Property.get((String)"p", String.class), (Object)"a");
        ElementChangeRecorderTest.assertEquals((String)"root[*]: {CHILDREN | FINE GRAINED}\n  A[*]: {CONTENT}", (String)this.recorder.endRecording().getDelta().toString());
    }

    public void test32() {
        this.rootBody.addChild((IElement)this.a);
        this.rootBody.addChild((IElement)this.b);
        this.recorder.beginRecording((IElement)this.root, null, 1);
        this.bBody.addChild((IElement)this.c);
        ElementChangeRecorderTest.assertEquals((String)"root[*]: {CHILDREN | FINE GRAINED}\n  A[*]: {CONTENT}\n  B[*]: {CONTENT}", (String)this.recorder.endRecording().getDelta().toString());
    }

    public void test33() {
        this.rootBody.addChild((IElement)this.a);
        this.rootBody.addChild((IElement)this.b);
        this.recorder.beginRecording((IElement)this.root, null, 2);
        this.bBody.addChild((IElement)this.c);
        ElementChangeRecorderTest.assertEquals((String)"root[*]: {CHILDREN | FINE GRAINED}\n  B[*]: {CHILDREN | FINE GRAINED}\n    C[+]: {}", (String)this.recorder.endRecording().getDelta().toString());
    }

    public void test34() {
        this.rootBody.setChildren((IElement[])new SimpleSourceConstruct[]{this.a, this.b});
        this.recorder.beginRecording((IElement)this.root, null, 1);
        this.rootBody.setChildren((IElement[])new SimpleSourceConstruct[]{this.b, this.a});
        this.aBody = new SourceElementBody();
        this.aBody.set(Property.get((String)"p", String.class), (Object)"a");
        ElementChangeRecorderTest.assertEquals((String)"root[*]: {CHILDREN | FINE GRAINED}\n  B[*]: {CONTENT | REORDERED}\n  A[*]: {CONTENT | REORDERED}", (String)this.recorder.endRecording().getDelta().toString());
    }

    public void test35() {
        this.rootBody.setChildren((IElement[])new SimpleSourceConstruct[]{this.a, this.b});
        this.recorder.beginRecording((IElement)this.root, null, 2);
        this.rootBody.setChildren((IElement[])new SimpleSourceConstruct[]{this.b, this.a});
        this.aBody = new SourceElementBody();
        this.aBody.set(Property.get((String)"p", String.class), (Object)"a");
        ElementChangeRecorderTest.assertEquals((String)"root[*]: {CHILDREN | FINE GRAINED}\n  A[*]: {CONTENT | REORDERED | FINE GRAINED}\n  B[*]: {REORDERED | FINE GRAINED}", (String)this.recorder.endRecording().getDelta().toString());
    }
}

