/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.glsp.graph.gson;

import com.google.gson.Gson;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class EnumTypeAdapter<T extends Enum<T>>
extends TypeAdapter<T> {
    protected static String VALUE_FIELD_NAME = "value";
    protected final Map<String, T> nameToConstant;
    protected final Map<Integer, T> valueToConstant;
    protected final Map<T, Integer> constantToValue;

    /*
     * Unable to fully structure code
     */
    EnumTypeAdapter(Class<T> classOfT) throws IllegalAccessException {
        block5: {
            super();
            this.nameToConstant = new HashMap<String, T>();
            this.valueToConstant = new HashMap<Integer, T>();
            this.constantToValue = new HashMap<T, Integer>();
            try {
                valueField = classOfT.getDeclaredField(EnumTypeAdapter.VALUE_FIELD_NAME);
                if (valueField.getType() != Integer.TYPE && valueField.getType() != Integer.class) {
                    throw new IllegalArgumentException("The field 'value' must contain an integer value.");
                }
                valueField.setAccessible(true);
                var6_4 = (Enum[])classOfT.getEnumConstants();
                var5_6 = var6_4.length;
                var4_8 = 0;
                while (var4_8 < var5_6) {
                    constant = var6_4[var4_8];
                    this.nameToConstant.put(constant.name(), constant);
                    constValue = (Integer)valueField.get(constant);
                    this.valueToConstant.put(constValue, constant);
                    this.constantToValue.put(constant, constValue);
                    ++var4_8;
                }
                break block5;
            }
            catch (NoSuchFieldException e) {
                var6_5 = (Enum[])classOfT.getEnumConstants();
                var5_7 = var6_5.length;
                var4_9 = 0;
                ** while (var4_9 < var5_7)
            }
lbl-1000:
            // 1 sources

            {
                constant = var6_5[var4_9];
                this.nameToConstant.put(constant.name(), constant);
                constValue = constant.ordinal();
                this.valueToConstant.put(constValue, constant);
                this.constantToValue.put(constant, constValue);
                ++var4_9;
                continue;
            }
        }
    }

    public T read(JsonReader in) throws IOException {
        JsonToken peek = in.peek();
        if (peek == JsonToken.NULL) {
            in.nextNull();
            return null;
        }
        if (peek == JsonToken.NUMBER) {
            return (T)((Enum)this.valueToConstant.get(in.nextInt()));
        }
        String string = in.nextString();
        try {
            return (T)((Enum)this.valueToConstant.get(Integer.parseInt(string)));
        }
        catch (NumberFormatException e) {
            return (T)((Enum)this.nameToConstant.get(string));
        }
    }

    public void write(JsonWriter out, T value) throws IOException {
        if (value != null) {
            out.value((Number)this.constantToValue.get(value));
        } else {
            out.value(null);
        }
    }

    public static class Factory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> typeToken) {
            Class rawType = typeToken.getRawType();
            if (!Enum.class.isAssignableFrom(rawType) || rawType == Enum.class) {
                return null;
            }
            if (!rawType.isEnum()) {
                rawType = rawType.getSuperclass();
            }
            try {
                return new EnumTypeAdapter(rawType);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

