/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.glsp.ide.editor.utils;

import java.util.Arrays;
import java.util.Optional;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.widgets.Control;

public final class SWTUtil {
    private SWTUtil() {
    }

    public static boolean hasStyle(Control control, int style) {
        return control != null && (control.getStyle() & style) != 0;
    }

    public static boolean hasAnyStyle(Control control, int ... styles) {
        return Arrays.stream(styles).anyMatch(style -> SWTUtil.hasStyle(control, style));
    }

    public static boolean hasAllStyles(Control control, int ... styles) {
        return Arrays.stream(styles).allMatch(style -> SWTUtil.hasStyle(control, style));
    }

    public static <C extends Control> Optional<C> ifHasStyle(C control, int style) {
        return SWTUtil.hasStyle(control, style) ? Optional.of(control) : Optional.empty();
    }

    public static <C extends Control> Optional<C> ifHasAnyStyle(C control, int ... styles) {
        return SWTUtil.hasAnyStyle(control, styles) ? Optional.of(control) : Optional.empty();
    }

    public static <C extends Control> Optional<C> ifHasAllStyles(C control, int ... styles) {
        return SWTUtil.hasAllStyles(control, styles) ? Optional.of(control) : Optional.empty();
    }

    public static boolean isChromium(Browser browser) {
        return SWTUtil.hasStyle((Control)browser, 131072);
    }

    public static boolean isEdge(Browser browser) {
        return SWTUtil.hasStyle((Control)browser, 262144);
    }

    public static boolean isChromiumOrEdge(Browser browser) {
        return SWTUtil.hasAnyStyle((Control)browser, 131072, 262144);
    }
}

