/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemoc.dsl.debug.ide;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.model.Breakpoint;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xml.type.internal.DataValue;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.ComposedImage;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.ReflectiveItemProviderAdapterFactory;
import org.eclipse.emf.edit.provider.resource.ResourceItemProviderAdapterFactory;
import org.eclipse.gemoc.dsl.debug.ide.Activator;
import org.eclipse.gemoc.dsl.debug.provider.CustomDebugItemProviderAdapterFactory;
import org.eclipse.gemoc.dsl.debug.provider.DebugEditPlugin;

public class DSLBreakpoint
extends Breakpoint {
    public static final String MARKER_ID = "org.eclipse.gemoc.dsl.debug.ide.breakpointMarker";
    public static final String IMAGE_ATTRIBUTE = "image";
    public static final String URL_MARKER = "url";
    public static final String URI_MARKER = "uri";
    public static final String TEXT_ATTRIBUTE = "text";
    private static final String FULL_OBJ16_BREAKPOINT = "full/obj16/Breakpoint";
    private static final String UTF8 = "UTF8";
    private static final String DELIMITER = ",";
    private static final ComposedAdapterFactory ADAPTER_FACTORY = DSLBreakpoint.initLabelProvider();
    private String identifier;
    private URI instructionUri;

    public DSLBreakpoint() {
    }

    public DSLBreakpoint(String identifier, EObject instruction, boolean persistent) throws CoreException {
        this.identifier = identifier;
        this.instructionUri = EcoreUtil.getURI((EObject)instruction);
        URI resourceURI = instruction.eResource().getURI();
        String pathString = resourceURI.toPlatformString(true);
        IFile resource = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(pathString));
        if (resource != null) {
            CreateMarker runnable = new CreateMarker(resource, instruction, persistent);
            this.run(this.getMarkerRule((IResource)resource), runnable);
        }
    }

    public void setMarker(IMarker marker) throws CoreException {
        super.setMarker(marker);
        try {
            this.identifier = (String)this.getMarker().getAttribute("org.eclipse.debug.core.id");
            String attribute = (String)this.getMarker().getAttribute(URI_MARKER);
            if (attribute != null) {
                this.instructionUri = URI.createURI((String)attribute, (boolean)true);
            }
        }
        catch (CoreException e) {
            Activator.getDefault().error(e);
        }
    }

    private static ComposedAdapterFactory initLabelProvider() {
        ComposedAdapterFactory adapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
        adapterFactory.addAdapterFactory((AdapterFactory)new ResourceItemProviderAdapterFactory());
        CustomDebugItemProviderAdapterFactory debugFactory = new CustomDebugItemProviderAdapterFactory();
        adapterFactory.addAdapterFactory((AdapterFactory)debugFactory);
        adapterFactory.addAdapterFactory((AdapterFactory)new ReflectiveItemProviderAdapterFactory());
        return adapterFactory;
    }

    public String getModelIdentifier() {
        return this.identifier;
    }

    public URI getURI() {
        return this.instructionUri;
    }

    public Object getImage() {
        Object res = null;
        try {
            String attribute = (String)this.getMarker().getAttribute(IMAGE_ATTRIBUTE);
            if (attribute != null && attribute.length() > 0) {
                res = DSLBreakpoint.fromAttribute(attribute);
            }
        }
        catch (CoreException e) {
            res = DebugEditPlugin.INSTANCE.getImage(FULL_OBJ16_BREAKPOINT);
            Activator.getDefault().error(e);
        }
        return res;
    }

    private static Object fromAttribute(String attribute) {
        Object res;
        try {
            String[] urls = attribute.split(DELIMITER);
            if (urls.length > 1) {
                ArrayList<Object> images = new ArrayList<Object>(urls.length);
                String[] stringArray = urls;
                int n = urls.length;
                int n2 = 0;
                while (n2 < n) {
                    String url = stringArray[n2];
                    String decoded = new String(DataValue.Base64.decode((String)url), UTF8);
                    images.add(DSLBreakpoint.fromString(decoded));
                    ++n2;
                }
                res = new ComposedImage(images);
            } else if (urls.length > 0) {
                String decoded = new String(DataValue.Base64.decode((String)urls[0]), UTF8);
                res = DSLBreakpoint.fromString(decoded);
            } else {
                res = DebugEditPlugin.INSTANCE.getImage(FULL_OBJ16_BREAKPOINT);
            }
        }
        catch (IOException e) {
            res = DebugEditPlugin.INSTANCE.getImage(FULL_OBJ16_BREAKPOINT);
            Activator.getDefault().error(e);
        }
        return res;
    }

    private static Object fromString(String decoded) throws MalformedURLException {
        Object res = decoded.startsWith(URL_MARKER) ? new URL(decoded.substring(URL_MARKER.length())) : (decoded.startsWith(URI_MARKER) ? URI.createURI((String)decoded.substring(URI_MARKER.length())) : DebugEditPlugin.INSTANCE.getImage(FULL_OBJ16_BREAKPOINT));
        return res;
    }

    private static String toAttribute(Object image) throws IOException {
        String res;
        StringBuffer buffer = new StringBuffer();
        if (image instanceof ComposedImage) {
            DSLBreakpoint.toAttribute(buffer, (ComposedImage)image);
            res = buffer.length() != 0 ? buffer.substring(0, buffer.length() - 1) : buffer.toString();
        } else if (image instanceof URL) {
            buffer.append(DataValue.Base64.encode((byte[])(URL_MARKER + (URL)image).toString().getBytes(UTF8)));
            res = buffer.toString();
        } else if (image instanceof URI) {
            buffer.append(DataValue.Base64.encode((byte[])(URI_MARKER + (URI)image).toString().getBytes(UTF8)));
            res = buffer.toString();
        } else {
            res = DSLBreakpoint.toAttribute(DebugEditPlugin.INSTANCE.getImage(FULL_OBJ16_BREAKPOINT));
        }
        return res;
    }

    private static void toAttribute(StringBuffer buffer, ComposedImage image) throws IOException {
        for (Object object : image.getImages()) {
            if (object instanceof ComposedImage) {
                DSLBreakpoint.toAttribute(buffer, image);
            } else if (object instanceof URL) {
                buffer.append(DataValue.Base64.encode((byte[])((URL)object).toString().getBytes(UTF8)));
            }
            buffer.append(DELIMITER);
        }
    }

    public String getText() {
        String res = null;
        try {
            res = (String)this.getMarker().getAttribute(TEXT_ATTRIBUTE);
        }
        catch (CoreException e) {
            Activator.getDefault().error(e);
        }
        return res;
    }

    protected String getMarkerID() {
        return MARKER_ID;
    }

    protected void setMarkerAttibutes(IMarker marker, IFile resource, EObject instruction, boolean persistent) throws CoreException {
        IItemLabelProvider provider = (IItemLabelProvider)ADAPTER_FACTORY.adapt((Notifier)instruction, IItemLabelProvider.class);
        marker.setAttribute("org.eclipse.debug.core.enabled", true);
        marker.setAttribute("org.eclipse.debug.core.persisted", persistent);
        marker.setAttribute("org.eclipse.debug.core.id", (Object)this.getModelIdentifier());
        marker.setAttribute(URI_MARKER, (Object)EcoreUtil.getURI((EObject)instruction).toString());
        String instructionText = provider.getText((Object)instruction);
        marker.setAttribute("message", (Object)("DSL Breakpoint: " + resource.getFullPath() + " [" + instructionText + "]"));
        try {
            marker.setAttribute(IMAGE_ATTRIBUTE, (Object)DSLBreakpoint.toAttribute(provider.getImage((Object)instruction)));
        }
        catch (IOException e) {
            Activator.getDefault().error(e);
        }
        marker.setAttribute(TEXT_ATTRIBUTE, (Object)instructionText);
    }

    public final class CreateMarker
    implements IWorkspaceRunnable {
        private final boolean persistent;
        private final EObject instruction;
        private final IFile resource;

        public CreateMarker(IFile resource, EObject instruction, boolean persistent) {
            this.persistent = persistent;
            this.instruction = instruction;
            this.resource = resource;
        }

        public void run(IProgressMonitor monitor) throws CoreException {
            IMarker marker = this.resource.createMarker(DSLBreakpoint.this.getMarkerID());
            DSLBreakpoint.this.setMarkerAttibutes(marker, this.resource, this.instruction, this.persistent);
            DSLBreakpoint.this.setMarker(marker);
        }
    }
}

