/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.merge;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.emf.compare.Conflict;
import org.eclipse.emf.compare.ConflictKind;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.merge.AbstractMerger;
import org.eclipse.emf.compare.merge.DelegatingMerger;
import org.eclipse.emf.compare.merge.IDiffRelationshipComputer;
import org.eclipse.emf.compare.merge.IMergeCriterion;
import org.eclipse.emf.compare.merge.IMerger;
import org.eclipse.emf.compare.merge.IMerger2;
import org.eclipse.emf.compare.utils.EMFComparePredicates;

public class DiffRelationshipComputer
implements IDiffRelationshipComputer {
    private static final Predicate<? super Diff> NOT_HAS_PSEUDO_CONFLICT = Predicates.not(EMFComparePredicates.hasConflict(ConflictKind.PSEUDO));
    protected IMerger.Registry registry;
    protected IMergeCriterion criterion;

    public DiffRelationshipComputer(IMerger.Registry registry) {
        this(registry, IMergeCriterion.NONE);
    }

    public DiffRelationshipComputer(IMerger.Registry registry, IMergeCriterion criterion) {
        this.registry = registry;
        this.criterion = criterion;
    }

    @Override
    public IMerger.Registry getMergerRegistry() {
        return this.registry;
    }

    @Override
    public void setMergerRegistry(IMerger.Registry mergerRegistry) {
        this.registry = mergerRegistry;
    }

    @Override
    public IMergeCriterion getMergeCriterion() {
        return this.criterion;
    }

    @Override
    public void setMergeCriterion(IMergeCriterion mergeCriterion) {
        this.criterion = mergeCriterion;
    }

    protected IMerger.Registry2 getMergerRegistry2() {
        if (this.registry instanceof IMerger.Registry2) {
            return (IMerger.Registry2)this.registry;
        }
        return null;
    }

    @Override
    public IMerger2 getMerger(Diff diff) {
        IMerger.Registry2 mergeRegistry2 = this.getMergerRegistry2();
        if (mergeRegistry2 == null) {
            return null;
        }
        DelegatingMerger mergerDelegate = AbstractMerger.getMergerDelegate(diff, mergeRegistry2, this.getMergeCriterion());
        IMerger merger = mergerDelegate.getMerger();
        if (!(merger instanceof IMerger2)) {
            return null;
        }
        return (IMerger2)merger;
    }

    @Override
    public boolean hasMerger(Diff diff) {
        return this.getMerger(diff) != null;
    }

    @Override
    public Set<Diff> getDirectMergeDependencies(Diff diff, boolean mergeRightToLeft) {
        IMerger2 merger = this.getMerger(diff);
        if (merger != null) {
            return merger.getDirectMergeDependencies(diff, mergeRightToLeft);
        }
        return Collections.emptySet();
    }

    @Override
    public Set<Diff> getDirectResultingMerges(Diff diff, boolean mergeRightToLeft) {
        IMerger2 merger = this.getMerger(diff);
        if (merger != null) {
            return merger.getDirectResultingMerges(diff, mergeRightToLeft);
        }
        return Collections.emptySet();
    }

    @Override
    public Set<Diff> getDirectResultingRejections(Diff diff, boolean mergeRightToLeft) {
        IMerger2 merger = this.getMerger(diff);
        if (merger != null) {
            return merger.getDirectResultingRejections(diff, mergeRightToLeft);
        }
        return Collections.emptySet();
    }

    @Override
    public Set<Diff> getAllResultingMerges(Diff diff, boolean rightToLeft) {
        return this.getAllResultingMerges(diff, rightToLeft, (Predicate<? super Diff>)Predicates.alwaysTrue());
    }

    @Override
    public Set<Diff> getAllResultingMerges(Diff diff, boolean rightToLeft, Predicate<? super Diff> filter) {
        ArrayList newRelations;
        LinkedHashSet<Diff> resultingMerges = new LinkedHashSet<Diff>();
        resultingMerges.add(diff);
        Iterator relations = this.internalGetAllResultingMerges(diff, rightToLeft).iterator();
        do {
            newRelations = Lists.newArrayList();
            while (relations.hasNext()) {
                Conflict conflict;
                Diff relatedDiff = relations.next();
                if (!filter.apply((Object)relatedDiff) || (conflict = relatedDiff.getConflict()) != null && conflict.getKind() == ConflictKind.PSEUDO || !resultingMerges.add(relatedDiff)) continue;
                Set<Diff> internalResultingMerges = this.internalGetAllResultingMerges(relatedDiff, rightToLeft);
                newRelations.add(internalResultingMerges.iterator());
            }
        } while ((relations = Iterators.concat(newRelations.iterator())).hasNext());
        Conflict conflict = diff.getConflict();
        if (conflict != null && conflict.getKind() == ConflictKind.PSEUDO) {
            resultingMerges.addAll((Collection<Diff>)conflict.getDifferences());
        }
        return resultingMerges;
    }

    protected Set<Diff> internalGetAllResultingMerges(Diff diff, boolean rightToLeft) {
        Set<Diff> directParents = this.getDirectMergeDependencies(diff, rightToLeft);
        Set<Diff> directImplications = this.getDirectResultingMerges(diff, rightToLeft);
        if (directParents.isEmpty()) {
            return directImplications;
        }
        if (directImplications.isEmpty()) {
            return directParents;
        }
        Sets.SetView directRelated = Sets.union(directParents, directImplications);
        return directRelated;
    }

    @Override
    public Set<Diff> getAllResultingRejections(Diff diff, boolean mergeRightToLeft) {
        return this.getAllResultingRejections(diff, mergeRightToLeft, (Predicate<? super Diff>)Predicates.alwaysTrue());
    }

    @Override
    public Set<Diff> getAllResultingRejections(Diff diff, boolean mergeRightToLeft, Predicate<? super Diff> filter) {
        LinkedHashSet<Diff> resultingRejections = new LinkedHashSet<Diff>();
        Set<Diff> allResultingMerges = this.getAllResultingMerges(diff, mergeRightToLeft, filter);
        Predicate predicate = Predicates.and(NOT_HAS_PSEUDO_CONFLICT, (Predicate)Predicates.not(EMFComparePredicates.sameSideAs(diff)));
        resultingRejections.addAll(Sets.filter(allResultingMerges, (Predicate)predicate));
        for (Diff resulting : Sets.filter(allResultingMerges, EMFComparePredicates.sameSideAs(diff))) {
            if (!filter.apply((Object)resulting)) continue;
            Set<Diff> rejections = this.getDirectResultingRejections(resulting, mergeRightToLeft);
            Set difference = Sets.filter(rejections, NOT_HAS_PSEUDO_CONFLICT);
            while (!difference.isEmpty()) {
                LinkedHashSet newRejections = new LinkedHashSet(difference);
                resultingRejections.addAll(newRejections);
                rejections = new LinkedHashSet<Diff>();
                for (Diff rejected : newRejections) {
                    if (!filter.apply((Object)rejected)) continue;
                    Set<Diff> directMergeDependencies = this.getDirectMergeDependencies(rejected, mergeRightToLeft);
                    rejections.addAll(Sets.filter(directMergeDependencies, (Predicate)predicate));
                    Set<Diff> directResultingMerges = this.getDirectResultingMerges(rejected, mergeRightToLeft);
                    rejections.addAll(Sets.filter(directResultingMerges, (Predicate)predicate));
                }
                difference = Sets.difference(rejections, resultingRejections);
            }
        }
        return resultingRejections;
    }
}

