/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemoc.commons.eclipse.pde.wizards.pages.pde;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.gemoc.commons.eclipse.pde.wizards.pages.pde.BaseWizardSelectionPage;
import org.eclipse.gemoc.commons.eclipse.pde.wizards.pages.pde.WizardElement;
import org.eclipse.gemoc.commons.eclipse.pde.wizards.pages.pde.ui.IBaseProjectWizard;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardNode;
import org.eclipse.jface.wizard.WizardSelectionPage;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Shell;

public abstract class WizardNode
implements IWizardNode {
    private IWizard wizard;
    private WizardSelectionPage parentWizardPage;
    protected WizardElement wizardElement;

    public WizardNode(WizardSelectionPage parentPage, WizardElement element) {
        this.parentWizardPage = parentPage;
        this.wizardElement = element;
    }

    protected abstract IBaseProjectWizard createWizard() throws CoreException;

    public void dispose() {
        if (this.wizard != null) {
            this.wizard.dispose();
            this.wizard = null;
        }
    }

    public WizardElement getElement() {
        return this.wizardElement;
    }

    public Point getExtent() {
        return new Point(-1, -1);
    }

    public IWizard getWizard() {
        IBaseProjectWizard pluginWizard;
        if (this.wizard != null) {
            return this.wizard;
        }
        try {
            pluginWizard = this.createWizard();
        }
        catch (CoreException e) {
            if (this.parentWizardPage instanceof BaseWizardSelectionPage) {
                ((BaseWizardSelectionPage)this.parentWizardPage).setDescriptionText("");
            }
            PDEPlugin.logException((Throwable)e);
            this.parentWizardPage.setErrorMessage(PDEUIMessages.Errors_CreationError_NoWizard);
            MessageDialog.openError((Shell)this.parentWizardPage.getWizard().getContainer().getShell(), (String)PDEUIMessages.Errors_CreationError, (String)PDEUIMessages.Errors_CreationError_NoWizard);
            return null;
        }
        this.wizard = pluginWizard;
        return this.wizard;
    }

    public boolean isContentCreated() {
        return this.wizard != null;
    }
}

