/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.common.core.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class FileCopyUtil {
    private FileCopyUtil() {
    }

    public static void copyFolder(String sourceFolder, String targetFolder) throws FileNotFoundException, IOException {
        assert (new File(sourceFolder).isDirectory());
        assert (new File(targetFolder).isDirectory());
        File source = new File(sourceFolder);
        String[] files = source.list();
        int i = 0;
        while (i < files.length) {
            File f = new File(String.valueOf(sourceFolder) + File.separator + files[i]);
            if (f.isDirectory()) {
                FileCopyUtil.copyFolder(sourceFolder, targetFolder, files[i]);
            } else {
                FileCopyUtil.copyFile(sourceFolder, targetFolder, files[i]);
            }
            ++i;
        }
    }

    public static void copyFile(String sourceFile, String targetFolder) throws FileNotFoundException, IOException {
        assert (new File(sourceFile).isFile());
        assert (new File(targetFolder).isDirectory());
        File source = new File(sourceFile);
        FileCopyUtil.copyFile(source.getParent(), targetFolder, source.getName());
    }

    private static void copyFolder(String sourceFolder, String targetFolder, String name) throws FileNotFoundException, IOException {
        File target = new File(String.valueOf(targetFolder) + File.separator + name);
        target.mkdir();
        FileCopyUtil.copyFolder(String.valueOf(sourceFolder) + File.separator + name, String.valueOf(targetFolder) + File.separator + name);
    }

    private static void copyFile(String sourceFolder, String targetFolder, String name) throws FileNotFoundException, IOException {
        FileCopyUtil.copyFile(sourceFolder, targetFolder, name, name);
    }

    public static void copyFile(String sourceFolder, String targetFolder, String sourceName, String targetName) throws FileNotFoundException, IOException {
        int len;
        FileInputStream is = new FileInputStream(String.valueOf(sourceFolder) + File.separator + sourceName);
        FileOutputStream os = new FileOutputStream(String.valueOf(targetFolder) + File.separator + targetName);
        byte[] buffer = new byte[102400];
        while ((len = ((InputStream)is).read(buffer)) >= 0) {
            ((OutputStream)os).write(buffer, 0, len);
        }
        ((InputStream)is).close();
        ((OutputStream)os).close();
    }
}

