/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemoc.timeline.editpart;

import java.util.List;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.FreeformLayer;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.gef.editpolicies.XYLayoutEditPolicy;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.gemoc.timeline.layout.LineLayout;
import org.eclipse.gemoc.timeline.model.Branch;
import org.eclipse.gemoc.timeline.model.Choice;
import org.eclipse.jface.resource.JFaceResources;

public class BranchEditPart
extends AbstractGraphicalEditPart {
    public static final int SPACING = 10;
    public static final int MARGIN = 10;

    protected IFigure createFigure() {
        LineLayout layout = new LineLayout();
        layout.setHorizontal(true);
        layout.setMajorAlignment(1);
        layout.setMinorAlignment(2);
        layout.setMinorSpacing(10);
        layout.setMargin(10);
        FreeformLayer res = new FreeformLayer();
        Label toolTip = new Label();
        toolTip.setFont(JFaceResources.getFont((String)"org.eclipse.jface.textfont"));
        toolTip.setBackgroundColor(ColorConstants.tooltipBackground);
        toolTip.setForegroundColor(ColorConstants.tooltipForeground);
        toolTip.setText(this.getModel().getTimelineWindow().getProvider().getTextAt(this.getModel().getBranch()));
        res.setToolTip((IFigure)toolTip);
        res.setLayoutManager((LayoutManager)layout);
        return res;
    }

    protected void refreshVisuals() {
        super.refreshVisuals();
        int offset = Math.max(this.getModel().getTimelineWindow().getProvider().getStart(this.getModel().getBranch()) - this.getModel().getTimelineWindow().getStart(), 0);
        this.getFigure().setBorder((Border)new MarginBorder(0, offset * 30, 0, 0));
    }

    protected void createEditPolicies() {
        this.installEditPolicy("LayoutEditPolicy", (EditPolicy)new XYLayoutEditPolicy(){

            protected Command getCreateCommand(CreateRequest request) {
                return null;
            }
        });
    }

    public List<Choice> getModelChildren() {
        return this.getModel().getChoices();
    }

    public Branch getModel() {
        return (Branch)super.getModel();
    }
}

