/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemoc.commons.eclipse.emf;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;

public final class EMFResource {
    private EMFResource() {
    }

    public static Object getFirstContent(IFile xmiFile) {
        return EMFResource.getFirstContent(EMFResource.getResource(xmiFile));
    }

    public static Object getFirstContent(String uriAsString) {
        return EMFResource.getFirstContent(EMFResource.getResource(uriAsString));
    }

    public static Object getFirstContent(URI uri) {
        return EMFResource.getFirstContent(EMFResource.getResource(uri));
    }

    private static Object getFirstContent(Resource resource) {
        if (resource.getContents().size() > 0) {
            return resource.getContents().get(0);
        }
        return null;
    }

    public static Resource getResource(String uriAsString) {
        URI uri = URI.createURI((String)uriAsString);
        return EMFResource.getResource(uri);
    }

    public static Resource getResource(IFile file) {
        URI uri = URI.createURI((String)file.getLocationURI().toString());
        return EMFResource.getResource(uri);
    }

    public static Resource getResource(URI uri) {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        Resource r = resourceSet.getResource(uri, true);
        return r;
    }

    public static Set<Resource> getRelatedResources(Resource res) {
        HashSet<Resource> result = new HashSet<Resource>();
        result.addAll(EMFResource.getRelatedResources(res, result));
        return result;
    }

    protected static Set<Resource> getRelatedResources(Resource res, Set<Resource> result) {
        if (result.contains(res)) {
            return result;
        }
        result.add(res);
        Map crossRefs = EcoreUtil.ExternalCrossReferencer.find((Resource)res);
        for (Map.Entry entry : crossRefs.entrySet()) {
            EObject proxyEObject = (EObject)entry.getKey();
            result.addAll(EMFResource.getRelatedResources(proxyEObject.eResource(), result));
        }
        return result;
    }

    public static IFile getIFile(EObject eObject) {
        return EMFResource.getIFile(eObject.eResource());
    }

    public static IFile getIFile(Resource res) {
        URI uri = res.getURI();
        String filePath = uri.toPlatformString(true);
        IFile ifile = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(filePath));
        return ifile;
    }
}

