/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.generator.ui.wizard.deprecated;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.etrice.generator.ui.wizard.deprecated.SelectRoomPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.internal.ide.misc.ContainerSelectionGroup;

public class SaveMappingPage
extends WizardPage
implements Listener,
ModifyListener {
    private ContainerSelectionGroup containerGroup;
    private Text physText;
    private Text mapText;
    private IFile mappingModelPath = null;
    private IFile physModelPath = null;

    public SaveMappingPage() {
        super("save_mapping_page");
    }

    public IFile getMappingFilePath() {
        return this.mappingModelPath;
    }

    public IFile getPhysModelPath() {
        return this.physModelPath;
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite topLevel = new Composite(parent, 0);
        GridLayout gl_topLevel = new GridLayout();
        gl_topLevel.marginHeight = 0;
        topLevel.setLayout((Layout)gl_topLevel);
        topLevel.setLayoutData((Object)new GridData(4, 4, true, true));
        topLevel.setFont(parent.getFont());
        this.containerGroup = new ContainerSelectionGroup(topLevel, (Listener)this, false, null, false);
        this.containerGroup.setLayoutData((Object)new GridData(4, 4, true, true));
        Composite namingComp = new Composite(topLevel, 0);
        namingComp.setLayoutData((Object)new GridData(4, 0x1000008, true, false));
        namingComp.setLayout((Layout)new GridLayout(3, false));
        Label label = new Label(namingComp, 0);
        label.setText("etMap file name: ");
        this.mapText = new Text(namingComp, 2048);
        this.mapText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.mapText.addModifyListener((ModifyListener)this);
        Label labelExt = new Label(namingComp, 0);
        labelExt.setEnabled(false);
        labelExt.setText(".etmap");
        label = new Label(namingComp, 0);
        label.setText("etPhys file name: ");
        this.physText = new Text(namingComp, 2048);
        this.physText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.physText.addModifyListener((ModifyListener)this);
        labelExt = new Label(namingComp, 0);
        labelExt.setEnabled(false);
        labelExt.setText(".etphys");
        this.setControl((Control)topLevel);
        SelectRoomPage selectRoomPage = (SelectRoomPage)this.getWizard().getPages()[0];
        if (selectRoomPage.getSelectedRoomResource() != null) {
            this.setModelPath(selectRoomPage.getSelectedRoomResource());
        }
    }

    public void setModelPath(IFile roomFile) {
        if (this.getControl() == null) {
            return;
        }
        this.containerGroup.setSelectedContainer(roomFile.getParent());
        String roomFileName = roomFile.getName().replace("." + roomFile.getFileExtension(), "");
        this.mapText.setText(roomFileName);
        this.physText.setText(roomFileName);
        this.handleUserInput();
        this.setPageComplete();
    }

    public void handleEvent(Event event) {
        this.handleUserInput();
        this.setPageComplete();
    }

    public void modifyText(ModifyEvent e) {
        this.handleUserInput();
        this.setPageComplete();
    }

    private void setPageComplete() {
        this.setPageComplete(this.mappingModelPath != null && this.physModelPath != null);
    }

    private void handleUserInput() {
        this.mappingModelPath = null;
        this.physModelPath = null;
        this.setErrorMessage(null);
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IPath path = this.containerGroup.getContainerFullPath();
        if (path == null || path.isEmpty() || !root.exists(path)) {
            return;
        }
        String mapFileName = this.mapText.getText();
        String physFileName = this.physText.getText();
        if (mapFileName == null || mapFileName.isEmpty() || physFileName == null || physFileName.isEmpty()) {
            return;
        }
        IFile mapFileTemp = root.getFile(path.append(mapFileName).addFileExtension("etmap"));
        if (mapFileTemp.exists()) {
            this.setErrorMessage(String.valueOf(mapFileTemp.getFullPath()) + " already exists");
            return;
        }
        IFile physFileTemp = root.getFile(path.append(physFileName).addFileExtension("etphys"));
        if (physFileTemp.exists()) {
            this.setErrorMessage(String.valueOf(physFileTemp.getFullPath()) + " already exists");
            return;
        }
        this.mappingModelPath = mapFileTemp;
        this.physModelPath = physFileTemp;
    }
}

