/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.generator.doc;

import com.google.inject.Inject;
import com.google.inject.Module;
import java.util.List;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.etrice.core.etmap.util.ETMapUtil;
import org.eclipse.etrice.core.genmodel.etricegen.Root;
import org.eclipse.etrice.core.genmodel.fsm.IDiagnostician;
import org.eclipse.etrice.generator.base.AbstractGenerator;
import org.eclipse.etrice.generator.base.args.Arguments;
import org.eclipse.etrice.generator.base.io.IGeneratorFileIO;
import org.eclipse.etrice.generator.base.logging.ILogger;
import org.eclipse.etrice.generator.doc.gen.InstanceDiagramGen;
import org.eclipse.etrice.generator.doc.gen.MainGen;
import org.eclipse.etrice.generator.doc.setup.GeneratorModule;

public class Main
extends AbstractGenerator {
    @Inject
    private MainGen mainGenerator;
    @Inject
    protected InstanceDiagramGen instanceDiagramGenerator;

    public static int run(String[] args) {
        return Main.createAndRunGenerator((Module)new GeneratorModule(), (String[])args);
    }

    public static void main(String[] args) {
        int ret = Main.run(args);
        System.exit(ret);
    }

    protected int runGenerator(List<Resource> resources, Arguments arguments, IGeneratorFileIO fileIO, ILogger logger) {
        Root genModel = this.createGeneratorModel(resources, arguments, fileIO, logger);
        if (this.diagnostician.isFailed() || genModel == null) {
            logger.logError("errors during build of generator model");
            return 1;
        }
        ETMapUtil.processModels((Root)genModel, (ResourceSet)this.getResourceSet(), (IDiagnostician)this.diagnostician);
        this.mainGenerator.doGenerate(genModel, arguments, fileIO);
        return 0;
    }
}

