/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.generator.base.cli;

import java.io.File;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.stream.Stream;
import org.eclipse.etrice.generator.base.args.Arguments;
import org.eclipse.etrice.generator.base.args.BooleanOption;
import org.eclipse.etrice.generator.base.args.EnumOption;
import org.eclipse.etrice.generator.base.args.Option;
import org.eclipse.etrice.generator.base.args.Options;
import org.eclipse.etrice.generator.base.args.PathOption;
import org.eclipse.etrice.generator.base.args.StringOption;
import org.eclipse.etrice.generator.base.cli.CommandLineParseException;
import org.eclipse.etrice.generator.base.cli.ICommandLineParser;

public class CommandLineParser
implements ICommandLineParser {
    @Override
    public Arguments parseArgs(Options options, Option<String[]> defaultOption, List<String> args) throws CommandLineParseException {
        Arguments parsedArgs = new Arguments(options);
        List<String> nArgs = this.normalize(args);
        ListIterator<String> iterator = nArgs.listIterator();
        LinkedList<String> defaultArgs = new LinkedList<String>();
        while (iterator.hasNext()) {
            String str = iterator.next().trim();
            if (str.startsWith("-")) {
                Option<?> opt = this.parseOption(options, str);
                this.parseValue(opt, iterator, parsedArgs);
                continue;
            }
            defaultArgs.add(str);
        }
        if (!defaultArgs.isEmpty()) {
            parsedArgs.set(defaultOption, defaultArgs.toArray(new String[0]));
        }
        return parsedArgs;
    }

    private List<String> normalize(List<String> args) throws CommandLineParseException {
        LinkedList<String> nArgs = new LinkedList<String>(args);
        return nArgs;
    }

    private Option<?> parseOption(Options options, String str) throws CommandLineParseException {
        try {
            String optionName = str.substring(1);
            Option<?> opt = options.get(optionName);
            return opt;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new CommandLineParseException("Option " + str + " not recognized");
        }
    }

    private void parseValue(Option<?> opt, ListIterator<String> iterator, Arguments parsedArgs) throws CommandLineParseException {
        if (opt instanceof BooleanOption) {
            BooleanOption boolOpt = (BooleanOption)opt;
            parsedArgs.set(boolOpt, true);
        } else {
            if (!iterator.hasNext()) {
                throw new CommandLineParseException("Expected one argument for option " + opt.getName());
            }
            String str = iterator.next();
            if (opt instanceof StringOption) {
                StringOption strOpt = (StringOption)opt;
                parsedArgs.set(strOpt, str);
            } else if (opt instanceof PathOption) {
                PathOption pathOpt = (PathOption)opt;
                String[] currentPath = parsedArgs.hasArgument(pathOpt) ? parsedArgs.get(pathOpt) : new String[]{};
                String[] value = str.split(File.pathSeparator);
                String[] combinedPath = (String[])Stream.concat(Arrays.stream(currentPath), Arrays.stream(value)).toArray(String[]::new);
                parsedArgs.set(pathOpt, combinedPath);
            } else if (opt instanceof EnumOption) {
                EnumOption enumOpt = (EnumOption)opt;
                Enum<?> value = this.parseEnum(enumOpt, str);
                parsedArgs.set(enumOpt.getName(), value);
            } else {
                throw new CommandLineParseException("Option " + opt.getName() + " is not supported on the command line");
            }
        }
    }

    private Enum<?> parseEnum(EnumOption<?> opt, String str) {
        Enum[] constants;
        Enum[] enumArray = constants = (Enum[])opt.getType().getEnumConstants();
        int n = constants.length;
        int n2 = 0;
        while (n2 < n) {
            Enum c = enumArray[n2];
            if (c.toString().equalsIgnoreCase(str)) {
                return c;
            }
            ++n2;
        }
        throw new CommandLineParseException("Argument " + str + " not allowed for option " + opt.getName());
    }
}

