/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.expressions.ui.contentassist;

import com.google.common.base.Objects;
import com.google.common.base.Strings;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.etrice.core.room.Attribute;
import org.eclipse.etrice.core.room.InterfaceItem;
import org.eclipse.etrice.core.room.Message;
import org.eclipse.etrice.core.room.MessageData;
import org.eclipse.etrice.core.room.Operation;
import org.eclipse.etrice.core.room.Port;
import org.eclipse.etrice.core.room.SPP;
import org.eclipse.etrice.core.room.VarDecl;
import org.eclipse.etrice.core.room.util.RoomHelpers;
import org.eclipse.etrice.expressions.detailcode.IDetailExpressionProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.Pair;

@Singleton
public class DetailExpressionProposalConfig {
    @Inject
    protected ILabelProvider labelProvider;
    @Inject
    protected RoomHelpers roomHelpers;

    public Pair<String, Point> getPostfixReplacement(IDetailExpressionProvider.ExpressionFeature feature) {
        boolean bl;
        MessageData messageData;
        Object object;
        String[] stringArray;
        Pair pair;
        block14: {
            block13: {
                pair = null;
                this.assertNotNull(feature);
                stringArray = null;
                IDetailExpressionProvider.ExpressionPostfix expressionPostfix = feature.getPostfix();
                if (expressionPostfix == null) break block13;
                switch (expressionPostfix) {
                    case PARENTHESES: {
                        stringArray = new String[]{"(", ")"};
                        break block14;
                    }
                    case BRACKETS: {
                        stringArray = new String[]{"[", "]"};
                        break block14;
                    }
                    default: {
                        return Pair.of((Object)"", null);
                    }
                }
            }
            return Pair.of((Object)"", null);
        }
        String[] brackets = stringArray;
        String string = null;
        Object data = object = feature.getData();
        boolean bl2 = false;
        if (data instanceof Operation) {
            bl2 = true;
            messageData = new Functions.Function1<VarDecl, String>(){

                public String apply(VarDecl it) {
                    return it.getName();
                }
            };
            string = IterableExtensions.join((Iterable)ListExtensions.map((List)((Operation)data).getArguments(), (Functions.Function1)messageData), (CharSequence)", ");
        }
        if (!bl2 && data instanceof Message) {
            boolean bl3;
            messageData = ((Message)data).getData();
            boolean bl4 = bl3 = messageData != null;
            if (bl3) {
                bl2 = true;
                string = "transitionData";
            }
        }
        if (!bl2) {
            if (data instanceof Attribute) {
                bl2 = true;
            }
            if (!bl2 && data instanceof InterfaceItem) {
                bl2 = true;
            }
            if (bl2) {
                string = "0";
            }
        }
        if (!bl2) {
            string = "";
        }
        String replacement = string;
        Point point = null;
        boolean bl5 = replacement.isEmpty();
        boolean bl6 = bl = !bl5;
        if (bl) {
            int n = replacement.length();
            point = new Point(1, n);
        }
        Point selection = point;
        String[] stringArray2 = brackets;
        String string2 = (String)IterableExtensions.head((Iterable)((Iterable)Conversions.doWrapArray((Object)stringArray2)));
        String string3 = String.valueOf(string2) + replacement;
        String[] stringArray3 = brackets;
        String string4 = (String)IterableExtensions.last((Iterable)((Iterable)Conversions.doWrapArray((Object)stringArray3)));
        String string5 = String.valueOf(string3) + string4;
        pair = Pair.of((Object)string5, (Object)selection);
        return pair;
    }

    public Pair<String, Point> getCompletion(IDetailExpressionProvider.ExpressionFeature feature) {
        this.assertNotNull(feature);
        Pair<String, Point> postfix = this.getPostfixReplacement(feature);
        Point point = (Point)postfix.getValue();
        if (point != null) {
            int n = point.x;
            int n2 = feature.getId().length();
            point.x = n + n2;
        }
        String string = feature.getId();
        String string2 = (String)postfix.getKey();
        String string3 = String.valueOf(string) + string2;
        return Pair.of((Object)string3, (Object)point);
    }

    public String getDisplayString(IDetailExpressionProvider.ExpressionFeature feature) {
        boolean bl;
        boolean bl2;
        boolean bl3;
        boolean bl4;
        boolean bl5;
        String label;
        String string;
        Object object;
        Object object2;
        this.assertNotNull(feature);
        Object data = feature.getData();
        String string2 = feature.getId();
        String string3 = (String)this.getPostfixReplacement(feature).getKey();
        String completionInfo = String.valueOf(string2) + string3;
        String typedInfo = "";
        String string4 = null;
        string4 = data instanceof EObject ? ((EObject)data).eClass().getName() : "";
        String classInfo = string4;
        boolean bl6 = false;
        if (data instanceof Attribute) {
            bl6 = true;
            object2 = null;
            if ((Attribute)data != null) {
                object2 = ((Attribute)data).getType();
            }
            object = null;
            if (object2 != null) {
                object = object2.getType();
            }
            string = null;
            if (object != null) {
                string = object.getName();
            }
            typedInfo = string;
        }
        if (!bl6 && data instanceof InterfaceItem) {
            bl6 = true;
            object2 = ((InterfaceItem)data).getProtocol();
            object = null;
            if (object2 != null) {
                object = object2.getName();
            }
            typedInfo = object;
        }
        if (!bl6 && data instanceof VarDecl) {
            bl6 = true;
            object2 = null;
            if ((VarDecl)data != null) {
                object2 = ((VarDecl)data).getRefType();
            }
            object = null;
            if (object2 != null) {
                object = object2.getType();
            }
            string = null;
            if (object != null) {
                string = object.getName();
            }
            typedInfo = string;
            classInfo = "";
        }
        if (!bl6 && data instanceof MessageData) {
            bl6 = true;
            object2 = null;
            if ((MessageData)data != null) {
                object2 = ((MessageData)data).getRefType();
            }
            object = null;
            if (object2 != null) {
                object = object2.getType();
            }
            string = null;
            if (object != null) {
                string = object.getName();
            }
            typedInfo = string;
        }
        if (!bl6 && (label = this.labelProvider.getText(data)) != null && !Strings.commonPrefix((CharSequence)label, (CharSequence)completionInfo).isEmpty()) {
            completionInfo = label;
        }
        if (bl5 = Objects.equal((Object)(object2 = feature.getPostfix()), (Object)((Object)IDetailExpressionProvider.ExpressionPostfix.NONE))) {
            boolean bl7 = false;
            if (data instanceof SPP && (bl4 = ((SPP)data).isEventDriven())) {
                bl7 = true;
            }
            if (!bl7 && data instanceof Port && ((Port)data).isReplicated() && ((Port)data).isEventDriven()) {
                bl7 = true;
            }
            if (bl7) {
                completionInfo = String.valueOf(completionInfo) + " (broadcast)";
            }
        }
        boolean bl8 = bl4 = !(bl3 = typedInfo.isEmpty());
        if (bl4) {
            typedInfo = " : " + typedInfo;
        }
        boolean bl9 = bl2 = !(bl = classInfo.isEmpty());
        if (bl2) {
            classInfo = " - " + classInfo;
        }
        return String.valueOf(completionInfo) + typedInfo + classInfo;
    }

    public Image getImage(IDetailExpressionProvider.ExpressionFeature feature) {
        Image image = null;
        this.assertNotNull(feature);
        Image image2 = null;
        Object object = feature.getData();
        boolean bl = false;
        if (object instanceof EObject) {
            bl = true;
            image2 = this.labelProvider.getImage(feature.getData());
        }
        image = image2;
        return image;
    }

    protected void assertNotNull(IDetailExpressionProvider.ExpressionFeature feature) {
        boolean bl = Strings.isNullOrEmpty((String)feature.getId());
        boolean bl2 = !bl;
        Assert.isTrue((boolean)bl2);
        Assert.isNotNull((Object)((Object)feature.getPostfix()));
        Assert.isNotNull((Object)feature.getData());
    }
}

