/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.generator.doc.gen;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.etrice.core.common.base.Documentation;
import org.eclipse.etrice.core.common.documentation.CommonMarkParser;
import org.eclipse.etrice.core.common.documentation.DocumentationMarkup;
import org.eclipse.etrice.core.fsm.fSM.ModelComponent;
import org.eclipse.etrice.core.fsm.fSM.State;
import org.eclipse.etrice.core.fsm.fSM.StateGraph;
import org.eclipse.etrice.core.fsm.naming.FSMQualifiedNameProvider;
import org.eclipse.etrice.core.genmodel.etricegen.Root;
import org.eclipse.etrice.core.room.ActorClass;
import org.eclipse.etrice.core.room.ActorContainerClass;
import org.eclipse.etrice.core.room.Attribute;
import org.eclipse.etrice.core.room.DataClass;
import org.eclipse.etrice.core.room.EnumLiteral;
import org.eclipse.etrice.core.room.EnumerationType;
import org.eclipse.etrice.core.room.LogicalSystem;
import org.eclipse.etrice.core.room.Message;
import org.eclipse.etrice.core.room.Operation;
import org.eclipse.etrice.core.room.Port;
import org.eclipse.etrice.core.room.ProtocolClass;
import org.eclipse.etrice.core.room.RoomClass;
import org.eclipse.etrice.core.room.RoomModel;
import org.eclipse.etrice.core.room.StructureClass;
import org.eclipse.etrice.core.room.SubSystemClass;
import org.eclipse.etrice.core.room.VarDecl;
import org.eclipse.etrice.core.room.util.RoomHelpers;
import org.eclipse.etrice.generator.base.AbstractGeneratorOptionsHelper;
import org.eclipse.etrice.generator.base.io.IGeneratorFileIO;
import org.eclipse.etrice.generator.doc.Main;
import org.eclipse.etrice.generator.fsm.base.CodegenHelpers;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.documentation.IEObjectDocumentationProvider;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

@Singleton
public class AsciiDocGen {
    @Inject
    @Extension
    private RoomHelpers _roomHelpers;
    @Inject
    @Extension
    private CodegenHelpers _codegenHelpers;
    @Inject
    @Extension
    protected AbstractGeneratorOptionsHelper _abstractGeneratorOptionsHelper;
    @Inject
    private IEObjectDocumentationProvider eObjDocuProvider;
    @Inject
    @Extension
    private FSMQualifiedNameProvider fsmNameProvider;

    public void doGenerate(Root root, IGeneratorFileIO fileIO, boolean includeImages) {
        Functions.Function1<RoomModel, String> function1 = new Functions.Function1<RoomModel, String>(){

            public String apply(RoomModel it) {
                return it.getName();
            }
        };
        Functions.Function1<Map.Entry<String, List<RoomModel>>, RoomPackage> function12 = new Functions.Function1<Map.Entry<String, List<RoomModel>>, RoomPackage>(){

            public RoomPackage apply(Map.Entry<String, List<RoomModel>> it) {
                String string = it.getKey();
                List<RoomModel> list = it.getValue();
                return new RoomPackage(string, list);
            }
        };
        Functions.Function1<RoomPackage, String> function13 = new Functions.Function1<RoomPackage, String>(){

            public String apply(RoomPackage it) {
                return it.name;
            }
        };
        List packages = IterableExtensions.sortBy((Iterable)IterableExtensions.map(IterableExtensions.groupBy((Iterable)root.getModels(), (Functions.Function1)function1).entrySet(), (Functions.Function1)function12), (Functions.Function1)function13);
        fileIO.generateFile("doc.adoc", this.generateSingleDoc(packages, includeImages));
    }

    public CharSequence generateSingleDoc(Iterable<RoomPackage> packages, boolean includeImages) {
        CharSequence charSequence;
        boolean bl;
        StringConcatenation stringConcatenation = new StringConcatenation();
        stringConcatenation.append("= Model Documentation");
        stringConcatenation.newLine();
        stringConcatenation.append(":toc: left");
        stringConcatenation.newLine();
        stringConcatenation.append(":toclevels: 2");
        stringConcatenation.newLine();
        stringConcatenation.append(":table-caption!:");
        stringConcatenation.newLine();
        CharSequence charSequence2 = AsciiDocGen.tagStart("all");
        stringConcatenation.append((Object)charSequence2);
        stringConcatenation.newLineIfNotEmpty();
        stringConcatenation.append("generated by eTrice");
        stringConcatenation.newLine();
        stringConcatenation.append("{docdatetime}");
        stringConcatenation.newLine();
        boolean bl2 = IterableExtensions.isEmpty(packages);
        boolean bl3 = bl = !bl2;
        if (bl) {
            stringConcatenation.newLine();
            stringConcatenation.append(".Room Packages");
            stringConcatenation.newLine();
            for (RoomPackage pkg : packages) {
                stringConcatenation.append("* ");
                charSequence = AsciiDocGen.crossReference(pkg.name);
                stringConcatenation.append((Object)charSequence);
                stringConcatenation.newLineIfNotEmpty();
            }
        }
        for (RoomPackage pkg_1 : packages) {
            CharSequence charSequence3;
            stringConcatenation.newLine();
            CharSequence charSequence4 = AsciiDocGen.defineAnchor(pkg_1.name);
            stringConcatenation.append((Object)charSequence4);
            stringConcatenation.newLineIfNotEmpty();
            stringConcatenation.append("== ");
            stringConcatenation.append(pkg_1.name);
            stringConcatenation.newLineIfNotEmpty();
            CharSequence charSequence5 = AsciiDocGen.tagStart(pkg_1);
            stringConcatenation.append((Object)charSequence5);
            stringConcatenation.newLineIfNotEmpty();
            charSequence = this.generatePackageRefs(pkg_1);
            stringConcatenation.append((Object)charSequence);
            stringConcatenation.newLineIfNotEmpty();
            for (EnumerationType en : pkg_1.enumerationTypes) {
                stringConcatenation.newLine();
                charSequence3 = this.generateEnumerationDoc(en);
                stringConcatenation.append((Object)charSequence3);
                stringConcatenation.newLineIfNotEmpty();
            }
            for (DataClass dc : pkg_1.dataClasses) {
                stringConcatenation.newLine();
                charSequence3 = this.generateDataDoc(dc);
                stringConcatenation.append((Object)charSequence3);
                stringConcatenation.newLineIfNotEmpty();
            }
            for (ProtocolClass pc : pkg_1.protocolClasses) {
                stringConcatenation.newLine();
                charSequence3 = this.generateProtocolDoc(pc);
                stringConcatenation.append((Object)charSequence3);
                stringConcatenation.newLineIfNotEmpty();
            }
            for (LogicalSystem sys : pkg_1.systems) {
                stringConcatenation.newLine();
                charSequence3 = this.generateLogicalSystemDoc(sys, includeImages);
                stringConcatenation.append((Object)charSequence3);
                stringConcatenation.newLineIfNotEmpty();
            }
            for (SubSystemClass subSys : pkg_1.subSystemClasses) {
                stringConcatenation.newLine();
                charSequence3 = this.generateSubSystemDoc(subSys, includeImages);
                stringConcatenation.append((Object)charSequence3);
                stringConcatenation.newLineIfNotEmpty();
            }
            for (ActorClass ac : pkg_1.actorClasses) {
                stringConcatenation.newLine();
                charSequence3 = this.generateActorDoc(ac, includeImages);
                stringConcatenation.append((Object)charSequence3);
                stringConcatenation.newLineIfNotEmpty();
            }
            CharSequence charSequence6 = AsciiDocGen.tagEnd(pkg_1);
            stringConcatenation.append((Object)charSequence6);
            stringConcatenation.newLineIfNotEmpty();
        }
        CharSequence charSequence7 = AsciiDocGen.tagEnd("all");
        stringConcatenation.append((Object)charSequence7);
        stringConcatenation.newLineIfNotEmpty();
        return stringConcatenation;
    }

    private CharSequence generatePackageRefs(RoomPackage pkg) {
        CharSequence charSequence;
        CharSequence charSequence2;
        boolean bl;
        StringConcatenation stringConcatenation = new StringConcatenation();
        boolean bl2 = IterableExtensions.isEmpty(pkg.systems);
        boolean bl3 = bl = !bl2;
        if (bl) {
            stringConcatenation.newLine();
            stringConcatenation.append(".Logical System Classes");
            stringConcatenation.newLine();
            stringConcatenation.append("|===");
            stringConcatenation.newLine();
            stringConcatenation.append("| Name | Description");
            stringConcatenation.newLine();
            for (LogicalSystem s : pkg.systems) {
                stringConcatenation.newLine();
                stringConcatenation.append("| ");
                charSequence2 = AsciiDocGen.crossReference((RoomClass)s);
                stringConcatenation.append((Object)charSequence2);
                stringConcatenation.newLineIfNotEmpty();
                stringConcatenation.append("| ");
                charSequence = this.getShortDocText((EObject)s);
                stringConcatenation.append((Object)charSequence);
                stringConcatenation.newLineIfNotEmpty();
            }
            stringConcatenation.append("|===");
            stringConcatenation.newLine();
        }
        boolean bl4 = bl = !(bl2 = IterableExtensions.isEmpty(pkg.subSystemClasses));
        if (bl) {
            stringConcatenation.newLine();
            stringConcatenation.append(".Subsystem Classes");
            stringConcatenation.newLine();
            stringConcatenation.append("|===");
            stringConcatenation.newLine();
            stringConcatenation.append("| Name | Description");
            stringConcatenation.newLine();
            for (SubSystemClass s_1 : pkg.subSystemClasses) {
                stringConcatenation.newLine();
                stringConcatenation.append("| ");
                charSequence2 = AsciiDocGen.crossReference((RoomClass)s_1);
                stringConcatenation.append((Object)charSequence2);
                stringConcatenation.newLineIfNotEmpty();
                stringConcatenation.append("| ");
                charSequence = this.getShortDocText((EObject)s_1);
                stringConcatenation.append((Object)charSequence);
                stringConcatenation.newLineIfNotEmpty();
            }
            stringConcatenation.append("|===");
            stringConcatenation.newLine();
        }
        boolean bl5 = bl = !(bl2 = IterableExtensions.isEmpty(pkg.protocolClasses));
        if (bl) {
            stringConcatenation.newLine();
            stringConcatenation.append(".ProtocolClasses");
            stringConcatenation.newLine();
            stringConcatenation.append("|===");
            stringConcatenation.newLine();
            stringConcatenation.append("| Name | Description");
            stringConcatenation.newLine();
            for (ProtocolClass c : pkg.protocolClasses) {
                stringConcatenation.newLine();
                stringConcatenation.append("| ");
                charSequence2 = AsciiDocGen.crossReference((RoomClass)c);
                stringConcatenation.append((Object)charSequence2);
                stringConcatenation.newLineIfNotEmpty();
                stringConcatenation.append("| ");
                charSequence = this.getShortDocText((EObject)c);
                stringConcatenation.append((Object)charSequence);
                stringConcatenation.newLineIfNotEmpty();
            }
            stringConcatenation.append("|===");
            stringConcatenation.newLine();
        }
        boolean bl6 = bl = !(bl2 = IterableExtensions.isEmpty(pkg.enumerationTypes));
        if (bl) {
            stringConcatenation.newLine();
            stringConcatenation.append(".Enumeration Types");
            stringConcatenation.newLine();
            stringConcatenation.append("|===");
            stringConcatenation.newLine();
            stringConcatenation.append("| Name | Description");
            stringConcatenation.newLine();
            for (EnumerationType e : pkg.enumerationTypes) {
                stringConcatenation.newLine();
                stringConcatenation.append("| ");
                charSequence2 = AsciiDocGen.crossReference((RoomClass)e);
                stringConcatenation.append((Object)charSequence2);
                stringConcatenation.newLineIfNotEmpty();
                stringConcatenation.append("| ");
                charSequence = this.getShortDocText((EObject)e);
                stringConcatenation.append((Object)charSequence);
                stringConcatenation.newLineIfNotEmpty();
            }
            stringConcatenation.append("|===");
            stringConcatenation.newLine();
        }
        boolean bl7 = bl = !(bl2 = IterableExtensions.isEmpty(pkg.dataClasses));
        if (bl) {
            stringConcatenation.newLine();
            stringConcatenation.append(".Data Classes");
            stringConcatenation.newLine();
            stringConcatenation.append("|===");
            stringConcatenation.newLine();
            stringConcatenation.append("| Name | Description");
            stringConcatenation.newLine();
            for (DataClass c_1 : pkg.dataClasses) {
                stringConcatenation.newLine();
                stringConcatenation.append("| ");
                charSequence2 = AsciiDocGen.crossReference((RoomClass)c_1);
                stringConcatenation.append((Object)charSequence2);
                stringConcatenation.newLineIfNotEmpty();
                stringConcatenation.append("| ");
                charSequence = this.getShortDocText((EObject)c_1);
                stringConcatenation.append((Object)charSequence);
                stringConcatenation.newLineIfNotEmpty();
            }
            stringConcatenation.append("|===");
            stringConcatenation.newLine();
        }
        boolean bl8 = bl = !(bl2 = IterableExtensions.isEmpty(pkg.actorClasses));
        if (bl) {
            stringConcatenation.newLine();
            stringConcatenation.append(".Actor Classes");
            stringConcatenation.newLine();
            stringConcatenation.append("|===");
            stringConcatenation.newLine();
            stringConcatenation.append("| Name | Description");
            stringConcatenation.newLine();
            for (ActorClass c_2 : pkg.actorClasses) {
                stringConcatenation.newLine();
                stringConcatenation.append("| ");
                charSequence2 = AsciiDocGen.crossReference((RoomClass)c_2);
                stringConcatenation.append((Object)charSequence2);
                stringConcatenation.newLineIfNotEmpty();
                stringConcatenation.append("| ");
                charSequence = this.getShortDocText((EObject)c_2);
                stringConcatenation.append((Object)charSequence);
                stringConcatenation.newLineIfNotEmpty();
            }
            stringConcatenation.append("|===");
            stringConcatenation.newLine();
        }
        return stringConcatenation;
    }

    private CharSequence generateLogicalSystemDoc(LogicalSystem system, boolean includeImages) {
        CharSequence charSequence;
        StringConcatenation stringConcatenation = new StringConcatenation();
        CharSequence charSequence2 = AsciiDocGen.defineAnchor((RoomClass)system);
        stringConcatenation.append((Object)charSequence2);
        stringConcatenation.newLineIfNotEmpty();
        stringConcatenation.append("=== ");
        String string = system.getName();
        stringConcatenation.append(string);
        stringConcatenation.newLineIfNotEmpty();
        CharSequence charSequence3 = AsciiDocGen.tagStart((RoomClass)system);
        stringConcatenation.append((Object)charSequence3);
        stringConcatenation.newLineIfNotEmpty();
        stringConcatenation.newLine();
        String string2 = this.getDocText((EObject)system);
        stringConcatenation.append(string2);
        stringConcatenation.newLineIfNotEmpty();
        if (includeImages) {
            stringConcatenation.newLine();
            charSequence = this.getInstanceDiagramName(system);
            String string3 = String.valueOf(charSequence) + ".svg";
            CharSequence charSequence4 = this.includeImage(string3, true);
            stringConcatenation.append((Object)charSequence4);
            stringConcatenation.newLineIfNotEmpty();
        }
        stringConcatenation.newLine();
        charSequence = AsciiDocGen.tagEnd((RoomClass)system);
        stringConcatenation.append((Object)charSequence);
        stringConcatenation.newLineIfNotEmpty();
        return stringConcatenation;
    }

    private CharSequence generateSubSystemDoc(SubSystemClass ssc, boolean includeImages) {
        CharSequence charSequence;
        StringConcatenation stringConcatenation = new StringConcatenation();
        CharSequence charSequence2 = AsciiDocGen.defineAnchor((RoomClass)ssc);
        stringConcatenation.append((Object)charSequence2);
        stringConcatenation.newLineIfNotEmpty();
        stringConcatenation.append("=== ");
        String string = ssc.getName();
        stringConcatenation.append(string);
        stringConcatenation.newLineIfNotEmpty();
        CharSequence charSequence3 = AsciiDocGen.tagStart((RoomClass)ssc);
        stringConcatenation.append((Object)charSequence3);
        stringConcatenation.newLineIfNotEmpty();
        stringConcatenation.newLine();
        String string2 = this.getDocText((EObject)ssc);
        stringConcatenation.append(string2);
        stringConcatenation.newLineIfNotEmpty();
        if (includeImages) {
            stringConcatenation.newLine();
            charSequence = this.getDiagramName((EObject)ssc);
            String string3 = String.valueOf(charSequence) + ".jpg";
            CharSequence charSequence4 = this.includeImage(string3);
            stringConcatenation.append((Object)charSequence4);
            stringConcatenation.newLineIfNotEmpty();
        }
        charSequence = AsciiDocGen.tagEnd((RoomClass)ssc);
        stringConcatenation.append((Object)charSequence);
        stringConcatenation.newLineIfNotEmpty();
        return stringConcatenation;
    }

    private CharSequence generateEnumerationDoc(EnumerationType en) {
        boolean bl;
        StringConcatenation stringConcatenation = new StringConcatenation();
        CharSequence charSequence = AsciiDocGen.defineAnchor((RoomClass)en);
        stringConcatenation.append((Object)charSequence);
        stringConcatenation.newLineIfNotEmpty();
        stringConcatenation.append("=== ");
        String string = en.getName();
        stringConcatenation.append(string);
        stringConcatenation.newLineIfNotEmpty();
        CharSequence charSequence2 = AsciiDocGen.tagStart((RoomClass)en);
        stringConcatenation.append((Object)charSequence2);
        stringConcatenation.newLineIfNotEmpty();
        stringConcatenation.newLine();
        String string2 = this.getDocText((EObject)en);
        stringConcatenation.append(string2);
        stringConcatenation.newLineIfNotEmpty();
        stringConcatenation.newLine();
        Object object = en.getPrimitiveType();
        boolean bl2 = bl = object != null;
        if (bl) {
            stringConcatenation.append("The literals of this enumeration are based on PrimitiveType ");
            String string3 = en.getPrimitiveType().getName();
            stringConcatenation.append(string3);
            stringConcatenation.append(".");
            stringConcatenation.newLineIfNotEmpty();
        } else {
            stringConcatenation.append("The literals of this enumeration are of type int.");
            stringConcatenation.newLine();
        }
        stringConcatenation.newLine();
        stringConcatenation.append(".Literals");
        stringConcatenation.newLine();
        stringConcatenation.append("|===");
        stringConcatenation.newLine();
        stringConcatenation.append("| Name | Value | Hex Value | Binary Value");
        stringConcatenation.newLine();
        object = en.getLiterals();
        for (EnumLiteral lit : object) {
            stringConcatenation.newLine();
            stringConcatenation.append("| ");
            String string4 = lit.getName();
            stringConcatenation.append(string4);
            stringConcatenation.newLineIfNotEmpty();
            stringConcatenation.append("| ");
            long l = lit.getLiteralValue();
            stringConcatenation.append((Object)l);
            stringConcatenation.newLineIfNotEmpty();
            stringConcatenation.append("| 0x");
            String string5 = Long.toHexString(lit.getLiteralValue());
            stringConcatenation.append(string5);
            stringConcatenation.newLineIfNotEmpty();
            stringConcatenation.append("| ");
            String string6 = Long.toBinaryString(lit.getLiteralValue());
            stringConcatenation.append(string6);
            stringConcatenation.newLineIfNotEmpty();
        }
        stringConcatenation.append("|===");
        stringConcatenation.newLine();
        object = AsciiDocGen.tagEnd((RoomClass)en);
        stringConcatenation.append(object);
        stringConcatenation.newLineIfNotEmpty();
        return stringConcatenation;
    }

    private CharSequence generateDataDoc(DataClass dc) {
        boolean bl;
        StringConcatenation stringConcatenation = new StringConcatenation();
        CharSequence charSequence = AsciiDocGen.defineAnchor((RoomClass)dc);
        stringConcatenation.append((Object)charSequence);
        stringConcatenation.newLineIfNotEmpty();
        stringConcatenation.append("=== ");
        String string = dc.getName();
        stringConcatenation.append(string);
        stringConcatenation.newLineIfNotEmpty();
        CharSequence charSequence2 = AsciiDocGen.tagStart((RoomClass)dc);
        stringConcatenation.append((Object)charSequence2);
        stringConcatenation.newLineIfNotEmpty();
        stringConcatenation.newLine();
        String string2 = this.getDocText((EObject)dc);
        stringConcatenation.append(string2);
        stringConcatenation.newLineIfNotEmpty();
        stringConcatenation.newLine();
        CharSequence charSequence3 = this.generateAttributesDoc((List<Attribute>)dc.getAttributes());
        stringConcatenation.append((Object)charSequence3);
        stringConcatenation.newLineIfNotEmpty();
        boolean bl2 = dc.getOperations().isEmpty();
        boolean bl3 = bl = !bl2;
        if (bl) {
            stringConcatenation.newLine();
            CharSequence charSequence4 = this.generateOperationsDoc((List<? extends Operation>)dc.getOperations());
            stringConcatenation.append((Object)charSequence4);
            stringConcatenation.newLineIfNotEmpty();
        }
        CharSequence charSequence5 = AsciiDocGen.tagEnd((RoomClass)dc);
        stringConcatenation.append((Object)charSequence5);
        stringConcatenation.newLineIfNotEmpty();
        return stringConcatenation;
    }

    private CharSequence generateProtocolDoc(ProtocolClass pc) {
        String string;
        boolean bl;
        Object object;
        String string2;
        Iterator iterator;
        Object object2;
        boolean bl2;
        StringConcatenation stringConcatenation = new StringConcatenation();
        CharSequence charSequence = AsciiDocGen.defineAnchor((RoomClass)pc);
        stringConcatenation.append((Object)charSequence);
        stringConcatenation.newLineIfNotEmpty();
        stringConcatenation.append("=== ");
        String string3 = pc.getName();
        stringConcatenation.append(string3);
        stringConcatenation.newLineIfNotEmpty();
        CharSequence charSequence2 = AsciiDocGen.tagStart((RoomClass)pc);
        stringConcatenation.append((Object)charSequence2);
        stringConcatenation.newLineIfNotEmpty();
        stringConcatenation.newLine();
        String string4 = this.getDocText((EObject)pc);
        stringConcatenation.append(string4);
        stringConcatenation.newLineIfNotEmpty();
        boolean bl3 = this._roomHelpers.getAllIncomingMessages(pc).isEmpty();
        boolean bl4 = bl2 = !bl3;
        if (bl2) {
            stringConcatenation.newLine();
            stringConcatenation.append(".Incoming Messages");
            stringConcatenation.newLine();
            stringConcatenation.append("|===");
            stringConcatenation.newLine();
            stringConcatenation.append("| Message | Type | Description");
            stringConcatenation.newLine();
            object2 = this._roomHelpers.getAllIncomingMessages(pc);
            iterator = object2.iterator();
            while (iterator.hasNext()) {
                Message ims = (Message)iterator.next();
                stringConcatenation.newLine();
                stringConcatenation.append("| ");
                string2 = ims.getName();
                stringConcatenation.append(string2);
                stringConcatenation.newLineIfNotEmpty();
                stringConcatenation.append("| ");
                object = ims.getData();
                boolean bl5 = bl = object != null;
                if (bl) {
                    string = ims.getData().getRefType().getType().getName();
                    stringConcatenation.append(string);
                } else {
                    stringConcatenation.append("void");
                }
                stringConcatenation.newLineIfNotEmpty();
                stringConcatenation.append("a| ");
                object = this.getDocText((EObject)ims);
                stringConcatenation.append((String)object);
                stringConcatenation.newLineIfNotEmpty();
            }
            stringConcatenation.append("|===");
            stringConcatenation.newLine();
            stringConcatenation.newLine();
        }
        boolean bl6 = bl2 = !(bl3 = this._roomHelpers.getAllOutgoingMessages(pc).isEmpty());
        if (bl2) {
            stringConcatenation.newLine();
            stringConcatenation.append(".Outgoing Messages");
            stringConcatenation.newLine();
            stringConcatenation.append("|===");
            stringConcatenation.newLine();
            stringConcatenation.append("| Message | Type | Description");
            stringConcatenation.newLine();
            object2 = this._roomHelpers.getAllOutgoingMessages(pc);
            iterator = object2.iterator();
            while (iterator.hasNext()) {
                Message oms = (Message)iterator.next();
                stringConcatenation.newLine();
                stringConcatenation.append("| ");
                string2 = oms.getName();
                stringConcatenation.append(string2);
                stringConcatenation.newLineIfNotEmpty();
                stringConcatenation.append("| ");
                object = oms.getData();
                boolean bl7 = bl = object != null;
                if (bl) {
                    string = oms.getData().getRefType().getType().getName();
                    stringConcatenation.append(string);
                } else {
                    stringConcatenation.append("void");
                }
                stringConcatenation.newLineIfNotEmpty();
                stringConcatenation.append("a| ");
                object = this.getDocText((EObject)oms);
                stringConcatenation.append((String)object);
                stringConcatenation.newLineIfNotEmpty();
            }
            stringConcatenation.append("|===");
            stringConcatenation.newLine();
            stringConcatenation.newLine();
        }
        stringConcatenation.newLine();
        bl3 = this._roomHelpers.getAllOperations(pc, true).isEmpty();
        boolean bl8 = bl2 = !bl3;
        if (bl2) {
            stringConcatenation.append("[discrete]");
            stringConcatenation.newLine();
            stringConcatenation.append("==== Regular PortClass");
            stringConcatenation.newLine();
            object2 = this.generateOperationsDoc(this._roomHelpers.getAllOperations(pc, true));
            stringConcatenation.append(object2);
            stringConcatenation.newLineIfNotEmpty();
        }
        stringConcatenation.newLine();
        bl3 = this._roomHelpers.getAllOperations(pc, false).isEmpty();
        boolean bl9 = bl2 = !bl3;
        if (bl2) {
            stringConcatenation.append("[discrete]");
            stringConcatenation.newLine();
            stringConcatenation.append("==== Conjugated PortClass");
            stringConcatenation.newLine();
            object2 = this.generateOperationsDoc(this._roomHelpers.getAllOperations(pc, false));
            stringConcatenation.append(object2);
            stringConcatenation.newLineIfNotEmpty();
        }
        CharSequence charSequence3 = AsciiDocGen.tagEnd((RoomClass)pc);
        stringConcatenation.append((Object)charSequence3);
        stringConcatenation.newLineIfNotEmpty();
        return stringConcatenation;
    }

    private CharSequence generateActorDoc(ActorClass ac, boolean includeImages) {
        StringConcatenation stringConcatenation = new StringConcatenation();
        CharSequence charSequence = AsciiDocGen.defineAnchor((RoomClass)ac);
        stringConcatenation.append((Object)charSequence);
        stringConcatenation.newLineIfNotEmpty();
        stringConcatenation.append("=== ");
        String string = ac.getName();
        stringConcatenation.append(string);
        stringConcatenation.newLineIfNotEmpty();
        CharSequence charSequence2 = AsciiDocGen.tagStart((RoomClass)ac);
        stringConcatenation.append((Object)charSequence2);
        stringConcatenation.newLineIfNotEmpty();
        stringConcatenation.newLine();
        String string2 = this.getDocText((EObject)ac);
        stringConcatenation.append(string2);
        stringConcatenation.newLineIfNotEmpty();
        stringConcatenation.newLine();
        stringConcatenation.append("[discrete]");
        stringConcatenation.newLine();
        boolean bl = this._abstractGeneratorOptionsHelper.isGenerateAsLibrary(Main.getSettings());
        if (bl) {
            boolean bl2;
            stringConcatenation.append("==== Interface");
            stringConcatenation.newLine();
            boolean bl3 = this._roomHelpers.getAllInterfacePorts((ActorContainerClass)ac).isEmpty();
            boolean bl4 = bl2 = !bl3;
            if (bl2) {
                stringConcatenation.newLine();
                String string3 = this.generatePortInterfaceDoc(ac);
                stringConcatenation.append(string3);
                stringConcatenation.newLineIfNotEmpty();
            }
        } else {
            boolean bl5;
            boolean bl6;
            CharSequence charSequence3;
            stringConcatenation.append("==== Structure");
            stringConcatenation.newLine();
            if (includeImages) {
                stringConcatenation.newLine();
                String string4 = this.getDiagramName((EObject)ac);
                String string5 = String.valueOf(string4) + ".jpg";
                charSequence3 = this.includeImage(string5);
                stringConcatenation.append((Object)charSequence3);
                stringConcatenation.newLineIfNotEmpty();
            }
            boolean bl7 = bl6 = !(bl5 = this._roomHelpers.getAllPorts(ac).isEmpty());
            if (bl6) {
                stringConcatenation.newLine();
                charSequence3 = this.generatePortDoc(ac);
                stringConcatenation.append(charSequence3);
                stringConcatenation.newLineIfNotEmpty();
            }
            boolean bl8 = bl6 = !(bl5 = ac.getAttributes().isEmpty());
            if (bl6) {
                stringConcatenation.newLine();
                charSequence3 = this.generateAttributesDoc((List<Attribute>)ac.getAttributes());
                stringConcatenation.append((Object)charSequence3);
                stringConcatenation.newLineIfNotEmpty();
            }
            if (this._roomHelpers.hasNonEmptyStateMachine((ModelComponent)ac) || !ac.getOperations().isEmpty() || this._roomHelpers.isBehaviorAnnotationPresent(ac, "BehaviorManual")) {
                stringConcatenation.newLine();
                stringConcatenation.append("[discrete]");
                stringConcatenation.newLine();
                stringConcatenation.append("==== Behavior");
                stringConcatenation.newLine();
                bl5 = ac.getOperations().isEmpty();
                boolean bl9 = bl6 = !bl5;
                if (bl6) {
                    stringConcatenation.newLine();
                    charSequence3 = this.generateOperationsDoc((List<? extends Operation>)ac.getOperations());
                    stringConcatenation.append((Object)charSequence3);
                    stringConcatenation.newLineIfNotEmpty();
                }
                if (bl5 = this._roomHelpers.isBehaviorAnnotationPresent(ac, "BehaviorManual")) {
                    stringConcatenation.newLine();
                    stringConcatenation.append("The behavior for ActorClass ");
                    String string6 = ac.getName();
                    stringConcatenation.append(string6);
                    stringConcatenation.append(" is implemented manually.");
                    stringConcatenation.newLineIfNotEmpty();
                } else {
                    bl6 = this._roomHelpers.hasNonEmptyStateMachine((ModelComponent)ac);
                    if (bl6) {
                        stringConcatenation.newLine();
                        charSequence3 = this.generateFsmDoc(ac, includeImages);
                        stringConcatenation.append((Object)charSequence3);
                        stringConcatenation.newLineIfNotEmpty();
                    }
                }
            }
        }
        CharSequence charSequence4 = AsciiDocGen.tagEnd((RoomClass)ac);
        stringConcatenation.append((Object)charSequence4);
        stringConcatenation.newLineIfNotEmpty();
        return stringConcatenation;
    }

    private CharSequence generateFsmDoc(ActorClass ac, boolean includeImages) {
        StringConcatenation stringConcatenation = new StringConcatenation();
        stringConcatenation.append(".State Machine");
        stringConcatenation.newLine();
        stringConcatenation.append("Top Level State::");
        stringConcatenation.newLine();
        CharSequence charSequence = this.generateStateGraphDoc(ac, ac.getStateMachine(), includeImages, 1);
        stringConcatenation.append((Object)charSequence);
        stringConcatenation.newLineIfNotEmpty();
        return stringConcatenation;
    }

    private CharSequence generateStateGraphDoc(ActorClass ac, StateGraph stateGraph, boolean includeImages, int depth) {
        Object object;
        StringConcatenation stringConcatenation = null;
        String string = null;
        string = includeImages ? "" : "(no description)";
        String placeholderText = string;
        StringConcatenation stringConcatenation2 = new StringConcatenation();
        if (includeImages) {
            object = this.getDiagramName((EObject)stateGraph);
            String string2 = String.valueOf(object) + ".jpg";
            CharSequence charSequence = this.includeImage(string2);
            stringConcatenation2.append((Object)charSequence);
            stringConcatenation2.newLineIfNotEmpty();
        }
        object = stateGraph.getStates();
        for (State state : object) {
            boolean bl;
            if (includeImages && this._roomHelpers.isLeaf(state) && !this.hasDocText((EObject)state)) continue;
            String string3 = state.getName();
            stringConcatenation2.append(string3);
            stringConcatenation2.append("::");
            String string4 = AsciiDocGen.fill(':', depth);
            stringConcatenation2.append(string4);
            stringConcatenation2.newLineIfNotEmpty();
            stringConcatenation2.append("\t");
            CharSequence charSequence = this.docTextOrPlaceholder((EObject)state, placeholderText);
            stringConcatenation2.append((Object)charSequence, "\t");
            stringConcatenation2.newLineIfNotEmpty();
            boolean bl2 = this._roomHelpers.isLeaf(state);
            boolean bl3 = bl = !bl2;
            if (!bl) continue;
            stringConcatenation2.append("\t");
            CharSequence charSequence2 = this.generateStateGraphDoc(ac, state.getSubgraph(), includeImages, depth + 1);
            stringConcatenation2.append((Object)charSequence2, "\t");
            stringConcatenation2.newLineIfNotEmpty();
        }
        stringConcatenation = stringConcatenation2;
        return stringConcatenation;
    }

    private String generatePortInterfaceDoc(ActorClass ac) {
        StringConcatenation stringConcatenation = new StringConcatenation();
        stringConcatenation.append(".Ports");
        stringConcatenation.newLine();
        stringConcatenation.append("|===");
        stringConcatenation.newLine();
        stringConcatenation.append("| Name | Protocol | Type | Multiplicity | Description");
        stringConcatenation.newLine();
        List list = this._roomHelpers.getAllInterfacePorts((ActorContainerClass)ac);
        for (Port at : list) {
            stringConcatenation.newLine();
            stringConcatenation.append("| ");
            String string = at.getName();
            stringConcatenation.append(string);
            stringConcatenation.newLineIfNotEmpty();
            stringConcatenation.append("| ");
            String string2 = at.getProtocol().getName();
            stringConcatenation.append(string2);
            stringConcatenation.newLineIfNotEmpty();
            stringConcatenation.append("| ");
            String string3 = this.getType(at);
            stringConcatenation.append(string3);
            stringConcatenation.newLineIfNotEmpty();
            stringConcatenation.append("| ");
            String string4 = this.getMultAsText(at);
            stringConcatenation.append(string4);
            stringConcatenation.newLineIfNotEmpty();
            stringConcatenation.append("a| ");
            String string5 = this.getDocText((EObject)at);
            stringConcatenation.append(string5);
            stringConcatenation.newLineIfNotEmpty();
        }
        stringConcatenation.append("|===");
        stringConcatenation.newLine();
        return stringConcatenation.toString();
    }

    private String generatePortDoc(ActorClass ac) {
        StringConcatenation stringConcatenation = new StringConcatenation();
        stringConcatenation.append(".Ports");
        stringConcatenation.newLine();
        stringConcatenation.append("|===");
        stringConcatenation.newLine();
        stringConcatenation.append("| Name | Protocol | Type | Kind | Multiplicity | Description");
        stringConcatenation.newLine();
        List list = this._roomHelpers.getAllPorts(ac);
        for (Port at : list) {
            stringConcatenation.newLine();
            stringConcatenation.append("| ");
            String string = at.getName();
            stringConcatenation.append(string);
            stringConcatenation.newLineIfNotEmpty();
            stringConcatenation.append("| ");
            String string2 = at.getProtocol().getName();
            stringConcatenation.append(string2);
            stringConcatenation.newLineIfNotEmpty();
            stringConcatenation.append("| ");
            String string3 = this.getType(at);
            stringConcatenation.append(string3);
            stringConcatenation.newLineIfNotEmpty();
            stringConcatenation.append("| ");
            String string4 = this.getKind(at);
            stringConcatenation.append(string4);
            stringConcatenation.newLineIfNotEmpty();
            stringConcatenation.append("| ");
            String string5 = this.getMultAsText(at);
            stringConcatenation.append(string5);
            stringConcatenation.newLineIfNotEmpty();
            stringConcatenation.append("a| ");
            String string6 = this.getDocText((EObject)at);
            stringConcatenation.append(string6);
            stringConcatenation.newLineIfNotEmpty();
        }
        stringConcatenation.append("|===");
        stringConcatenation.newLine();
        return stringConcatenation.toString();
    }

    private CharSequence generateAttributesDoc(List<Attribute> attributes) {
        StringConcatenation stringConcatenation = new StringConcatenation();
        stringConcatenation.append(".Attributes");
        stringConcatenation.newLine();
        stringConcatenation.append("|===");
        stringConcatenation.newLine();
        stringConcatenation.append("| Name | Type | Description");
        stringConcatenation.newLine();
        for (Attribute at : attributes) {
            stringConcatenation.newLine();
            stringConcatenation.append("| ");
            String string = at.getName();
            stringConcatenation.append(string);
            stringConcatenation.newLineIfNotEmpty();
            stringConcatenation.append("| ");
            String string2 = at.getType().getType().getName();
            stringConcatenation.append(string2);
            stringConcatenation.newLineIfNotEmpty();
            stringConcatenation.append("a| ");
            String string3 = this.getDocText((EObject)at);
            stringConcatenation.append(string3);
            stringConcatenation.newLineIfNotEmpty();
        }
        stringConcatenation.append("|===");
        stringConcatenation.newLine();
        return stringConcatenation;
    }

    private CharSequence generateOperationsDoc(List<? extends Operation> operations) {
        StringConcatenation stringConcatenation = new StringConcatenation();
        stringConcatenation.append(".Operations");
        stringConcatenation.newLine();
        stringConcatenation.append("|===");
        stringConcatenation.newLine();
        stringConcatenation.append("| Name | Return type | Arguments | Description");
        stringConcatenation.newLine();
        boolean bl = false;
        for (Operation operation : operations) {
            boolean bl2;
            if (!bl) {
                bl = true;
            } else {
                stringConcatenation.appendImmediate((Object)"\n", "");
            }
            stringConcatenation.newLine();
            stringConcatenation.append("|");
            String string = operation.getName();
            stringConcatenation.append(string);
            stringConcatenation.newLineIfNotEmpty();
            stringConcatenation.append("| ");
            Object object = operation.getReturnType();
            boolean bl3 = bl2 = object != null;
            if (bl2) {
                String string2 = operation.getReturnType().getType().getName();
                stringConcatenation.append(string2);
            } else {
                stringConcatenation.append("void");
            }
            stringConcatenation.newLineIfNotEmpty();
            stringConcatenation.append("| ");
            object = operation.getArguments();
            bl2 = false;
            for (VarDecl pa : object) {
                if (!bl2) {
                    bl2 = true;
                } else {
                    stringConcatenation.appendImmediate((Object)", ", "");
                }
                String string3 = pa.getName();
                stringConcatenation.append(string3);
                stringConcatenation.append(": ");
                String string4 = pa.getRefType().getType().getName();
                stringConcatenation.append(string4);
            }
            stringConcatenation.newLineIfNotEmpty();
            stringConcatenation.append("a| ");
            object = this.getDocText((EObject)operation);
            stringConcatenation.append((String)object);
            stringConcatenation.newLineIfNotEmpty();
        }
        stringConcatenation.append("|===");
        stringConcatenation.newLine();
        return stringConcatenation;
    }

    private String getType(Port p) {
        String string = null;
        boolean bl = p.isConjugated();
        string = bl ? "conjugated" : "regular";
        return string;
    }

    private String getKind(Port p) {
        String string = null;
        boolean bl = this._roomHelpers.isInternal(p);
        if (bl) {
            string = "internal";
        } else {
            String string2 = null;
            boolean bl2 = this._roomHelpers.isExternal(p);
            if (bl2) {
                string2 = "external";
            } else {
                String string3 = null;
                boolean bl3 = this._roomHelpers.isRelay(p);
                string3 = bl3 ? "relay" : "?";
                string2 = string3;
            }
            string = string2;
        }
        return string;
    }

    private String getMultAsText(Port p) {
        String string = null;
        int n = p.getMultiplicity();
        boolean bl = n == -1;
        string = bl ? "*" : Integer.valueOf(p.getMultiplicity()).toString();
        return string;
    }

    private String getDocText(EObject object) {
        Object object2;
        Documentation docu;
        String string = null;
        EClass eClass = object.eClass();
        EStructuralFeature feature = eClass.getEStructuralFeature("docu");
        if (feature != null && (docu = (Documentation)(object2 = object.eGet(feature))) != null) {
            return String.join((CharSequence)"\n", (Iterable<? extends CharSequence>)docu.getLines());
        }
        String docu_1 = this.documentation(object);
        String string2 = null;
        string2 = docu_1 != null ? docu_1 : "";
        string = string2;
        return string;
    }

    private boolean hasDocText(EObject obj) {
        boolean bl = this.getDocText(obj).trim().isEmpty();
        return !bl;
    }

    private CharSequence docTextOrPlaceholder(EObject obj, CharSequence placeholder) {
        CharSequence charSequence = null;
        boolean bl = this.hasDocText(obj);
        charSequence = bl ? this.getDocText(obj) : placeholder;
        return charSequence;
    }

    private CharSequence getShortDocText(EObject object) {
        String string = null;
        String docText = this.getDocText(object);
        int index = docText.indexOf("\n");
        CharSequence charSequence = null;
        charSequence = index != -1 ? docText.subSequence(0, index) : docText;
        string = charSequence;
        return string;
    }

    private String _getDiagramName(StructureClass sc) {
        String string = null;
        String string2 = null;
        RoomModel roomModel = (RoomModel)EcoreUtil2.getContainerOfType((EObject)sc, RoomModel.class);
        String string3 = null;
        if (roomModel != null) {
            string3 = roomModel.getName();
        }
        String string4 = null;
        if (string3 != null) {
            string4 = string3.concat(".");
        }
        string2 = string4 != null ? string4 : "";
        String namespace = string2;
        String string5 = sc.getName();
        String string6 = String.valueOf(namespace) + string5;
        string = String.valueOf(string6) + "_structure";
        return string;
    }

    private String _getDiagramName(StateGraph sg) {
        String string;
        String string2 = null;
        String string3 = null;
        ModelComponent modelComponent = null;
        if (sg != null) {
            modelComponent = this._roomHelpers.getModelComponent((EObject)sg);
        }
        String string4 = null;
        if (modelComponent != null) {
            string4 = this.fsmNameProvider.getFullyQualifiedName((EObject)modelComponent);
        }
        string3 = string4 != null ? string4 : "";
        String modelComponentName = string3;
        String string5 = null;
        EObject eObject = sg.eContainer();
        if (eObject instanceof State) {
            EObject eObject2 = sg.eContainer();
            string = null;
            if ((State)eObject2 != null) {
                EObject eObject3 = sg.eContainer();
                string = this._codegenHelpers.getGenStatePathName((State)eObject3);
            }
            string5 = "." + string;
        } else {
            string5 = "";
        }
        String subStatePath = string5;
        string = modelComponentName + subStatePath;
        string2 = String.valueOf(string) + "_behavior";
        return string2;
    }

    private String getInstanceDiagramName(LogicalSystem system) {
        String string = null;
        String string2 = null;
        RoomModel roomModel = (RoomModel)EcoreUtil2.getContainerOfType((EObject)system, RoomModel.class);
        String string3 = null;
        if (roomModel != null) {
            string3 = roomModel.getName();
        }
        String string4 = null;
        if (string3 != null) {
            string4 = string3.concat(".");
        }
        string2 = string4 != null ? string4 : "";
        String namespace = string2;
        String string5 = system.getName();
        String string6 = String.valueOf(namespace) + string5;
        string = String.valueOf(string6) + "_instanceTree";
        return string;
    }

    private CharSequence includeImage(String filename) {
        return this.includeImage(filename, false);
    }

    private CharSequence includeImage(String filename, boolean limitWidth) {
        StringConcatenation stringConcatenation = null;
        String string = null;
        if (limitWidth) {
            StringConcatenation stringConcatenation2 = new StringConcatenation();
            stringConcatenation2.append("width=100%, link={imagesdir}/");
            stringConcatenation2.append(filename);
            string = stringConcatenation2.toString();
        } else {
            string = "";
        }
        String options = string;
        StringConcatenation stringConcatenation3 = new StringConcatenation();
        stringConcatenation3.append("image:");
        stringConcatenation3.append(filename);
        stringConcatenation3.append("[");
        stringConcatenation3.append(options);
        stringConcatenation3.append("]");
        stringConcatenation = stringConcatenation3;
        return stringConcatenation;
    }

    private static CharSequence crossReference(RoomClass rc) {
        return AsciiDocGen.crossReference(AsciiDocGen.getFQN(rc));
    }

    private static CharSequence crossReference(CharSequence anchor) {
        StringConcatenation stringConcatenation = new StringConcatenation();
        stringConcatenation.append("<<");
        stringConcatenation.append((Object)anchor);
        stringConcatenation.append(">>");
        return stringConcatenation;
    }

    private static CharSequence defineAnchor(RoomClass rc) {
        return AsciiDocGen.defineAnchor(AsciiDocGen.getFQN(rc));
    }

    private static CharSequence defineAnchor(CharSequence anchor) {
        StringConcatenation stringConcatenation = new StringConcatenation();
        stringConcatenation.append("[[");
        stringConcatenation.append((Object)anchor);
        stringConcatenation.append("]]");
        return stringConcatenation;
    }

    private static CharSequence getFQN(RoomClass rc) {
        StringConcatenation stringConcatenation = new StringConcatenation();
        EObject eObject = rc.eContainer();
        String string = ((RoomModel)eObject).getName();
        stringConcatenation.append(string);
        stringConcatenation.append(".");
        String string2 = rc.getName();
        stringConcatenation.append(string2);
        return stringConcatenation;
    }

    private static CharSequence tagStart(RoomClass rc) {
        StringConcatenation stringConcatenation = new StringConcatenation();
        stringConcatenation.append("// tag::");
        CharSequence charSequence = AsciiDocGen.getFQN(rc);
        stringConcatenation.append((Object)charSequence);
        stringConcatenation.append("[]");
        return stringConcatenation;
    }

    private static CharSequence tagEnd(RoomClass rc) {
        StringConcatenation stringConcatenation = new StringConcatenation();
        stringConcatenation.append("// end::");
        CharSequence charSequence = AsciiDocGen.getFQN(rc);
        stringConcatenation.append((Object)charSequence);
        stringConcatenation.append("[]");
        return stringConcatenation;
    }

    private static CharSequence tagStart(RoomPackage p) {
        StringConcatenation stringConcatenation = new StringConcatenation();
        stringConcatenation.append("// tag::");
        stringConcatenation.append(p.name);
        stringConcatenation.append("[]");
        return stringConcatenation;
    }

    private static CharSequence tagEnd(RoomPackage p) {
        StringConcatenation stringConcatenation = new StringConcatenation();
        stringConcatenation.append("// end::");
        stringConcatenation.append(p.name);
        stringConcatenation.append("[]");
        return stringConcatenation;
    }

    private static CharSequence tagStart(String name) {
        StringConcatenation stringConcatenation = new StringConcatenation();
        stringConcatenation.append("// tag::.");
        stringConcatenation.append(name);
        stringConcatenation.append("[]");
        return stringConcatenation;
    }

    private static CharSequence tagEnd(String name) {
        StringConcatenation stringConcatenation = new StringConcatenation();
        stringConcatenation.append("// end::.");
        stringConcatenation.append(name);
        stringConcatenation.append("[]");
        return stringConcatenation;
    }

    private static String fill(char c, int length) {
        String string = null;
        StringBuilder builder = new StringBuilder(length);
        int i = 0;
        while (i < length) {
            builder.append(c);
            ++i;
        }
        string = builder.toString();
        return string;
    }

    private String documentation(EObject obj) {
        String string;
        String string2 = null;
        String raw = this.eObjDocuProvider.getDocumentation(obj);
        if (raw == null) {
            return null;
        }
        String string3 = null;
        String type = string = DocumentationMarkup.getMarkupType((String)raw);
        boolean bl = false;
        boolean bl2 = Objects.equal((Object)type, (Object)"commonmark");
        if (bl2) {
            bl = true;
            StringConcatenation stringConcatenation = new StringConcatenation();
            stringConcatenation.append("++++");
            stringConcatenation.newLine();
            stringConcatenation.append("<div class=\"paragraph\"><p>");
            String string4 = CommonMarkParser.toHtml((String)DocumentationMarkup.trimMarkupTag((String)raw));
            stringConcatenation.append(string4);
            stringConcatenation.append("</p></div>");
            stringConcatenation.newLineIfNotEmpty();
            stringConcatenation.append("++++");
            stringConcatenation.newLine();
            string3 = stringConcatenation.toString();
        }
        if (!bl) {
            string3 = DocumentationMarkup.trimMarkupTag((String)raw);
        }
        string2 = string3;
        return string2;
    }

    private String getDiagramName(EObject sc) {
        if (sc instanceof StructureClass) {
            return this._getDiagramName((StructureClass)sc);
        }
        if (sc instanceof StateGraph) {
            return this._getDiagramName((StateGraph)sc);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(sc).toString());
    }

    private static class RoomPackage {
        public final String name;
        public final Iterable<LogicalSystem> systems;
        public final Iterable<SubSystemClass> subSystemClasses;
        public final Iterable<ProtocolClass> protocolClasses;
        public final Iterable<EnumerationType> enumerationTypes;
        public final Iterable<DataClass> dataClasses;
        public final Iterable<ActorClass> actorClasses;

        private RoomPackage(final String name, Iterable<RoomModel> models) {
            this.name = name;
            Functions.Function1<RoomModel, EList<RoomClass>> function1 = new Functions.Function1<RoomModel, EList<RoomClass>>(){

                public EList<RoomClass> apply(RoomModel it) {
                    return it.getRoomClasses();
                }
            };
            Iterable roomClasses = IterableExtensions.flatMap(models, (Functions.Function1)function1);
            Functions.Function1<LogicalSystem, String> function12 = new Functions.Function1<LogicalSystem, String>(){

                public String apply(LogicalSystem it) {
                    return name;
                }
            };
            this.systems = IterableExtensions.sortBy((Iterable)Iterables.filter((Iterable)roomClasses, LogicalSystem.class), (Functions.Function1)function12);
            Functions.Function1<SubSystemClass, String> function13 = new Functions.Function1<SubSystemClass, String>(){

                public String apply(SubSystemClass it) {
                    return name;
                }
            };
            this.subSystemClasses = IterableExtensions.sortBy((Iterable)Iterables.filter((Iterable)roomClasses, SubSystemClass.class), (Functions.Function1)function13);
            Functions.Function1<ProtocolClass, String> function14 = new Functions.Function1<ProtocolClass, String>(){

                public String apply(ProtocolClass it) {
                    return name;
                }
            };
            this.protocolClasses = IterableExtensions.sortBy((Iterable)Iterables.filter((Iterable)roomClasses, ProtocolClass.class), (Functions.Function1)function14);
            Functions.Function1<EnumerationType, String> function15 = new Functions.Function1<EnumerationType, String>(){

                public String apply(EnumerationType it) {
                    return name;
                }
            };
            this.enumerationTypes = IterableExtensions.sortBy((Iterable)Iterables.filter((Iterable)roomClasses, EnumerationType.class), (Functions.Function1)function15);
            Functions.Function1<DataClass, String> function16 = new Functions.Function1<DataClass, String>(){

                public String apply(DataClass it) {
                    return name;
                }
            };
            this.dataClasses = IterableExtensions.sortBy((Iterable)Iterables.filter((Iterable)roomClasses, DataClass.class), (Functions.Function1)function16);
            Functions.Function1<ActorClass, String> function17 = new Functions.Function1<ActorClass, String>(){

                public String apply(ActorClass it) {
                    return name;
                }
            };
            this.actorClasses = IterableExtensions.sortBy((Iterable)Iterables.filter((Iterable)roomClasses, ActorClass.class), (Functions.Function1)function17);
        }
    }
}

