/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.ui.common.base.support;

import java.util.ArrayList;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.IReason;
import org.eclipse.graphiti.features.IUpdateFeature;
import org.eclipse.graphiti.features.context.IUpdateContext;
import org.eclipse.graphiti.features.context.impl.UpdateContext;
import org.eclipse.graphiti.features.impl.AbstractUpdateFeature;
import org.eclipse.graphiti.features.impl.Reason;
import org.eclipse.graphiti.mm.pictograms.Connection;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.mm.pictograms.Shape;

public class AutoUpdateFeature
extends AbstractUpdateFeature {
    public AutoUpdateFeature(IFeatureProvider fp) {
        super(fp);
    }

    public boolean canUpdate(IUpdateContext context) {
        return true;
    }

    public IReason updateNeeded(IUpdateContext context) {
        boolean needed = this.updateConnectionsNeeded(this.getDiagram());
        if (this.updateNeeded((ContainerShape)this.getDiagram())) {
            needed = true;
        }
        return new Reason(needed);
    }

    private boolean updateConnectionsNeeded(Diagram diagram) {
        boolean needed = false;
        for (Connection conn : new ArrayList(diagram.getConnections())) {
            UpdateContext context = new UpdateContext((PictogramElement)conn);
            IUpdateFeature updateFeature = this.getFeatureProvider().getUpdateFeature((IUpdateContext)context);
            if (updateFeature == null || !updateFeature.canUpdate((IUpdateContext)context) || !updateFeature.updateNeeded((IUpdateContext)context).toBoolean()) continue;
            needed = true;
        }
        return needed;
    }

    private boolean updateNeeded(ContainerShape container) {
        boolean needed = false;
        for (Shape child : new ArrayList(container.getChildren())) {
            if (!(child instanceof ContainerShape) || !this.updateNeeded((ContainerShape)child)) continue;
            needed = true;
        }
        if (!(container instanceof Diagram)) {
            UpdateContext context = new UpdateContext((PictogramElement)container);
            IUpdateFeature updateFeature = this.getFeatureProvider().getUpdateFeature((IUpdateContext)context);
            if (updateFeature != null && updateFeature.canUpdate((IUpdateContext)context) && updateFeature.updateNeeded((IUpdateContext)context).toBoolean()) {
                needed = true;
            }
        }
        return needed;
    }

    public boolean update(IUpdateContext context) {
        boolean doneChanges = this.updateConnections(this.getDiagram());
        if (this.updateIfNeeded((ContainerShape)this.getDiagram())) {
            doneChanges = true;
        }
        return doneChanges;
    }

    private boolean updateConnections(Diagram diagram) {
        boolean doneChanges = false;
        ArrayList connections = new ArrayList(diagram.getConnections());
        for (Connection conn : connections) {
            UpdateContext context = new UpdateContext((PictogramElement)conn);
            IUpdateFeature updateFeature = this.getFeatureProvider().getUpdateFeature((IUpdateContext)context);
            if (updateFeature == null || !updateFeature.canUpdate((IUpdateContext)context) || !updateFeature.updateNeeded((IUpdateContext)context).toBoolean() || !updateFeature.update((IUpdateContext)context)) continue;
            doneChanges = true;
        }
        return doneChanges;
    }

    private boolean updateIfNeeded(ContainerShape container) {
        boolean doneChanges = false;
        ArrayList children = new ArrayList(container.getChildren());
        for (Shape child : children) {
            if (!(child instanceof ContainerShape) || !this.updateIfNeeded((ContainerShape)child)) continue;
            doneChanges = true;
        }
        if (!(container instanceof Diagram)) {
            UpdateContext context = new UpdateContext((PictogramElement)container);
            IUpdateFeature updateFeature = this.getFeatureProvider().getUpdateFeature((IUpdateContext)context);
            if (updateFeature != null && updateFeature.canUpdate((IUpdateContext)context) && updateFeature.updateNeeded((IUpdateContext)context).toBoolean() && updateFeature.update((IUpdateContext)context)) {
                doneChanges = true;
            }
        }
        return doneChanges;
    }
}

