/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.ui.structure.support;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.etrice.core.room.ActorContainerClass;
import org.eclipse.etrice.core.room.ActorContainerRef;
import org.eclipse.etrice.core.room.LayerConnection;
import org.eclipse.etrice.core.room.RefSAPoint;
import org.eclipse.etrice.core.room.RelaySAPoint;
import org.eclipse.etrice.core.room.RoomFactory;
import org.eclipse.etrice.core.room.SAPoint;
import org.eclipse.etrice.core.room.SPP;
import org.eclipse.etrice.core.room.SPPoint;
import org.eclipse.etrice.core.room.StructureClass;
import org.eclipse.etrice.ui.common.base.support.BaseToolBehaviorProvider;
import org.eclipse.etrice.ui.common.base.support.CantRemoveFeature;
import org.eclipse.etrice.ui.common.base.support.ChangeAwareCreateConnectionFeature;
import org.eclipse.etrice.ui.common.base.support.DeleteWithoutConfirmFeature;
import org.eclipse.etrice.ui.structure.support.SupportUtil;
import org.eclipse.etrice.ui.structure.support.context.ConnectionUpdateContext;
import org.eclipse.etrice.ui.structure.support.context.InitialAddConnectionContext;
import org.eclipse.etrice.ui.structure.support.feature.ConnectionUpdateFeature;
import org.eclipse.etrice.ui.structure.support.provider.ConnectionProvider;
import org.eclipse.graphiti.dt.IDiagramTypeProvider;
import org.eclipse.graphiti.features.IAddBendpointFeature;
import org.eclipse.graphiti.features.IAddFeature;
import org.eclipse.graphiti.features.ICreateConnectionFeature;
import org.eclipse.graphiti.features.IDeleteFeature;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.IMoveBendpointFeature;
import org.eclipse.graphiti.features.IReconnectionFeature;
import org.eclipse.graphiti.features.IRemoveBendpointFeature;
import org.eclipse.graphiti.features.IRemoveFeature;
import org.eclipse.graphiti.features.IUpdateFeature;
import org.eclipse.graphiti.features.context.IAddBendpointContext;
import org.eclipse.graphiti.features.context.IAddConnectionContext;
import org.eclipse.graphiti.features.context.IAddContext;
import org.eclipse.graphiti.features.context.ICreateConnectionContext;
import org.eclipse.graphiti.features.context.IDeleteContext;
import org.eclipse.graphiti.features.context.IMoveBendpointContext;
import org.eclipse.graphiti.features.context.IReconnectionContext;
import org.eclipse.graphiti.features.context.IRemoveBendpointContext;
import org.eclipse.graphiti.features.context.IRemoveContext;
import org.eclipse.graphiti.features.context.IUpdateContext;
import org.eclipse.graphiti.features.context.impl.AddConnectionContext;
import org.eclipse.graphiti.features.context.impl.ReconnectionContext;
import org.eclipse.graphiti.features.impl.AbstractAddFeature;
import org.eclipse.graphiti.features.impl.DefaultAddBendpointFeature;
import org.eclipse.graphiti.features.impl.DefaultMoveBendpointFeature;
import org.eclipse.graphiti.features.impl.DefaultReconnectionFeature;
import org.eclipse.graphiti.features.impl.DefaultRemoveBendpointFeature;
import org.eclipse.graphiti.mm.GraphicsAlgorithmContainer;
import org.eclipse.graphiti.mm.PropertyContainer;
import org.eclipse.graphiti.mm.algorithms.Polyline;
import org.eclipse.graphiti.mm.pictograms.Anchor;
import org.eclipse.graphiti.mm.pictograms.Connection;
import org.eclipse.graphiti.mm.pictograms.ConnectionDecorator;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.graphiti.mm.pictograms.FreeFormConnection;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.graphiti.services.IGaService;
import org.eclipse.graphiti.services.IPeCreateService;
import org.eclipse.graphiti.tb.IToolBehaviorProvider;
import org.eclipse.graphiti.ui.features.DefaultFeatureProvider;
import org.eclipse.graphiti.util.ColorConstant;
import org.eclipse.graphiti.util.IColorConstant;

public class LayerConnectionSupport {
    private static final IColorConstant LINE_COLOR = new ColorConstant(0, 0, 0);
    private static final int LINE_WIDTH = 2;
    private FeatureProvider pfp;
    private BehaviorProvider tbp;

    public LayerConnectionSupport(IDiagramTypeProvider dtp, IFeatureProvider fp) {
        this.pfp = new FeatureProvider(dtp, fp);
        this.tbp = new BehaviorProvider(dtp);
    }

    public IFeatureProvider getFeatureProvider() {
        return this.pfp;
    }

    public IToolBehaviorProvider getToolBehaviorProvider() {
        return this.tbp;
    }

    class BehaviorProvider
    extends BaseToolBehaviorProvider {
        public BehaviorProvider(IDiagramTypeProvider dtp) {
            super(dtp);
        }
    }

    class FeatureProvider
    extends DefaultFeatureProvider {
        private IFeatureProvider fp;

        public FeatureProvider(IDiagramTypeProvider dtp, IFeatureProvider fp) {
            super(dtp);
            this.fp = fp;
        }

        private boolean isInherited(Diagram diag, LayerConnection lc) {
            ActorContainerClass acc = (ActorContainerClass)Graphiti.getLinkService().getBusinessObjectForLinkedPictogramElement((PictogramElement)diag.getChildren().get(0));
            return lc.eContainer() != acc;
        }

        public ICreateConnectionFeature[] getCreateConnectionFeatures() {
            return new ICreateConnectionFeature[]{new CreateFeature(this.fp)};
        }

        public IAddFeature getAddFeature(IAddContext context) {
            return new AddFeature(this.fp);
        }

        public IRemoveFeature getRemoveFeature(IRemoveContext context) {
            return new CantRemoveFeature(this.fp);
        }

        public IDeleteFeature getDeleteFeature(IDeleteContext context) {
            return new DeleteFeature(this.fp);
        }

        public IUpdateFeature getUpdateFeature(IUpdateContext context) {
            return new UpdateFeature(this.fp);
        }

        public IReconnectionFeature getReconnectionFeature(IReconnectionContext context) {
            return new ReconnectionFeature(this.fp);
        }

        public IMoveBendpointFeature getMoveBendpointFeature(IMoveBendpointContext context) {
            MoveBendpointFeature ret = new MoveBendpointFeature(this.fp);
            return ret;
        }

        public IAddBendpointFeature getAddBendpointFeature(IAddBendpointContext context) {
            AddBendpointFeature ret = new AddBendpointFeature(this.fp);
            return ret;
        }

        public IRemoveBendpointFeature getRemoveBendpointFeature(IRemoveBendpointContext context) {
            RemoveBendpointFeature ret = new RemoveBendpointFeature(this.fp);
            return ret;
        }

        private class AddBendpointFeature
        extends DefaultAddBendpointFeature {
            public AddBendpointFeature(IFeatureProvider fp) {
                super(fp);
            }

            public boolean canAddBendpoint(IAddBendpointContext context) {
                EObject bo = Graphiti.getLinkService().getBusinessObjectForLinkedPictogramElement((PictogramElement)context.getConnection());
                if (bo instanceof LayerConnection) {
                    LayerConnection lc = (LayerConnection)bo;
                    if (!FeatureProvider.this.isInherited(this.getDiagram(), lc)) {
                        return true;
                    }
                }
                return false;
            }
        }

        private class AddFeature
        extends AbstractAddFeature {
            public AddFeature(IFeatureProvider fp) {
                super(fp);
            }

            public boolean canAdd(IAddContext context) {
                return context.getNewObject() instanceof LayerConnection;
            }

            public PictogramElement add(IAddContext context) {
                LayerConnection lc = (LayerConnection)context.getNewObject();
                IPeCreateService peCreateService = Graphiti.getPeCreateService();
                Connection connection = this.createConnection();
                if (context instanceof InitialAddConnectionContext) {
                    ConnectionProvider cp = ((InitialAddConnectionContext)context).getConnectionProvider();
                    Anchor a1 = cp.getAnchor(lc.getFrom());
                    Anchor a2 = cp.getAnchor(lc.getTo());
                    assert (a1 != null && a2 != null) : "start and end anchor must be present";
                    connection.setStart(a1);
                    connection.setEnd(a2);
                } else {
                    IAddConnectionContext addConContext = (IAddConnectionContext)context;
                    connection.setStart(addConContext.getSourceAnchor());
                    connection.setEnd(addConContext.getTargetAnchor());
                }
                Graphiti.getPeService().setPropertyValue((PropertyContainer)connection, "obj-type", "conn");
                IGaService gaService = Graphiti.getGaService();
                Polyline polyline = gaService.createPolyline((GraphicsAlgorithmContainer)connection);
                polyline.setForeground(this.manageColor(LINE_COLOR));
                polyline.setLineWidth(Integer.valueOf(2));
                ConnectionDecorator cd = peCreateService.createConnectionDecorator(connection, false, 1.0, true);
                this.createArrow((GraphicsAlgorithmContainer)cd);
                this.link((PictogramElement)connection, lc);
                this.updatePictogramElement((PictogramElement)connection);
                return connection;
            }

            private Connection createConnection() {
                IPeCreateService peCreateService = Graphiti.getPeCreateService();
                FreeFormConnection ret = peCreateService.createFreeFormConnection(this.getDiagram());
                ret.setVisible(true);
                ret.setActive(true);
                ret.setParent(this.getDiagram());
                return ret;
            }

            private Polyline createArrow(GraphicsAlgorithmContainer gaContainer) {
                IGaService gaService = Graphiti.getGaService();
                int[] nArray = new int[6];
                nArray[0] = -15;
                nArray[1] = 10;
                nArray[4] = -15;
                nArray[5] = -10;
                Polyline polyline = gaService.createPolyline(gaContainer, nArray);
                polyline.setForeground(this.manageColor(LINE_COLOR));
                polyline.setLineWidth(Integer.valueOf(2));
                return polyline;
            }
        }

        private class CreateFeature
        extends ChangeAwareCreateConnectionFeature {
            public CreateFeature(IFeatureProvider fp) {
                super(fp, "LayerConnection", "create LayerConnection");
            }

            public String getCreateImageId() {
                return "org.eclipse.etrice.ui.structure.layer_connection";
            }

            public boolean canCreate(ICreateConnectionContext context) {
                IFeatureProvider featureProvider = this.getFeatureProvider();
                SPP src = SupportUtil.getInstance().getSPP(context.getSourceAnchor(), featureProvider);
                ActorContainerRef srcRef = SupportUtil.getInstance().getRef(context.getSourceAnchor(), featureProvider);
                SPP tgt = SupportUtil.getInstance().getSPP(context.getTargetAnchor(), featureProvider);
                ActorContainerRef tgtRef = SupportUtil.getInstance().getRef(context.getTargetAnchor(), featureProvider);
                StructureClass sc = SupportUtil.getInstance().getParent(context, featureProvider);
                return SupportUtil.getInstance().getValidationUtil().isConnectable(src, srcRef, tgt, tgtRef, sc).isOk();
            }

            public boolean canStartConnection(ICreateConnectionContext context) {
                IFeatureProvider featureProvider = this.getFeatureProvider();
                SPP src = SupportUtil.getInstance().getSPP(context.getSourceAnchor(), featureProvider);
                ActorContainerRef ref = SupportUtil.getInstance().getRef(context.getSourceAnchor(), featureProvider);
                StructureClass sc = SupportUtil.getInstance().getParent(context, featureProvider);
                return SupportUtil.getInstance().getValidationUtil().isConnectableSrc(src, ref, sc);
            }

            protected Connection doCreate(ICreateConnectionContext context) {
                IFeatureProvider featureProvider = this.getFeatureProvider();
                SPP src = SupportUtil.getInstance().getSPP(context.getSourceAnchor(), featureProvider);
                ActorContainerRef srcRef = SupportUtil.getInstance().getRef(context.getSourceAnchor(), featureProvider);
                SPP dst = SupportUtil.getInstance().getSPP(context.getTargetAnchor(), featureProvider);
                ActorContainerRef dstRef = SupportUtil.getInstance().getRef(context.getTargetAnchor(), featureProvider);
                StructureClass sc = SupportUtil.getInstance().getParent(context, featureProvider);
                LayerConnection lc = RoomFactory.eINSTANCE.createLayerConnection();
                RelaySAPoint sapt = null;
                if (src != null) {
                    sapt = RoomFactory.eINSTANCE.createRelaySAPoint();
                    sapt.setRelay(src);
                } else if (srcRef != null) {
                    sapt = RoomFactory.eINSTANCE.createRefSAPoint();
                    ((RefSAPoint)sapt).setRef(srcRef);
                }
                lc.setFrom((SAPoint)sapt);
                SPPoint sppt = RoomFactory.eINSTANCE.createSPPoint();
                sppt.setRef(dstRef);
                sppt.setService(dst);
                lc.setTo(sppt);
                sc.getConnections().add((Object)lc);
                AddConnectionContext addContext = new AddConnectionContext(context.getSourceAnchor(), context.getTargetAnchor());
                addContext.setNewObject((Object)lc);
                return (Connection)this.getFeatureProvider().addIfPossible((IAddContext)addContext);
            }
        }

        private class DeleteFeature
        extends DeleteWithoutConfirmFeature {
            public DeleteFeature(IFeatureProvider fp) {
                super(fp);
            }

            public boolean canDelete(IDeleteContext context) {
                EObject bo = Graphiti.getLinkService().getBusinessObjectForLinkedPictogramElement(context.getPictogramElement());
                if (bo instanceof LayerConnection) {
                    LayerConnection lc = (LayerConnection)bo;
                    if (FeatureProvider.this.isInherited(this.getDiagram(), lc)) {
                        return false;
                    }
                }
                return true;
            }
        }

        private class MoveBendpointFeature
        extends DefaultMoveBendpointFeature {
            public MoveBendpointFeature(IFeatureProvider fp) {
                super(fp);
            }

            public boolean canMoveBendpoint(IMoveBendpointContext context) {
                EObject bo = Graphiti.getLinkService().getBusinessObjectForLinkedPictogramElement((PictogramElement)context.getConnection());
                if (bo instanceof LayerConnection) {
                    LayerConnection lc = (LayerConnection)bo;
                    if (!FeatureProvider.this.isInherited(this.getDiagram(), lc)) {
                        return true;
                    }
                }
                return false;
            }
        }

        private class ReconnectionFeature
        extends DefaultReconnectionFeature {
            private boolean doneChanges;

            public ReconnectionFeature(IFeatureProvider fp) {
                super(fp);
                this.doneChanges = false;
            }

            public boolean canReconnect(IReconnectionContext context) {
                if (!super.canReconnect(context)) {
                    return false;
                }
                LayerConnection lc = (LayerConnection)this.getBusinessObjectForPictogramElement((PictogramElement)context.getConnection());
                if (FeatureProvider.this.isInherited(this.getDiagram(), lc)) {
                    return false;
                }
                Anchor asrc = context.getConnection().getStart();
                Anchor atgt = context.getConnection().getEnd();
                if (context.getReconnectType().equals(ReconnectionContext.RECONNECT_SOURCE)) {
                    asrc = context.getNewAnchor();
                } else {
                    atgt = context.getNewAnchor();
                }
                IFeatureProvider featureProvider = this.getFeatureProvider();
                SPP src = SupportUtil.getInstance().getSPP(asrc, featureProvider);
                ActorContainerRef srcRef = SupportUtil.getInstance().getRef(asrc, featureProvider);
                SPP tgt = SupportUtil.getInstance().getSPP(atgt, featureProvider);
                ActorContainerRef tgtRef = SupportUtil.getInstance().getRef(atgt, featureProvider);
                StructureClass sc = SupportUtil.getInstance().getParent((ContainerShape)this.getDiagram(), featureProvider);
                return SupportUtil.getInstance().getValidationUtil().isConnectable(src, srcRef, tgt, tgtRef, sc).isOk();
            }

            public void postReconnect(IReconnectionContext context) {
                super.postReconnect(context);
                IFeatureProvider featureProvider = this.getFeatureProvider();
                SPP src = SupportUtil.getInstance().getSPP(context.getConnection().getStart(), featureProvider);
                ActorContainerRef srcRef = SupportUtil.getInstance().getRef(context.getConnection().getStart(), featureProvider);
                SPP dst = SupportUtil.getInstance().getSPP(context.getConnection().getEnd(), featureProvider);
                ActorContainerRef dstRef = SupportUtil.getInstance().getRef(context.getConnection().getEnd(), featureProvider);
                this.doneChanges = true;
                LayerConnection lc = (LayerConnection)this.getBusinessObjectForPictogramElement((PictogramElement)context.getConnection());
                RelaySAPoint sapt = null;
                if (src != null) {
                    sapt = RoomFactory.eINSTANCE.createRelaySAPoint();
                    sapt.setRelay(src);
                } else if (srcRef != null) {
                    sapt = RoomFactory.eINSTANCE.createRefSAPoint();
                    ((RefSAPoint)sapt).setRef(srcRef);
                }
                lc.setFrom((SAPoint)sapt);
                SPPoint sppt = RoomFactory.eINSTANCE.createSPPoint();
                sppt.setRef(dstRef);
                sppt.setService(dst);
                lc.setTo(sppt);
            }

            public boolean hasDoneChanges() {
                return this.doneChanges;
            }
        }

        private class RemoveBendpointFeature
        extends DefaultRemoveBendpointFeature {
            public RemoveBendpointFeature(IFeatureProvider fp) {
                super(fp);
            }

            public boolean canRemoveBendpoint(IRemoveBendpointContext context) {
                EObject bo = Graphiti.getLinkService().getBusinessObjectForLinkedPictogramElement((PictogramElement)context.getConnection());
                if (bo instanceof LayerConnection) {
                    LayerConnection lc = (LayerConnection)bo;
                    if (!FeatureProvider.this.isInherited(this.getDiagram(), lc)) {
                        return true;
                    }
                }
                return false;
            }
        }

        private class UpdateFeature
        extends ConnectionUpdateFeature {
            public UpdateFeature(IFeatureProvider fp) {
                super(fp);
            }

            @Override
            protected boolean canUpdate(EObject bo, PictogramElement pe) {
                return bo instanceof LayerConnection;
            }

            @Override
            protected boolean update(EObject bo, IUpdateContext context) {
                boolean success = super.update(bo, context);
                Connection conn = (Connection)context.getPictogramElement();
                if (context instanceof ConnectionUpdateContext) {
                    ConnectionProvider cp = ((ConnectionUpdateContext)context).getConnectionProvider();
                    LayerConnection lc = (LayerConnection)bo;
                    Anchor newStart = cp.getAnchor(lc.getFrom());
                    Anchor newEnd = cp.getAnchor(lc.getTo());
                    assert (newStart != null && newEnd != null) : "start and end anchor must be not null";
                    if (newStart != conn.getStart()) {
                        conn.setStart(newEnd);
                    }
                    if (newEnd != conn.getEnd()) {
                        conn.setEnd(newEnd);
                    }
                }
                return success;
            }
        }
    }
}

