/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.doc;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.help.HelpSystem;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.PlatformUI;

public class ContextHelpProvider {
    public static final String ID_PREFIX = "featureContextHelp_";
    public static final String HELP_SYSTEM_ID_PREFIX = "org.eclipse.etrice.doc.featureContextHelp_";
    private static final Map<String, String> featureMapping = new HashMap<String, String>();

    static {
        featureMapping.put("RoomEditor", "TextualROOMEditor");
        featureMapping.put("StructureEditor", "GraphicalStructureEditor");
        featureMapping.put("BehaviorEditor", "GraphicalBehaviorEditor");
    }

    public static String getContextId(String featureId) {
        String mappedFeatureId = featureMapping.get(featureId);
        return HELP_SYSTEM_ID_PREFIX + (mappedFeatureId != null ? mappedFeatureId : featureId);
    }

    public static void setHelp(Control control, String featureId) {
        PlatformUI.getWorkbench().getHelpSystem().setHelp(control, HELP_SYSTEM_ID_PREFIX + featureId);
    }

    public static void showHelp(String featureId) {
        PlatformUI.getWorkbench().getHelpSystem().displayHelp(HELP_SYSTEM_ID_PREFIX + featureId);
    }

    public static boolean isAvailable(String featureId) {
        if (featureId == null || featureId.equals("")) {
            return false;
        }
        return HelpSystem.getContext((String)(HELP_SYSTEM_ID_PREFIX + featureId)) != null;
    }
}

