/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.manipulation.internal.javadoc;

import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.AbstractTextElement;
import org.eclipse.jdt.core.dom.JavaDocRegion;
import org.eclipse.jdt.core.dom.MemberRef;
import org.eclipse.jdt.core.dom.MethodRef;
import org.eclipse.jdt.core.dom.MethodRefParameter;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.TagElement;
import org.eclipse.jdt.core.dom.TagProperty;
import org.eclipse.jdt.internal.core.manipulation.JavaManipulationPlugin;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.ui.viewsupport.CoreJavaElementLinks;

public class CoreJavaDocSnippetStringEvaluator {
    private final IJavaElement fElement;

    public CoreJavaDocSnippetStringEvaluator(IJavaElement element) {
        this.fElement = element;
    }

    public void AddTagElementString(TagElement snippetTag, StringBuffer buffer) {
        if (snippetTag != null) {
            List fragments = snippetTag.fragments();
            for (Object fragment : fragments) {
                buffer.append(this.getOneTagElementString(snippetTag, fragment));
            }
        }
    }

    protected String getOneTagElementString(TagElement snippetTag, Object fragment) {
        String str = "";
        if (fragment instanceof AbstractTextElement) {
            AbstractTextElement textElement = (AbstractTextElement)fragment;
            List<TagElement> tagElements = this.getTagElementsForTextElement(snippetTag, textElement);
            str = this.getModifiedString(textElement, tagElements);
        } else if (fragment instanceof JavaDocRegion) {
            JavaDocRegion region = (JavaDocRegion)fragment;
            if (region.isDummyRegion()) {
                List<TagElement> tagElements = this.getTagElementsForDummyJavaDocRegion(snippetTag, region);
                str = this.getModifiedString(region, tagElements);
            }
        } else if (fragment instanceof TagElement) {
            TagElement tagElement = (TagElement)fragment;
            List<TagElement> tagElements = this.getTagElementsForTagElement(snippetTag, tagElement);
            str = this.getModifiedStringForTagElement(tagElement, tagElements);
        }
        return str;
    }

    protected String getModifiedStringForTagElement(TagElement tagElement, List<TagElement> tagElements) {
        return this.getModifiedString(tagElement, tagElements);
    }

    protected String getModifiedString(AbstractTextElement textElement, List<TagElement> tags) {
        return this.getModifiedString(textElement.getText(), tags);
    }

    protected String getModifiedString(TagElement tagElement, List<TagElement> tags) {
        return this.getModifiedString(((AbstractTextElement)tagElement.fragments().get(0)).getText(), tags);
    }

    protected String getModifiedString(JavaDocRegion region, List<TagElement> tags) {
        return this.getModifiedString(((AbstractTextElement)region.fragments().get(0)).getText(), tags);
    }

    protected String getModifiedString(String str, List<TagElement> tags) {
        ArrayList<ActionElement> actionElements = new ArrayList<ActionElement>();
        String modifiedStr = str;
        for (TagElement tag : tags) {
            String name = tag.getTagName();
            if ("@highlight".equals(name)) {
                this.handleSnippetHighlight(modifiedStr, tag, actionElements);
                continue;
            }
            if ("@replace".equals(name)) {
                modifiedStr = this.handleSnippetReplace(modifiedStr, tag, actionElements);
                continue;
            }
            if (!"@link".equals(name)) continue;
            this.handleSnippetLink(modifiedStr, tag, actionElements);
        }
        return this.getString(modifiedStr, actionElements);
    }

    private String getString(String str, List<ActionElement> actionElements) {
        Object modifiedStr = str.replaceAll(">", "&gt;");
        modifiedStr = ((String)modifiedStr).replaceAll("<", "&lt;");
        ArrayList<StringItem> items = new ArrayList<StringItem>();
        for (ActionElement actElem : actionElements) {
            StringItem startItem = new StringItem(actElem.start, actElem.startTag);
            StringItem endItem = new StringItem(actElem.end, actElem.endTag);
            ListIterator<StringItem> iterator = items.listIterator();
            boolean endIndexAdded = false;
            boolean startIndexAdded = false;
            while (iterator.hasNext()) {
                StringItem elem = (StringItem)iterator.next();
                if (!endIndexAdded && elem.index < endItem.index) {
                    iterator.previous();
                    iterator.add(endItem);
                    endIndexAdded = true;
                    iterator.next();
                }
                if (!startIndexAdded && elem.index < startItem.index) {
                    iterator.previous();
                    iterator.add(startItem);
                    startIndexAdded = true;
                    iterator.next();
                }
                if (startIndexAdded && endIndexAdded) break;
            }
            if (!endIndexAdded) {
                items.add(endItem);
            }
            if (startIndexAdded) continue;
            items.add(startItem);
        }
        for (StringItem item : items) {
            modifiedStr = ((String)modifiedStr).substring(0, item.index) + item.tag + ((String)modifiedStr).substring(item.index);
        }
        return modifiedStr;
    }

    private void modifyPrevActionItemsReplacement(int replacementIntervalStart, int relacementIntervalEnd, int replacementStrNewLength, List<ActionElement> actionElements) {
        ListIterator<ActionElement> iterator = actionElements.listIterator();
        int oldLength = relacementIntervalEnd - replacementIntervalStart;
        int diff = replacementStrNewLength - oldLength;
        while (iterator.hasNext()) {
            ActionElement elem = iterator.next();
            ReplacementStringIntervalStatus intervalStatus = elem.getIntervalStatus(replacementIntervalStart, relacementIntervalEnd);
            switch (intervalStatus) {
                case AFTER: {
                    break;
                }
                case BEFORE: {
                    if (diff == 0) break;
                    elem.start += diff;
                    elem.end += diff;
                    break;
                }
                case ENCOMPASS: {
                    iterator.remove();
                    break;
                }
                case POST_OVERLAP: {
                    elem.end = replacementIntervalStart;
                    break;
                }
                case PREV_OVERLAP: {
                    elem.end += diff;
                    elem.start = relacementIntervalEnd + diff;
                    break;
                }
                case WITHIN: {
                    int newEnd = elem.end + diff;
                    elem.end = replacementIntervalStart;
                    int newStart = relacementIntervalEnd + diff;
                    ActionElement newElem = new ActionElement(newStart, newEnd, elem.startTag, elem.endTag);
                    iterator.add(newElem);
                    break;
                }
            }
        }
    }

    private List<TagElement> getTagElementsForTextElement(TagElement snippetTag, AbstractTextElement textElement) {
        ArrayList<TagElement> tagElements = new ArrayList<TagElement>();
        List regions = snippetTag.tagRegionsStartingAtTextElement((ASTNode)textElement);
        List masterList = snippetTag.tagRegionsContainingTextElement((ASTNode)textElement);
        masterList.removeAll(regions);
        for (JavaDocRegion region : masterList) {
            for (Object tagObj : region.tags()) {
                tagElements.add((TagElement)tagObj);
            }
        }
        for (JavaDocRegion region : regions) {
            for (Object tagObj : region.tags()) {
                TagElement tagElem;
                Object prop;
                if (!(tagObj instanceof TagElement) || !((prop = (tagElem = (TagElement)tagObj).getProperty("SnippetInlineTagCount")) instanceof Integer)) continue;
                int val = (Integer)prop;
                ListIterator listIterator = tagElements.listIterator();
                TagElement addBefore = null;
                while (listIterator.hasNext()) {
                    int val2;
                    TagElement tElem = (TagElement)listIterator.next();
                    Object prop2 = tElem.getProperty("SnippetInlineTagCount");
                    if (!(prop2 instanceof Integer) || (val2 = ((Integer)prop2).intValue()) <= val) continue;
                    addBefore = tElem;
                    break;
                }
                if (addBefore == null) {
                    tagElements.add(tagElem);
                    continue;
                }
                tagElements.add(tagElements.indexOf(addBefore), tagElem);
            }
        }
        return tagElements;
    }

    private List<TagElement> getTagElementsForDummyJavaDocRegion(TagElement snippetTag, JavaDocRegion javaDocRegion) {
        ArrayList<TagElement> tagElements = new ArrayList<TagElement>();
        AbstractTextElement textElement = (AbstractTextElement)javaDocRegion.fragments().get(0);
        List regions = snippetTag.tagRegionsStartingAtTextElement((ASTNode)textElement);
        List masterList = snippetTag.tagRegionsContainingTextElement((ASTNode)textElement);
        masterList.removeAll(regions);
        for (JavaDocRegion region : masterList) {
            for (Object tagObj : region.tags()) {
                tagElements.add((TagElement)tagObj);
            }
        }
        regions.add(javaDocRegion);
        for (JavaDocRegion region : regions) {
            for (Object tagObj : region.tags()) {
                TagElement tagElem;
                Object prop;
                if (!(tagObj instanceof TagElement) || !((prop = (tagElem = (TagElement)tagObj).getProperty("SnippetInlineTagCount")) instanceof Integer)) continue;
                int val = (Integer)prop;
                ListIterator listIterator = tagElements.listIterator();
                TagElement addBefore = null;
                while (listIterator.hasNext()) {
                    int val2;
                    TagElement tElem = (TagElement)listIterator.next();
                    Object prop2 = tElem.getProperty("SnippetInlineTagCount");
                    if (!(prop2 instanceof Integer) || (val2 = ((Integer)prop2).intValue()) <= val) continue;
                    addBefore = tElem;
                    break;
                }
                if (addBefore == null) {
                    tagElements.add(tagElem);
                    continue;
                }
                tagElements.add(tagElements.indexOf(addBefore), tagElem);
            }
        }
        return tagElements;
    }

    private List<TagElement> getTagElementsForTagElement(TagElement snippetTag, TagElement tag) {
        ArrayList<TagElement> tagElements = new ArrayList<TagElement>();
        AbstractTextElement textElement = (AbstractTextElement)tag.fragments().get(0);
        List regions = snippetTag.tagRegionsStartingAtTextElement((ASTNode)textElement);
        List masterList = snippetTag.tagRegionsContainingTextElement((ASTNode)textElement);
        masterList.removeAll(regions);
        for (JavaDocRegion region : masterList) {
            for (Object tagObj : region.tags()) {
                tagElements.add((TagElement)tagObj);
            }
        }
        for (JavaDocRegion region : regions) {
            for (Object tagObj : region.tags()) {
                TagElement tagElem;
                Object prop;
                if (!(tagObj instanceof TagElement) || !((prop = (tagElem = (TagElement)tagObj).getProperty("SnippetInlineTagCount")) instanceof Integer)) continue;
                int val = (Integer)prop;
                ListIterator listIterator = tagElements.listIterator();
                TagElement addBefore = null;
                while (listIterator.hasNext()) {
                    int val2;
                    TagElement tElem = (TagElement)listIterator.next();
                    Object prop2 = tElem.getProperty("SnippetInlineTagCount");
                    if (!(prop2 instanceof Integer) || (val2 = ((Integer)prop).intValue()) <= val) continue;
                    addBefore = tElem;
                    break;
                }
                if (addBefore == null) {
                    tagElements.add(tagElem);
                    continue;
                }
                tagElements.add(tagElements.indexOf(addBefore), tagElem);
            }
        }
        Object prop3 = tag.getProperty("SnippetInlineTagCount");
        if (prop3 instanceof Integer) {
            int val = (Integer)prop3;
            ListIterator listIterator = tagElements.listIterator();
            TagElement addBefore = null;
            while (listIterator.hasNext()) {
                int val2;
                TagElement tElem = (TagElement)listIterator.next();
                Object prop2 = tElem.getProperty("SnippetInlineTagCount");
                if (!(prop2 instanceof Integer) || (val2 = ((Integer)prop2).intValue()) <= val) continue;
                addBefore = tElem;
                break;
            }
            if (addBefore == null) {
                tagElements.add(tag);
            } else {
                tagElements.add(tagElements.indexOf(addBefore), tag);
            }
        }
        return tagElements;
    }

    protected String getStartTag(String tag) {
        return "<" + tag + ">";
    }

    protected String getEndTag(String tag) {
        return "</" + tag + ">";
    }

    private void handleSnippetHighlight(String text, TagElement tagElement, List<ActionElement> actionElements) {
        try {
            List tagProperties = tagElement.tagProperties();
            String defHighlight = this.getHighlightHtmlTag(tagProperties);
            String startDefHighlight = this.getStartTag(defHighlight);
            String endDefHighlight = this.getEndTag(defHighlight);
            String regExValue = this.getPropertyValue("regex", tagProperties);
            String subStringValue = this.getPropertyValue("substring", tagProperties);
            Pattern regexPattern = null;
            if (regExValue != null) {
                regexPattern = Pattern.compile(regExValue);
            }
            if (regexPattern != null) {
                Matcher matcher = regexPattern.matcher(text);
                while (matcher.find()) {
                    actionElements.add(new ActionElement(matcher.start(), matcher.end(), startDefHighlight, endDefHighlight));
                }
            } else if (subStringValue != null) {
                int startIndex = 0;
                while ((startIndex = text.indexOf(subStringValue, startIndex)) != -1) {
                    actionElements.add(new ActionElement(startIndex, startIndex + subStringValue.length(), startDefHighlight, endDefHighlight));
                    startIndex += subStringValue.length();
                }
            } else {
                actionElements.add(new ActionElement(0, text.length(), startDefHighlight, endDefHighlight));
            }
            return;
        }
        catch (PatternSyntaxException patternSyntaxException) {
            return;
        }
    }

    private String handleSnippetReplace(String text, TagElement tagElement, List<ActionElement> actionElements) {
        try {
            List tagProperties = tagElement.tagProperties();
            String regExValue = this.getPropertyValue("regex", tagProperties);
            String subStringValue = this.getPropertyValue("substring", tagProperties);
            String substitution = this.getPropertyValue("replacement", tagProperties);
            Pattern regexPattern = null;
            if (regExValue != null) {
                regexPattern = Pattern.compile(regExValue);
            }
            Object modifiedText = text;
            if (regexPattern != null) {
                Matcher matcher = regexPattern.matcher((CharSequence)modifiedText);
                StringBuilder strBuild = new StringBuilder();
                int finalMatchIndex = 0;
                while (matcher.find()) {
                    finalMatchIndex = matcher.end();
                    this.modifyPrevActionItemsReplacement(matcher.start(), matcher.end(), substitution.length(), actionElements);
                    matcher.appendReplacement(strBuild, substitution);
                }
                modifiedText = strBuild.toString() + ((String)modifiedText).substring(finalMatchIndex);
            } else if (subStringValue != null) {
                int startIndex = 0;
                while ((startIndex = ((String)modifiedText).indexOf(subStringValue, startIndex)) != -1) {
                    this.modifyPrevActionItemsReplacement(startIndex, startIndex + subStringValue.length(), substitution.length(), actionElements);
                    modifiedText = ((String)modifiedText).substring(0, startIndex) + substitution + ((String)modifiedText).substring(startIndex + subStringValue.length());
                    startIndex += substitution.length();
                }
            } else {
                actionElements.clear();
                modifiedText = substitution;
            }
            return modifiedText;
        }
        catch (PatternSyntaxException patternSyntaxException) {
            return text;
        }
    }

    private void handleSnippetLink(String text, TagElement tagElement, List<ActionElement> actionElements) {
        try {
            List tagProperties = tagElement.tagProperties();
            String regExValue = this.getPropertyValue("regex", tagProperties);
            String subStringValue = this.getPropertyValue("substring", tagProperties);
            Object additionalStartTag = this.getLinkHtmlTag(tagProperties);
            Object additionalEndTag = "";
            if (((String)additionalStartTag).length() > 0) {
                additionalEndTag = "</" + (String)additionalStartTag + ">";
                additionalStartTag = "<" + (String)additionalStartTag + ">";
            }
            ASTNode target = this.getPropertyNodeValue("target", tagProperties);
            String linkRefTxt = this.getLinkRef(target);
            String startDefLink = linkRefTxt + (String)additionalStartTag;
            String endDefLink = (String)additionalEndTag + "</a>";
            Pattern regexPattern = null;
            if (regExValue != null) {
                regexPattern = Pattern.compile(regExValue);
            }
            String modifiedText = text;
            if (regexPattern != null) {
                Matcher matcher = regexPattern.matcher(modifiedText);
                while (matcher.find()) {
                    actionElements.add(new ActionElement(matcher.start(), matcher.end(), startDefLink, endDefLink));
                }
            } else if (subStringValue != null) {
                int startIndex = 0;
                while ((startIndex = modifiedText.indexOf(subStringValue, startIndex)) != -1) {
                    actionElements.add(new ActionElement(startIndex, startIndex + subStringValue.length(), startDefLink, endDefLink));
                    startIndex += subStringValue.length();
                }
            } else {
                String subText = modifiedText.trim();
                if (subText.length() < text.length()) {
                    int startIndex = text.indexOf(subText);
                    actionElements.add(new ActionElement(startIndex, startIndex + subText.length(), startDefLink, endDefLink));
                }
            }
            return;
        }
        catch (PatternSyntaxException patternSyntaxException) {
            return;
        }
    }

    private String getLinkRef(ASTNode node) {
        Object str = "";
        String refTypeName = null;
        String refMemberName = null;
        String[] refMethodParamTypes = null;
        String[] refMethodParamNames = null;
        if (node instanceof Name) {
            Name name = (Name)node;
            refTypeName = name.getFullyQualifiedName();
        } else if (node instanceof MemberRef) {
            MemberRef memberRef = (MemberRef)node;
            qualifier = memberRef.getQualifier();
            refTypeName = qualifier == null ? "" : qualifier.getFullyQualifiedName();
            refMemberName = memberRef.getName().getIdentifier();
        } else if (node instanceof MethodRef) {
            MethodRef methodRef = (MethodRef)node;
            qualifier = methodRef.getQualifier();
            refTypeName = qualifier == null ? "" : qualifier.getFullyQualifiedName();
            refMemberName = methodRef.getName().getIdentifier();
            List params = methodRef.parameters();
            int ps = params.size();
            refMethodParamTypes = new String[ps];
            refMethodParamNames = new String[ps];
            int i = 0;
            while (i < ps) {
                MethodRefParameter param = (MethodRefParameter)params.get(i);
                refMethodParamTypes[i] = ASTNodes.asString((ASTNode)param.getType());
                SimpleName paramName = param.getName();
                if (paramName != null) {
                    refMethodParamNames[i] = paramName.getIdentifier();
                }
                ++i;
            }
        }
        if (refTypeName != null) {
            str = (String)str + "<a href='";
            try {
                String scheme = "eclipse-javadoc";
                String uri = CoreJavaElementLinks.createURI(scheme, this.fElement, refTypeName, refMemberName, refMethodParamTypes);
                str = (String)str + uri;
            }
            catch (URISyntaxException e) {
                JavaManipulationPlugin.log(e);
            }
            str = (String)str + "'>";
        }
        return str;
    }

    protected String getLinkHtmlTag(List<? extends ASTNode> tagProperties) {
        return this.getLinkHtmlTag(tagProperties, "code");
    }

    protected String getLinkHtmlTag(List<? extends ASTNode> tagProperties, String defaultTag) {
        block8: {
            if (tagProperties == null) break block8;
            for (ASTNode aSTNode : tagProperties) {
                String tagValue;
                TagProperty tagProp;
                if (!(aSTNode instanceof TagProperty) || !"type".equals((tagProp = (TagProperty)aSTNode).getName())) continue;
                switch (tagValue = tagProp.getStringValue()) {
                    case "linkplain": {
                        defaultTag = "";
                        break;
                    }
                }
                break;
            }
        }
        return defaultTag;
    }

    private String getPropertyValue(String property, List<? extends ASTNode> tagProperties) {
        String defaultTag = null;
        if (tagProperties != null && property != null) {
            for (ASTNode aSTNode : tagProperties) {
                TagProperty tagProp;
                if (!(aSTNode instanceof TagProperty) || !property.equals((tagProp = (TagProperty)aSTNode).getName())) continue;
                defaultTag = tagProp.getStringValue();
                break;
            }
        }
        return defaultTag;
    }

    private ASTNode getPropertyNodeValue(String property, List<? extends ASTNode> tagProperties) {
        ASTNode defaultTag = null;
        if (tagProperties != null && property != null) {
            for (ASTNode aSTNode : tagProperties) {
                TagProperty tagProp;
                if (!(aSTNode instanceof TagProperty) || !property.equals((tagProp = (TagProperty)aSTNode).getName())) continue;
                defaultTag = tagProp.getNodeValue();
                break;
            }
        }
        return defaultTag;
    }

    private String getHighlightHtmlTag(List<? extends ASTNode> tagProperties) {
        String defaultTag;
        block14: {
            defaultTag = this.getDefaultBoldTag();
            if (tagProperties == null) break block14;
            for (ASTNode aSTNode : tagProperties) {
                String tagValue;
                TagProperty tagProp;
                if (!(aSTNode instanceof TagProperty) || !"type".equals((tagProp = (TagProperty)aSTNode).getName())) continue;
                switch (tagValue = tagProp.getStringValue()) {
                    case "bold": {
                        defaultTag = this.getDefaultBoldTag();
                        break;
                    }
                    case "italic": {
                        defaultTag = this.getDefaultItalicTag();
                        break;
                    }
                    case "highlighted": {
                        defaultTag = this.getDefaultHighlightedTag();
                        break;
                    }
                    default: {
                        defaultTag = "";
                        break;
                    }
                }
                break;
            }
        }
        return defaultTag;
    }

    protected String getDefaultBoldTag() {
        return "b";
    }

    protected String getDefaultItalicTag() {
        return "i";
    }

    protected String getDefaultHighlightedTag() {
        return "mark";
    }

    public class ActionElement {
        public int start;
        public int end;
        public String startTag;
        public String endTag;

        public ActionElement(int start, int end, String startTag, String endTag) {
            this.start = start;
            this.end = end;
            this.startTag = startTag;
            this.endTag = endTag;
        }

        public ReplacementStringIntervalStatus getIntervalStatus(int replacementIntervalStart, int replacementIntervalEnd) {
            ReplacementStringIntervalStatus intervalStatus = ReplacementStringIntervalStatus.DEFAULT;
            int startDiff = replacementIntervalStart - this.start;
            int endDiff = replacementIntervalEnd - this.end;
            if (this.end <= replacementIntervalStart) {
                intervalStatus = ReplacementStringIntervalStatus.AFTER;
            } else if (this.start >= replacementIntervalEnd) {
                intervalStatus = ReplacementStringIntervalStatus.BEFORE;
            } else if (startDiff <= 0 && endDiff >= 0) {
                intervalStatus = ReplacementStringIntervalStatus.ENCOMPASS;
            } else if (startDiff > 0 && endDiff < 0) {
                intervalStatus = ReplacementStringIntervalStatus.WITHIN;
            } else if (startDiff > 0) {
                intervalStatus = ReplacementStringIntervalStatus.POST_OVERLAP;
            } else if (endDiff < 0) {
                intervalStatus = ReplacementStringIntervalStatus.PREV_OVERLAP;
            }
            return intervalStatus;
        }
    }

    public static enum ReplacementStringIntervalStatus {
        BEFORE,
        AFTER,
        WITHIN,
        ENCOMPASS,
        PREV_OVERLAP,
        POST_OVERLAP,
        DEFAULT;

    }

    public class StringItem {
        public int index;
        public String tag;

        public StringItem(int index, String tag) {
            this.index = index;
            this.tag = tag;
        }
    }
}

