/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.cif2supremica;

import java.util.List;
import java.util.Locale;
import org.eclipse.escet.cif.cif2supremica.CifToSupremica;
import org.eclipse.escet.cif.cif2supremica.ElimEnumsOption;
import org.eclipse.escet.cif.cif2supremica.ModuleNameOption;
import org.eclipse.escet.cif.io.CifReader;
import org.eclipse.escet.cif.metamodel.cif.Specification;
import org.eclipse.escet.common.app.framework.Application;
import org.eclipse.escet.common.app.framework.Paths;
import org.eclipse.escet.common.app.framework.XmlSupport;
import org.eclipse.escet.common.app.framework.io.AppStreams;
import org.eclipse.escet.common.app.framework.options.InputFileOption;
import org.eclipse.escet.common.app.framework.options.OptionCategory;
import org.eclipse.escet.common.app.framework.options.Options;
import org.eclipse.escet.common.app.framework.options.OutputFileOption;
import org.eclipse.escet.common.app.framework.output.IOutputComponent;
import org.eclipse.escet.common.app.framework.output.OutputProvider;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Strings;
import org.w3c.dom.Document;

public class CifToSupremicaApp
extends Application<IOutputComponent> {
    public static void main(String[] args) {
        CifToSupremicaApp app = new CifToSupremicaApp();
        app.run(args, true);
    }

    public CifToSupremicaApp() {
    }

    public CifToSupremicaApp(AppStreams streams) {
        super(streams);
    }

    public String getAppName() {
        return "CIF to Supremica transformer";
    }

    public String getAppDescription() {
        return "Transforms CIF files to Supremica (*.wmod) files.";
    }

    protected int runInternal() {
        Specification spec = (Specification)((CifReader)new CifReader().init()).read();
        String absSpecPath = Paths.resolve((String)InputFileOption.getPath());
        if (this.isTerminationRequested()) {
            return 0;
        }
        String outPath = OutputFileOption.getDerivedPath((String)".cif", (String)".wmod");
        outPath = Paths.resolve((String)outPath);
        String moduleName = ModuleNameOption.getModuleName();
        if (moduleName == null && (moduleName = Paths.getFileName((String)outPath)).toLowerCase(Locale.US).endsWith(".wmod")) {
            moduleName = Strings.slice((String)moduleName, (Integer)0, (Integer)(-".wmod".length()));
        }
        boolean elimEnums = ElimEnumsOption.elimEnums();
        Document doc = CifToSupremica.transform(spec, absSpecPath, moduleName, elimEnums, () -> this.isTerminationRequested());
        if (this.isTerminationRequested()) {
            return 0;
        }
        XmlSupport.writeFile((Document)doc, (String)"Supremica", (String)outPath);
        return 0;
    }

    protected OutputProvider<IOutputComponent> getProvider() {
        return new OutputProvider();
    }

    protected OptionCategory getAllOptions() {
        OptionCategory generalCat = CifToSupremicaApp.getGeneralOptionCategory();
        List transOpts = Lists.list();
        transOpts.add(Options.getInstance(InputFileOption.class));
        transOpts.add(Options.getInstance(OutputFileOption.class));
        transOpts.add(Options.getInstance(ModuleNameOption.class));
        transOpts.add(Options.getInstance(ElimEnumsOption.class));
        List transSubCats = Lists.list();
        OptionCategory transCat = new OptionCategory("Transformation", "Transformation options.", transSubCats, transOpts);
        List cats = Lists.list((Object[])new OptionCategory[]{generalCat, transCat});
        OptionCategory options = new OptionCategory("CIF to Supremica Transformer Options", "All options for the CIF to Supremica transformer.", cats, Lists.list());
        return options;
    }
}

